package maslab.vis;

import java.awt.*;
import java.awt.geom.*;
import java.awt.image.*;
import java.util.*;

/** A container for other VisObjects that can be easily cleared. This
 * is useful for drawing something fairly complicated but that should
 * only be around temporarily. **/
public class VisSet extends VisObject
{
    ArrayList<VisObject> objects=new ArrayList<VisObject>();

    public VisSet()
    {
    }

    public synchronized void paint(VisCanvas vc, Graphics2D g, BufferedImage bi)
    {
	vc.paintObjects(bi, g, objects);
    }

    public synchronized void add(VisObject vo)
    {
	objects.add(vo);
    }

    public synchronized void clear()
    {
	objects.clear();
    }
}
