/*
 * Decompiled with CFR 0.152.
 */
package maslab.geom;

import Jama.Matrix;
import java.io.Serializable;
import java.util.ArrayList;
import maslab.geom.GLine2D;
import maslab.geom.GPoint2D;
import maslab.geom.GeomUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLineSegment2D
implements Serializable {
    public transient GLine2D line;
    public GPoint2D p1;
    public GPoint2D p2;
    public int weight;
    static final long serialVersionUID = 1001L;

    public GLineSegment2D(GPoint2D p1, GPoint2D p2) {
        this.p1 = p1;
        this.p2 = p2;
        this.line = new GLine2D(p1, p2);
    }

    public GLine2D getLine() {
        return this.line;
    }

    public GPoint2D intersectionWith(GLine2D l) {
        GPoint2D p = this.line.intersectionWith(l);
        if (p == null) {
            return null;
        }
        double a = this.line.getLineCoordinate(this.p1);
        double b = this.line.getLineCoordinate(this.p2);
        double c = this.line.getLineCoordinate(p);
        if (a < b && b < c || c < b && b < a) {
            return p;
        }
        return null;
    }

    public GPoint2D intersectionWith(GLineSegment2D seg) {
        GPoint2D p = this.line.intersectionWith(seg.line);
        if (p == null) {
            return null;
        }
        double a = this.line.getLineCoordinate(this.p1);
        double b = this.line.getLineCoordinate(this.p2);
        double c = this.line.getLineCoordinate(p);
        if (c < a && c < b || c > a && c > b) {
            return null;
        }
        a = seg.line.getLineCoordinate(seg.p1);
        b = seg.line.getLineCoordinate(seg.p2);
        c = seg.line.getLineCoordinate(p);
        if (c < a && c < b || c > a && c > b) {
            return null;
        }
        return p;
    }

    public GPoint2D closestPoint(GPoint2D p) {
        GPoint2D pclosest = this.line.pointOnLineClosestTo(p);
        double a = this.line.getLineCoordinate(this.p1);
        double b = this.line.getLineCoordinate(this.p2);
        double c = this.line.getLineCoordinate(pclosest);
        if (c < a && c < b) {
            if (a < b) {
                return this.p1;
            }
            return this.p2;
        }
        if (c > a && c > b) {
            if (a > b) {
                return this.p1;
            }
            return this.p2;
        }
        return pclosest;
    }

    public double squaredDistanceTo(GPoint2D p) {
        GPoint2D pclosest = this.closestPoint(p);
        return pclosest.squaredDistanceTo(p);
    }

    public double length() {
        return this.p1.distanceTo(this.p2);
    }

    public double distanceTo(GPoint2D p) {
        GPoint2D pclosest = this.closestPoint(p);
        return pclosest.distanceTo(p);
    }

    public GLineSegment2D transform(Matrix P) {
        assert (P.getColumnDimension() == 3);
        return new GLineSegment2D(this.p1.transform(P), this.p2.transform(P));
    }

    public static ArrayList<GLineSegment2D> transformSegments(ArrayList<GLineSegment2D> segs, Matrix P) {
        ArrayList<GLineSegment2D> outs = new ArrayList<GLineSegment2D>();
        Matrix P33 = GeomUtil.transformationMatrix33(P);
        for (GLineSegment2D seg : segs) {
            outs.add(seg.transform(P33));
        }
        return outs;
    }

    public double lengthOfProjectionOnto(GLineSegment2D seg) {
        GPoint2D pp1 = this.line.pointOnLineClosestTo(seg.p1);
        GPoint2D pp2 = this.line.pointOnLineClosestTo(seg.p2);
        double a = this.line.getLineCoordinate(this.p1);
        double c = this.line.getLineCoordinate(this.p2);
        double acmin = Math.min(a, c);
        double acmax = Math.max(a, c);
        double l0 = this.line.getLineCoordinate(pp1);
        double l1 = this.line.getLineCoordinate(pp2);
        if (l0 < acmin && l1 < acmin) {
            return 0.0;
        }
        if (l0 > acmax && l1 > acmax) {
            return 0.0;
        }
        l0 = Math.max(acmin, l0);
        l0 = Math.min(acmax, l0);
        l1 = Math.max(acmin, l1);
        l1 = Math.min(acmax, l1);
        return Math.abs(l1 - l0);
    }
}

