/*
 * Decompiled with CFR 0.152.
 */
package org.orcboard.orc;

import org.orcboard.orc.Orc;
import org.orcboard.orc.OrcConnection;
import org.orcboard.orc.Packet;
import org.orcboard.util.NativeLibraryLoader;

public class OrcNativeConnection
implements OrcConnection {
    String path;
    int fd;
    Object writeLock = new Object();

    static native int rawOpen(String var0);

    static native void rawClose(int var0);

    static native int writePacket(int var0, int var1, byte[] var2, int var3, int var4);

    static native int readFully(int var0, byte[] var1, int var2, int var3);

    public OrcNativeConnection() {
        this("/dev/orc");
    }

    public OrcNativeConnection(String path) {
        this.path = path;
        this.fd = -1;
        NativeLibraryLoader.requireNative(new String[]{"orc.jar", "camera.jar"}, "libjorc");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePacket(Packet p) {
        Object object = this.writeLock;
        synchronized (object) {
            if (this.fd < 0) {
                return;
            }
            OrcNativeConnection.writePacket(this.fd, p.getId(), p.data, p.getDataLength(), p.getChecksum());
        }
    }

    public Packet readPacket() {
        Packet p;
        while (true) {
            if (this.fd < 0) {
                System.out.println("Opening port " + this.path);
                this.fd = OrcNativeConnection.rawOpen(this.path);
                if (this.fd < 0) {
                    Orc.safesleep(333);
                    continue;
                }
            }
            if ((p = this.readPacketReal()) != null) break;
            OrcNativeConnection.rawClose(this.fd);
            this.fd = -1;
        }
        return p;
    }

    protected Packet readPacketReal() {
        byte[] header = new byte[3];
        int offset = 0;
        while (true) {
            if (OrcNativeConnection.readFully(this.fd, header, offset, 3 - offset) < 0) {
                return null;
            }
            if (header[0] == -19) break;
            if (header[1] == -19) {
                header[0] = header[1];
                header[1] = header[2];
                offset = 2;
                continue;
            }
            if (header[2] != -19) continue;
            header[0] = header[2];
            offset = 1;
        }
        int datalen = header[2] & 0xFF;
        byte[] data = new byte[datalen];
        if (OrcNativeConnection.readFully(this.fd, data, 0, datalen) < 0) {
            return null;
        }
        if (OrcNativeConnection.readFully(this.fd, header, 0, 1) < 0) {
            return null;
        }
        Packet p = new Packet(header[1] & 0xFF, data);
        int chk = header[0] & 0xFF;
        if (chk != 222 && chk != p.getChecksum()) {
            return null;
        }
        return p;
    }
}

