/*
 * Decompiled with CFR 0.152.
 */
package org.orcboard.orcspy;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.orcboard.orc.AnalogInput;
import org.orcboard.orc.DigitalInput;
import org.orcboard.orc.Orc;
import org.orcboard.orc.OrcTCPConnection;
import org.orcboard.orc.QuadPhase;
import org.orcboard.orcspy.GyroView;
import org.orcboard.orcspy.OscilloscopeView;
import org.orcboard.orcspy.PadView;
import org.orcboard.orcspy.PinConfig;
import org.orcboard.orcspy.View;
import org.orcboard.util.GetOpt;

public class OrcSpy {
    Orc orc;
    JFrame frame;
    JDesktopPane desktopPane;
    JMenuBar menuBar;
    public static final long serialVersionUID = 1001L;
    PinConfig pinConfig;
    public static Font smallFont = new Font("Dialog", 0, 9);
    ArrayList<View> views = new ArrayList();

    public OrcSpy(Orc orc) {
        int i;
        this.orc = orc;
        this.frame = new JFrame("OrcSpy");
        this.frame.setLayout(new BorderLayout());
        this.desktopPane = new JDesktopPane();
        this.desktopPane.setBackground(new Color(0, 20, 100));
        this.menuBar = new JMenuBar();
        this.frame.add((Component)this.desktopPane, "Center");
        this.frame.setJMenuBar(this.menuBar);
        JMenu m = new JMenu("File");
        this.menuBar.add(m);
        m = new JMenu("View");
        this.menuBar.add(m);
        JMenuItem jmi = new JMenuItem("OrcPad View");
        jmi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OrcSpy.this.addPadView();
            }
        });
        m.add(jmi);
        jmi = new JMenuItem("Gyro View");
        jmi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OrcSpy.this.addGyroView();
            }
        });
        m.add(jmi);
        m.addSeparator();
        JMenu sm = new JMenu("Analog Input");
        m.add(sm);
        for (int i2 = 0; i2 < 16; ++i2) {
            jmi = new JMenuItem("Analog Input " + i2);
            jmi.addActionListener(new ViewAnalogInputMenuItem(i2));
            sm.add(jmi);
        }
        String[] iads = new String[]{"Motor 0 Current", "Motor 1 Current", "Motor 2 Current", "Motor 3 Current", "Port 0 Current", "Port 1 Current", "Port 2 Current", "Battery voltage"};
        for (i = 0; i < iads.length; ++i) {
            jmi = new JMenuItem(iads[i]);
            jmi.addActionListener(new ViewAnalogInputMenuItem(i + 16));
            sm.add(jmi);
        }
        sm = new JMenu("Digital Input");
        m.add(sm);
        for (i = 0; i < 23; ++i) {
            jmi = new JMenuItem("Digital Input " + i);
            jmi.addActionListener(new ViewDigitalInputMenuItem(i));
            sm.add(jmi);
        }
        sm = new JMenu("Quadrature Phase");
        m.add(sm);
        for (i = 0; i < 4; ++i) {
            jmi = new JMenuItem("Quad Phase Input " + i);
            jmi.addActionListener(new ViewQuadPhaseInputMenuItem(i));
            sm.add(jmi);
        }
        this.frame.addWindowListener(new MyWindowListener());
        this.frame.setSize(800, 600);
        this.frame.setVisible(true);
        this.addPadView();
        this.addGyroView();
    }

    void addGyroView() {
        this.addView(new GyroView(this.orc));
    }

    void addPadView() {
        this.addView(new PadView(this.orc));
    }

    void addView(View v) {
        int bestx = Integer.MAX_VALUE;
        int besty = Integer.MAX_VALUE;
        for (View tv : this.views) {
            int py;
            JInternalFrame jc = tv.getComponent();
            int px = jc.getX();
            if (this.betterView(px, py = jc.getY() + jc.getHeight() + 1, bestx, besty) && this.viewFits(v, px, py)) {
                bestx = px;
                besty = py;
            }
            if (!this.betterView(px = jc.getX() + jc.getWidth() + 1, py = jc.getY(), bestx, besty) || !this.viewFits(v, px, py)) continue;
            bestx = px;
            besty = py;
        }
        if (bestx == Integer.MAX_VALUE) {
            bestx = 0;
            besty = 0;
        }
        v.getComponent().setLocation(bestx, besty);
        this.desktopPane.add(v.getComponent());
        v.getComponent().toFront();
        v.getComponent().grabFocus();
        this.views.add(v);
        v.getComponent().addInternalFrameListener(new MyFrameAdapter(v));
    }

    boolean betterView(int x, int y, int bestx, int besty) {
        if (x < bestx) {
            return true;
        }
        return x == bestx && y < besty;
    }

    boolean viewFits(View v, int x, int y) {
        JInternalFrame vc = v.getComponent();
        int w = vc.getWidth();
        int h = vc.getHeight();
        if (x + w > this.desktopPane.getWidth() || y + h > this.desktopPane.getHeight()) {
            return false;
        }
        for (View tv : this.views) {
            JInternalFrame jc = tv.getComponent();
            int x1 = jc.getX();
            int x2 = jc.getX() + jc.getWidth();
            int y1 = jc.getY();
            int y2 = jc.getY() + jc.getHeight();
            if (x > x2 || y > y2 || x + w < x1 || y + h < y1) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        Orc orc = null;
        GetOpt opt = new GetOpt();
        opt.parse(args);
        ArrayList<String> extraArgs = opt.getExtraArgs();
        if (extraArgs.size() > 0) {
            String host = extraArgs.get(0);
            OrcTCPConnection con = new OrcTCPConnection(host, 7000);
            orc = new Orc(con);
        } else {
            orc = Orc.makeOrc();
        }
        OrcSpy orcspy = new OrcSpy(orc);
    }

    class MyWindowListener
    extends WindowAdapter {
        MyWindowListener() {
        }

        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }

    class MyFrameAdapter
    extends InternalFrameAdapter {
        View view;

        public MyFrameAdapter(View view) {
            this.view = view;
        }

        public void internalFrameClosing(InternalFrameEvent e) {
            OrcSpy.this.views.remove(this.view);
        }
    }

    class ViewQuadPhaseInputMenuItem
    implements ActionListener {
        int port;

        ViewQuadPhaseInputMenuItem(int port) {
            this.port = port;
        }

        public void actionPerformed(ActionEvent e) {
            OrcSpy.this.addView(new OscilloscopeView(new QuadPhase(OrcSpy.this.orc, this.port)));
        }
    }

    class ViewDigitalInputMenuItem
    implements ActionListener {
        int port;

        ViewDigitalInputMenuItem(int port) {
            this.port = port;
        }

        public void actionPerformed(ActionEvent e) {
            OrcSpy.this.addView(new OscilloscopeView(new DigitalInput(OrcSpy.this.orc, this.port)));
        }
    }

    class ViewAnalogInputMenuItem
    implements ActionListener {
        int port;

        ViewAnalogInputMenuItem(int port) {
            this.port = port;
        }

        public void actionPerformed(ActionEvent e) {
            OrcSpy.this.addView(new OscilloscopeView(new AnalogInput(OrcSpy.this.orc, this.port)));
        }
    }
}

