/*
 * Decompiled with CFR 0.152.
 */
package maslab.data;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import maslab.data.DataSource;
import maslab.util.Logger;

public class DataLogWriter {
    BufferedWriter plog;
    BufferedWriter pchn;
    int recordsWritten = 0;
    Logger log = new Logger(this);

    public DataLogWriter(String path) throws IOException {
        this.plog = new BufferedWriter(new FileWriter(path + ".log"));
        this.pchn = new BufferedWriter(new FileWriter(path + ".chn"));
    }

    public void close() throws IOException {
        this.plog.close();
        this.pchn.close();
    }

    public int getRecordsWritten() {
        return this.recordsWritten;
    }

    public void addDataSource(DataSource s) {
        s.addDataLogWriter(this);
        try {
            this.pchn.write(String.format("%s\t%s\t:\t%s\n", s.getChannelName(), s.getClass().getName(), s.getParameters()));
            this.pchn.flush();
        }
        catch (IOException ex) {
            this.log.error("Couldn't log data", ex);
        }
    }

    public void writeEvent(DataSource source, double timeStamp, String data) {
        try {
            this.plog.write(String.format("%.3f\t%s\t:\t%s\n", timeStamp, source.getChannelName(), data));
            ++this.recordsWritten;
        }
        catch (IOException ex) {
            this.log.error("Couldn't log data", ex);
        }
    }
}

