/*
 * Decompiled with CFR 0.152.
 */
package maslab.data;

import java.util.ArrayList;
import maslab.data.DataEvent;
import maslab.data.DataListener;
import maslab.data.DataLogWriter;
import maslab.data.SimpleProperties;

public abstract class DataSource {
    protected ArrayList<DataListener> dataListeners = new ArrayList();
    protected ArrayList<DataLogWriter> logWriters = new ArrayList();
    protected String channelName;

    public DataSource(String channelName) {
        this.channelName = channelName;
    }

    public synchronized void addDataListener(DataListener l) {
        if (!this.dataListeners.contains(l)) {
            this.dataListeners.add(l);
        }
    }

    public synchronized void removeDataListener(DataListener l) {
        this.dataListeners.remove(l);
    }

    synchronized void addDataLogWriter(DataLogWriter l) {
        if (!this.logWriters.contains(l)) {
            this.logWriters.add(l);
        }
    }

    public void notifyLogWriters(double timestamp, String data) {
        for (DataLogWriter l : this.logWriters) {
            l.writeEvent(this, timestamp, data);
        }
    }

    protected synchronized void notifyDataListeners(DataEvent e) {
        for (DataListener l : this.dataListeners) {
            l.processDataEvent(this, e);
        }
    }

    public abstract DataEvent stringToEvent(double var1, String var3);

    public abstract String getParameters();

    public abstract void setParameters(String var1);

    public String getChannelName() {
        return this.channelName;
    }

    public SimpleProperties parseProperties(String data) {
        String[] toks;
        SimpleProperties sp = new SimpleProperties();
        for (String t : toks = data.split("\\s+")) {
            int equalpos = t.indexOf(61);
            if (equalpos < 0) {
                sp.put(t, "1");
                continue;
            }
            String key = t.substring(0, equalpos);
            String val = t.substring(equalpos + 1);
            sp.put(key, val);
        }
        return sp;
    }

    public static final String[] fsplit(String s, int maxtoks) {
        String[] out = new String[maxtoks];
        int outidx = 0;
        int pos = 0;
        int len = s.length();
        while (pos < len && outidx < maxtoks) {
            while (pos < len && s.charAt(pos) == '\t' || s.charAt(pos) == ' ') {
                ++pos;
            }
            int start = pos;
            while (pos < len && s.charAt(pos) != '\t' && s.charAt(pos) != ' ') {
                ++pos;
            }
            int end = pos;
            out[outidx++] = s.substring(start, end);
        }
        return out;
    }

    public static final double parseDouble(String s) {
        double v = 0.0;
        int len = s.length();
        boolean minus = false;
        boolean decimal = false;
        double fraction = 0.1;
        block4: for (int pos = 0; pos < len; ++pos) {
            char c = s.charAt(pos);
            switch (c) {
                case '-': {
                    minus = true;
                    continue block4;
                }
                case '.': {
                    decimal = true;
                    continue block4;
                }
                default: {
                    int digit = c - 48;
                    if (decimal) {
                        v += (double)digit * fraction;
                        fraction *= 0.1;
                        continue block4;
                    }
                    v *= 10.0;
                    v += (double)digit;
                }
            }
        }
        return v;
    }
}

