/*
 * Decompiled with CFR 0.152.
 */
package maslab.util;

import java.awt.Font;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import maslab.util.Logger;
import maslab.util.LoggerPublisher;
import maslab.util.StringUtil;

public class JLoggerPublisher
extends JScrollPane {
    static final long serialVersionUID = 1001L;
    JTextArea textArea = new JTextArea();
    boolean tailing = true;
    LoggerPublisher logPublisher = new MyLoggerPublisher();

    public JLoggerPublisher() {
        Logger.addPublisher(this.logPublisher);
        this.textArea.setEditable(false);
        this.textArea.setRows(4);
        this.textArea.setFont(new Font("Monospaced", 0, 10));
        this.setViewportView(this.textArea);
    }

    public LoggerPublisher getPublisher() {
        return this.logPublisher;
    }

    class MyLoggerPublisher
    extends LoggerPublisher {
        MyLoggerPublisher() {
        }

        public void publishUnconditional(String name, int level, String message) {
            long nowTime = System.currentTimeMillis();
            double elapsedTime = (double)(nowTime - Logger.startTime) / 1000.0;
            String levelName = Logger.levelToString(level);
            JLoggerPublisher.this.textArea.append(StringUtil.padRight(name, 16, ' ') + StringUtil.padLeft(StringUtil.formatDouble(elapsedTime, 3), 10, ' ') + " " + StringUtil.padRight(levelName, 10, ' ') + message + "\n");
            JScrollBar vScroll = JLoggerPublisher.this.getVerticalScrollBar();
            if (JLoggerPublisher.this.tailing) {
                vScroll.setValue(vScroll.getMaximum());
            }
        }
    }
}

