/*
 * Decompiled with CFR 0.152.
 */
package org.orcboard.orc;

import org.orcboard.orc.Orc;

public class PWM {
    Orc orc;
    int port;

    public PWM(Orc orc, int port) {
        this.orc = orc;
        this.port = port;
        orc.setPinMode(port, Orc.PinMode.PWM);
    }

    public void setPWM(int val) {
        assert (val >= 0 && val <= 65535);
        this.orc.doTransactionRetryVoid(new byte[]{12, (byte)this.port, (byte)(val >> 8), (byte)(val & 0xFF)});
    }

    public void set(double v) {
        this.setPWM((int)(v * 65535.0));
    }

    public void setClockDivider(int divider) {
        int chn = this.port / 4;
        this.orc.doTransactionRetryVoid(new byte[]{20, (byte)chn, (byte)(divider & 0xFF)});
    }
}

