/*
 * Decompiled with CFR 0.152.
 */
package org.orcboard.orc;

public class Packet {
    public int id;
    public byte[] data;

    Packet(int id, byte[] data) {
        this.id = id;
        this.data = data;
    }

    public int getId() {
        return this.id;
    }

    public int getDataLength() {
        return this.data.length;
    }

    public int getChecksum() {
        byte chk = -19;
        chk = this.updateChecksum((byte)this.getId(), chk);
        chk = this.updateChecksum((byte)(this.data.length & 0xFF), chk);
        for (int i = 0; i < this.data.length; ++i) {
            chk = this.updateChecksum(this.data[i], chk);
        }
        return chk & 0xFF;
    }

    protected byte updateChecksum(byte v, byte chk) {
        return (byte)((chk << 1) + (v & 0xFF) + ((chk & 0x80) > 0 ? 1 : 0));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Packet \n");
        sb.append("  id=" + this.id);
        int block = 16;
        for (int i = 0; i < this.data.length; ++i) {
            if (i % block == 0) {
                sb.append(String.format("  %04X : ", i));
            }
            sb.append(String.format("%02X ", this.data[i]));
            if (i % block != block - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public int get1(int offset) {
        return this.data[offset] & 0xFF;
    }

    public int get2(int offset) {
        return ((this.data[offset] & 0xFF) << 8) + (this.data[offset + 1] & 0xFF);
    }
}

