/*
 * Decompiled with CFR 0.152.
 */
package org.orcboard.orc;

import org.orcboard.orc.Orc;

public class UltrasoundSRF04 {
    int pulsePin;
    int echoPin;
    Orc orc;

    public UltrasoundSRF04(Orc orc, int pulsePin, int echoPin) {
        this.orc = orc;
        this.pulsePin = pulsePin;
        this.echoPin = echoPin;
        orc.setPinMode(pulsePin, Orc.PinMode.DIGOUT);
        orc.setPinMode(echoPin, Orc.PinMode.DIGIN);
        orc.setDigitalOutput(pulsePin, 0);
    }

    public double read() {
        int ticks = this.readIntegrator();
        return (double)ticks * 1.6573E-4;
    }

    protected int readIntegrator() {
        this.orc.integratorAcquire();
        this.orc.integratorSetInput(this.echoPin);
        this.orc.setDigitalOutput(this.pulsePin, 1);
        this.orc.setDigitalOutput(this.pulsePin, 0);
        int oldv = 0;
        int v = 1;
        while (v != oldv) {
            oldv = v;
            v = this.orc.integratorRead();
        }
        this.orc.integratorRelease();
        return v;
    }

    static void safesleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        Orc orc = Orc.makeOrc();
        UltrasoundSRF04 ranger = new UltrasoundSRF04(orc, 17, 16);
        while (true) {
            System.out.println(ranger.read());
        }
    }
}

