/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.BaseVideoFrame;
import au.edu.jcu.v4l4j.DeviceInfo;
import au.edu.jcu.v4l4j.FrameGrabber;
import au.edu.jcu.v4l4j.FrameInterval;
import au.edu.jcu.v4l4j.ImageFormat;
import au.edu.jcu.v4l4j.PushSource;
import au.edu.jcu.v4l4j.PushSourceCallback;
import au.edu.jcu.v4l4j.Tuner;
import au.edu.jcu.v4l4j.VideoFrame;
import au.edu.jcu.v4l4j.exceptions.ImageFormatException;
import au.edu.jcu.v4l4j.exceptions.InvalidValue;
import au.edu.jcu.v4l4j.exceptions.NoTunerException;
import au.edu.jcu.v4l4j.exceptions.StateException;
import au.edu.jcu.v4l4j.exceptions.UnsupportedMethod;
import au.edu.jcu.v4l4j.exceptions.V4L4JException;
import java.util.Vector;

abstract class AbstractGrabber
implements FrameGrabber {
    protected static final int RAW_GRABBER = 0;
    protected static final int JPEG_GRABBER = 1;
    protected static final int RGB24_GRABBER = 2;
    protected static final int BGR24_GRABBER = 3;
    protected static final int YUV_GRABBER = 4;
    protected static final int YVU_GRABBER = 5;
    protected DeviceInfo dInfo;
    private int width;
    private int height;
    private int channel;
    private int standard;
    protected int nbV4LBuffers;
    protected Vector<BaseVideoFrame> videoFrames;
    private Vector<BaseVideoFrame> availableVideoFrames;
    protected State state;
    protected int format;
    private Tuner tuner;
    private int type;
    private long lastCapturedFrameSequence;
    private long lastCapturedFrameTimeuSec;
    private PushSource pushSource;
    private long pushSourceThreadId;
    protected long object;

    private native int doInit(long var1, int var3, int var4, int var5, int var6, int var7, int var8) throws V4L4JException;

    private native void start(long var1) throws V4L4JException;

    protected native void setQuality(long var1, int var3);

    private native int getBufferSize(long var1);

    private native int fillBuffer(long var1, byte[] var3) throws V4L4JException;

    private native void stop(long var1);

    private native void doRelease(long var1);

    private native void doSetFrameIntv(long var1, int var3, int var4) throws InvalidValue;

    private native int doGetFrameIntv(long var1, int var3);

    protected AbstractGrabber(DeviceInfo deviceInfo, long l, int n, int n2, int n3, int n4, Tuner tuner, ImageFormat imageFormat, int n5) throws ImageFormatException {
        if (imageFormat == null) {
            throw new ImageFormatException("The image format can not be null");
        }
        this.state = new State();
        this.dInfo = deviceInfo;
        this.object = l;
        this.width = n;
        this.height = n2;
        this.channel = n3;
        this.standard = n4;
        this.format = imageFormat.getIndex();
        this.tuner = tuner;
        this.type = n5;
        this.nbV4LBuffers = 0;
        this.videoFrames = new Vector();
        this.pushSource = null;
        this.pushSourceThreadId = 0L;
    }

    void init() throws V4L4JException {
        this.state.init();
        this.nbV4LBuffers = this.doInit(this.object, this.width, this.height, this.channel, this.standard, this.format, this.type);
        int n = this.getBufferSize(this.object);
        this.createBuffers(n);
        this.availableVideoFrames = new Vector<BaseVideoFrame>(this.videoFrames);
        this.state.commit();
    }

    protected abstract void createBuffers(int var1);

    @Override
    public int getNumberOfVideoFrames() {
        return this.nbV4LBuffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFrameInterval(int n, int n2) throws InvalidValue {
        State state = this.state;
        synchronized (state) {
            if (this.state.isStarted()) {
                throw new StateException("Invalid method call");
            }
            this.doSetFrameIntv(this.object, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FrameInterval.DiscreteInterval getFrameInterval() {
        State state = this.state;
        synchronized (state) {
            if (this.state.isStarted()) {
                throw new StateException("Invalid method call: cannot get the frame interval while capturing.");
            }
            return new FrameInterval.DiscreteInterval(this.doGetFrameIntv(this.object, 0), this.doGetFrameIntv(this.object, 1));
        }
    }

    @Override
    public final Tuner getTuner() throws NoTunerException {
        if (this.tuner == null) {
            throw new NoTunerException("This input does not have a tuner");
        }
        this.state.checkReleased();
        return this.tuner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean setPushSourceMode(PushSourceCallback pushSourceCallback) {
        State state = this.state;
        synchronized (state) {
            if (this.state.isStarted()) {
                throw new StateException("This frame grabber is already started");
            }
            if (pushSourceCallback == null) {
                this.pushSource = null;
                this.pushSourceThreadId = 0L;
            } else {
                this.pushSource = new PushSource(this, pushSourceCallback);
                this.pushSourceThreadId = this.pushSource.getThreadId();
            }
        }
        return pushSourceCallback != null;
    }

    @Override
    public final void startCapture() throws V4L4JException {
        this.state.start();
        this.start(this.object);
        this.state.commit();
        if (this.pushSource != null) {
            this.pushSource.startCapture();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseVideoFrame getAvailableVideoFrame() {
        BaseVideoFrame baseVideoFrame = null;
        Vector<BaseVideoFrame> vector = this.availableVideoFrames;
        synchronized (vector) {
            while (this.availableVideoFrames.size() == 0) {
                try {
                    this.availableVideoFrames.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new StateException("Interrupted while waiting for a video frame", interruptedException);
                }
            }
            baseVideoFrame = this.availableVideoFrames.remove(0);
        }
        return baseVideoFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final VideoFrame getVideoFrame() throws V4L4JException {
        BaseVideoFrame baseVideoFrame;
        this.state.get();
        try {
            baseVideoFrame = this.getAvailableVideoFrame();
            int n = this.fillBuffer(this.object, baseVideoFrame.getByteArray());
            baseVideoFrame.prepareForDelivery(n, this.lastCapturedFrameSequence, this.lastCapturedFrameTimeuSec);
        }
        finally {
            this.state.put();
        }
        if (this.pushSource != null && Thread.currentThread().getId() != this.pushSourceThreadId) {
            throw new UnsupportedMethod("This frame grabber is set to push mode");
        }
        return baseVideoFrame;
    }

    static synchronized void Log(String string) {
        System.out.println(Thread.currentThread().getName() + ": " + string);
        System.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void recycleVideoBuffer(BaseVideoFrame baseVideoFrame) {
        Vector<BaseVideoFrame> vector = this.availableVideoFrames;
        synchronized (vector) {
            this.availableVideoFrames.add(baseVideoFrame);
            this.availableVideoFrames.notify();
        }
    }

    @Override
    public final void stopCapture() {
        this.state.stop();
        if (this.pushSource != null) {
            this.pushSource.stopCapture();
        }
        for (BaseVideoFrame baseVideoFrame : this.videoFrames) {
            baseVideoFrame.recycle();
        }
        this.stop(this.object);
        this.state.commit();
    }

    final void release() {
        try {
            this.stopCapture();
        }
        catch (StateException stateException) {
            // empty catch block
        }
        this.state.release();
        this.doRelease(this.object);
        this.state.commit();
    }

    @Override
    public final int getHeight() {
        this.state.checkReleased();
        return this.height;
    }

    @Override
    public final int getWidth() {
        this.state.checkReleased();
        return this.width;
    }

    @Override
    public final int getChannel() {
        this.state.checkReleased();
        return this.channel;
    }

    @Override
    public final int getStandard() {
        this.state.checkReleased();
        return this.standard;
    }

    final boolean isStarted() {
        return this.state.isStarted();
    }

    static {
        try {
            System.loadLibrary("v4l4j");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("Cant load v4l4j JNI library");
            throw unsatisfiedLinkError;
        }
    }

    protected static class State {
        private int state = UNINIT;
        private int temp = UNINIT;
        private int users = 0;
        private static int UNINIT = 0;
        private static int INIT = 1;
        private static int STARTED = 2;
        private static int STOPPED = 3;
        private static int RELEASED = 4;

        public synchronized void init() {
            if (this.state != UNINIT || this.temp == INIT) {
                throw new StateException("This FrameGrabber can not be initialised again");
            }
            this.temp = INIT;
        }

        public synchronized void start() {
            if (this.state != INIT && (this.state != STOPPED || this.temp == STARTED)) {
                throw new StateException("This FrameGrabber is not initialised or stopped and can not be started");
            }
            this.temp = STARTED;
        }

        public boolean isStarted() {
            this.checkReleased();
            return this.state == STARTED && this.temp != STOPPED;
        }

        public void checkReleased() {
            if (this.state == RELEASED || this.temp == RELEASED) {
                throw new StateException("This FrameGrabber has been released");
            }
        }

        public synchronized void get() {
            if (this.state == STARTED && this.temp != STOPPED) {
                ++this.users;
            } else {
                throw new StateException("This FrameGrabber is not started and can not be used");
            }
        }

        public synchronized void put() {
            if (this.state == STARTED) {
                if (--this.users == 0) {
                    this.notify();
                }
                if (this.temp == STOPPED) {
                    throw new StateException("This framegrabber was stopped");
                }
            } else {
                throw new StateException("This FrameGrabber is not started and can not be used");
            }
        }

        public synchronized void stop() {
            if (this.state == STARTED && this.temp != STOPPED) {
                this.temp = STOPPED;
                while (this.users != 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        System.err.println("Interrupted while waiting for FrameGrabber users to complete");
                        interruptedException.printStackTrace();
                        throw new StateException("There are remaining users of this FrameGrabber and it can not be stopped");
                    }
                }
            } else {
                throw new StateException("This FrameGrabber is not started and can not be stopped");
            }
        }

        public synchronized void release() {
            if (this.state != INIT && (this.state != STOPPED || this.temp == RELEASED)) {
                throw new StateException("This FrameGrabber is neither initialised nor stopped and can not be released");
            }
            this.temp = RELEASED;
        }

        public synchronized void commit() {
            this.state = this.temp;
        }
    }
}

