/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.AbstractGrabber;
import au.edu.jcu.v4l4j.V4L4JDataBuffer;
import au.edu.jcu.v4l4j.V4L4JRaster;
import au.edu.jcu.v4l4j.VideoFrame;
import au.edu.jcu.v4l4j.exceptions.StateException;
import au.edu.jcu.v4l4j.exceptions.UnsupportedMethod;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.WritableRaster;

class BaseVideoFrame
implements VideoFrame {
    protected int frameLength;
    protected AbstractGrabber frameGrabber;
    protected byte[] frameBuffer;
    protected long sequenceNumber;
    protected long captureTime;
    protected V4L4JDataBuffer dataBuffer;
    protected boolean recycled;
    protected V4L4JRaster raster;
    protected BufferedImage bufferedImage;

    protected BaseVideoFrame(AbstractGrabber abstractGrabber, int n) {
        this.frameGrabber = abstractGrabber;
        this.frameBuffer = new byte[n];
        this.dataBuffer = new V4L4JDataBuffer(this.frameBuffer);
        this.raster = null;
        this.bufferedImage = null;
        this.recycled = true;
    }

    final synchronized void prepareForDelivery(int n, long l, long l2) {
        this.frameLength = n;
        this.dataBuffer.setNewFrameSize(n);
        this.sequenceNumber = l;
        this.captureTime = l2;
        this.recycled = false;
    }

    final synchronized void waitTillRecycled() throws InterruptedException {
        while (!this.recycled) {
            this.wait();
        }
    }

    final byte[] getByteArray() {
        return this.frameBuffer;
    }

    @Override
    public final synchronized int getFrameLength() {
        this.checkIfRecycled();
        return this.frameLength;
    }

    @Override
    public final synchronized byte[] getBytes() {
        this.checkIfRecycled();
        return this.frameBuffer;
    }

    @Override
    public final synchronized DataBuffer getDataBuffer() {
        this.checkIfRecycled();
        return this.dataBuffer;
    }

    @Override
    public final synchronized WritableRaster getRaster() {
        this.checkIfRecycled();
        return this.refreshRaster();
    }

    @Override
    public final synchronized BufferedImage getBufferedImage() {
        this.checkIfRecycled();
        return this.refreshBufferedImage();
    }

    @Override
    public final synchronized long getSequenceNumber() {
        this.checkIfRecycled();
        return this.sequenceNumber;
    }

    @Override
    public final synchronized long getCaptureTime() {
        this.checkIfRecycled();
        return this.captureTime;
    }

    @Override
    public final synchronized void recycle() {
        if (!this.recycled) {
            this.frameGrabber.recycleVideoBuffer(this);
            this.recycled = true;
            this.notifyAll();
        }
    }

    protected WritableRaster refreshRaster() {
        if (this.raster == null) {
            throw new UnsupportedMethod("A raster can not be generated for this image format (" + this.frameGrabber.getImageFormat().toString() + ")");
        }
        return this.raster;
    }

    protected BufferedImage refreshBufferedImage() {
        if (this.bufferedImage == null) {
            throw new UnsupportedMethod("A Bufferedimage can not be generated for this image format (" + this.frameGrabber.getImageFormat().toString() + ")");
        }
        return this.bufferedImage;
    }

    private final void checkIfRecycled() throws StateException {
        if (this.recycled) {
            throw new StateException("This video frame has been recycled");
        }
    }
}

