/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.exceptions.ControlException;
import au.edu.jcu.v4l4j.exceptions.StateException;
import au.edu.jcu.v4l4j.exceptions.UnsupportedMethod;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class Control {
    private int id;
    private String name;
    private int max;
    private int min;
    private int step;
    private int type;
    private Vector<String> names;
    private int[] values;
    private long v4l4jObject;
    private int defaultValue;
    private State state;

    private native int doGetValue(long var1, int var3) throws ControlException;

    private native int doSetValue(long var1, int var3, int var4) throws ControlException;

    Control(int n, String string, int n2, int n3, int n4, int n5, String[] stringArray, int[] nArray, long l) {
        this.id = n;
        this.name = new String(string);
        this.min = n2;
        this.max = n3;
        this.step = n4;
        this.type = n5;
        if (stringArray != null) {
            this.names = new Vector();
            for (String string2 : stringArray) {
                this.names.add(string2);
            }
        }
        this.values = nArray;
        this.defaultValue = n2 <= 0 && 0 <= n3 ? 0 : (int)Math.round((double)(n3 - n2) / 2.0) + n2;
        this.v4l4jObject = l;
        this.state = new State();
    }

    public int getValue() throws ControlException {
        int n = 0;
        this.state.get();
        if (this.type == 0) {
            this.state.put();
            return 0;
        }
        try {
            n = this.doGetValue(this.v4l4jObject, this.id);
        }
        catch (ControlException controlException) {
            this.state.put();
            throw controlException;
        }
        this.state.put();
        return n;
    }

    public int setValue(int n) throws ControlException {
        int n2 = this.defaultValue;
        this.state.get();
        n = this.type == 0 ? 0 : this.validateValue(n);
        try {
            this.doSetValue(this.v4l4jObject, this.id, n);
        }
        catch (ControlException controlException) {
            this.state.put();
            throw controlException;
        }
        try {
            n2 = this.getValue();
        }
        catch (ControlException controlException) {
            // empty catch block
        }
        this.state.put();
        return n2;
    }

    public int increaseValue() throws ControlException {
        int n = this.defaultValue;
        this.state.get();
        try {
            n = this.doGetValue(this.v4l4jObject, this.id);
        }
        catch (ControlException controlException) {
            // empty catch block
        }
        try {
            n = this.doSetValue(this.v4l4jObject, this.id, this.validateValue(n + this.step));
        }
        catch (ControlException controlException) {
            this.state.put();
            throw controlException;
        }
        this.state.put();
        return n;
    }

    public int decreaseValue() throws ControlException {
        int n = this.defaultValue;
        this.state.get();
        try {
            n = this.doGetValue(this.v4l4jObject, this.id);
        }
        catch (ControlException controlException) {
            // empty catch block
        }
        try {
            n = this.doSetValue(this.v4l4jObject, this.id, this.validateValue(n - this.step));
        }
        catch (ControlException controlException) {
            this.state.put();
            throw controlException;
        }
        this.state.put();
        return n;
    }

    public int getMaxValue() {
        State state = this.state;
        synchronized (state) {
            if (this.state.isNotReleased()) {
                return this.max;
            }
            throw new StateException("This control has been released and must not be used");
        }
    }

    public int getMinValue() {
        State state = this.state;
        synchronized (state) {
            if (this.state.isNotReleased()) {
                return this.min;
            }
            throw new StateException("This control has been released and must not be used");
        }
    }

    public String getName() {
        State state = this.state;
        synchronized (state) {
            if (this.state.isNotReleased()) {
                return this.name;
            }
            throw new StateException("This control has been released and must not be used");
        }
    }

    public int getStepValue() {
        State state = this.state;
        synchronized (state) {
            if (this.state.isNotReleased()) {
                return this.step;
            }
            throw new StateException("This control has been released and must not be used");
        }
    }

    public int getType() {
        State state = this.state;
        synchronized (state) {
            if (this.state.isNotReleased()) {
                return this.type;
            }
            throw new StateException("This control has been released and must not be used");
        }
    }

    public int getDefaultValue() {
        State state = this.state;
        synchronized (state) {
            if (this.state.isNotReleased()) {
                return this.defaultValue;
            }
            throw new StateException("This control has been released and must not be used");
        }
    }

    public List<Integer> getDiscreteValues() {
        if (this.type != 3 && this.values != null) {
            throw new UnsupportedMethod("This control does not accept discrete values");
        }
        this.state.get();
        Vector<Integer> vector = new Vector<Integer>();
        for (int n : this.values) {
            vector.add(new Integer(n));
        }
        this.state.put();
        return vector;
    }

    public List<String> getDiscreteValueNames() {
        if (this.type != 3 && this.names != null) {
            throw new UnsupportedMethod("This control does not have discrete values");
        }
        this.state.get();
        Vector<String> vector = new Vector<String>(this.names);
        this.state.put();
        return vector;
    }

    public Map<String, Integer> getDiscreteValuesMap() {
        if (this.type != 3 && this.names != null) {
            throw new UnsupportedMethod("This control does not have discrete values");
        }
        this.state.get();
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        for (int i = 0; i < this.names.size(); ++i) {
            hashtable.put(this.names.get(i), this.values[i]);
        }
        this.state.put();
        return hashtable;
    }

    void release() {
        this.state.release();
    }

    private int validateValue(int n) throws ControlException {
        if (n < this.min || n > this.max) {
            throw new ControlException("The value '" + n + "' is outside the allowed range");
        }
        return n;
    }

    private class State {
        private int state = this.INIT;
        private int temp = this.INIT;
        private int users = 0;
        private int INIT = 0;
        private int RELEASED = 1;

        public synchronized void get() {
            if (this.state == this.INIT && this.temp != this.RELEASED) {
                ++this.users;
            } else {
                throw new StateException("This Control has been released and must not be used");
            }
        }

        public synchronized void put() {
            if (this.state == this.INIT) {
                if (--this.users == 0 && this.temp == this.RELEASED) {
                    this.notify();
                }
            } else {
                throw new StateException("This Control has been released and must not be used");
            }
        }

        public boolean isNotReleased() {
            return this.state == this.INIT && this.temp != this.RELEASED;
        }

        public synchronized void release() {
            if (this.state == this.INIT && this.temp != this.RELEASED) {
                this.temp = this.RELEASED;
                while (this.users != 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        System.err.println("Interrupted while waiting for Control users to complete");
                        interruptedException.printStackTrace();
                        throw new StateException("There are remaining users of this Control and it can not be stopped");
                    }
                }
            }
        }

        public synchronized void commit() {
            this.state = this.temp;
        }
    }
}

