/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.Control;
import au.edu.jcu.v4l4j.exceptions.StateException;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class ControlList {
    private Hashtable<String, Control> controls;
    private boolean released;

    ControlList(Hashtable<String, Control> hashtable) {
        this.controls = hashtable;
        this.released = false;
    }

    ControlList(Control[] controlArray) {
        this.controls = new Hashtable();
        for (Control control : controlArray) {
            this.controls.put(control.getName(), control);
        }
        this.released = false;
    }

    public synchronized Hashtable<String, Control> getTable() {
        this.checkReleased();
        return new Hashtable<String, Control>(this.controls);
    }

    public synchronized List<Control> getList() {
        this.checkReleased();
        return new Vector<Control>(this.controls.values());
    }

    public synchronized Control getControl(String string) {
        this.checkReleased();
        return this.controls.get(string);
    }

    synchronized void release() {
        this.released = true;
        for (Control control : this.controls.values()) {
            control.release();
        }
    }

    private void checkReleased() {
        if (this.released) {
            throw new StateException("The control list has been released and must not be used");
        }
    }
}

