/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.FrameInterval;
import au.edu.jcu.v4l4j.ImageFormat;
import au.edu.jcu.v4l4j.ImageFormatList;
import au.edu.jcu.v4l4j.InputInfo;
import au.edu.jcu.v4l4j.exceptions.StateException;
import au.edu.jcu.v4l4j.exceptions.V4L4JException;
import java.util.List;
import java.util.Vector;

public class DeviceInfo {
    private String name;
    private String deviceFile;
    private List<InputInfo> inputs = new Vector<InputInfo>();
    private ImageFormatList formats;
    private long object;
    private boolean released;

    private native void getInfo(long var1);

    private native void doRelease(long var1);

    private native FrameInterval doListIntervals(long var1, int var3, int var4, int var5);

    public synchronized String getName() {
        this.checkRelease();
        return this.name;
    }

    public synchronized String getDeviceFile() {
        this.checkRelease();
        return this.deviceFile;
    }

    public synchronized List<InputInfo> getInputs() {
        this.checkRelease();
        return new Vector<InputInfo>(this.inputs);
    }

    public synchronized ImageFormatList getFormatList() {
        this.checkRelease();
        return this.formats;
    }

    public synchronized FrameInterval listIntervals(ImageFormat imageFormat, int n, int n2) {
        this.checkRelease();
        return this.doListIntervals(this.object, imageFormat.getIndex(), n, n2);
    }

    DeviceInfo(long l, String string) throws V4L4JException {
        this.deviceFile = string;
        this.getInfo(l);
        this.object = l;
    }

    synchronized void release() {
        this.doRelease(this.object);
    }

    private void checkRelease() throws StateException {
        if (this.released) {
            throw new StateException("The video device object has been released");
        }
    }

    static {
        try {
            System.loadLibrary("v4l4j");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("Cant load v4l4j JNI library");
            throw unsatisfiedLinkError;
        }
    }
}

