/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.exceptions.UnsupportedMethod;
import java.util.List;
import java.util.Vector;

public class FrameInterval {
    private final Type type;
    private List<DiscreteInterval> discreteValues;
    private StepwiseInterval stepwiseInterval;

    private native int doGetFrameIntvType(int var1, long var2);

    private native void doGetDiscrete(int var1, long var2);

    private native void doGetStepwise(int var1, long var2);

    FrameInterval(int n, long l) {
        int n2;
        switch (n) {
            case 3: {
                n2 = 0;
                break;
            }
            case 4: {
                n2 = 1;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
            default: {
                try {
                    n2 = this.doGetFrameIntvType(n, l);
                    break;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.err.println("There was an error checking the supported interval types.\nPlease report this error to thev4l4j mailing list.\nSee REAME file for information on reporting bugs");
                    this.type = Type.UNSUPPORTED;
                    return;
                }
            }
        }
        try {
            if (n2 == 1) {
                this.discreteValues = new Vector<DiscreteInterval>();
                this.doGetDiscrete(n, l);
            } else if (n2 == 2) {
                this.doGetStepwise(n, l);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("There was an error checking the supported intervals.\nPlease report this error to thev4l4j mailing list.\nSee REAME file for information on reporting bugs");
            this.type = Type.UNSUPPORTED;
            return;
        }
        this.type = n2 == 0 ? Type.UNSUPPORTED : (n2 == 1 ? Type.DISCRETE : Type.STEPWISE);
    }

    public Type getType() {
        return this.type;
    }

    public List<DiscreteInterval> getDiscreteIntervals() {
        if (this.type != Type.DISCRETE) {
            throw new UnsupportedMethod("Supported intervals are not discrete");
        }
        return new Vector<DiscreteInterval>(this.discreteValues);
    }

    public StepwiseInterval getStepwiseInterval() {
        if (this.type != Type.STEPWISE) {
            throw new UnsupportedMethod("Supported interval is not continuous");
        }
        return this.stepwiseInterval;
    }

    public String toString() {
        String string;
        if (this.type == Type.DISCRETE) {
            string = "";
            for (DiscreteInterval discreteInterval : this.discreteValues) {
                string = string + discreteInterval.toString() + " - ";
            }
        } else {
            string = this.type == Type.STEPWISE ? this.stepwiseInterval.toString() : "no frame interval information";
        }
        return string;
    }

    public static class StepwiseInterval {
        public final DiscreteInterval minIntv;
        public final DiscreteInterval maxIntv;
        public final DiscreteInterval stepIntv;

        private StepwiseInterval(int n, int n2, int n3, int n4, int n5, int n6) {
            this.minIntv = new DiscreteInterval(n, n2);
            this.maxIntv = new DiscreteInterval(n3, n4);
            this.stepIntv = new DiscreteInterval(n5, n6);
        }

        public DiscreteInterval getMinInterval() {
            return this.minIntv;
        }

        public DiscreteInterval getMaxInterval() {
            return this.maxIntv;
        }

        public DiscreteInterval getStepInterval() {
            return this.stepIntv;
        }

        public String toString() {
            return this.minIntv + " - " + this.maxIntv + " - " + this.stepIntv;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.maxIntv == null ? 0 : this.maxIntv.hashCode());
            n = 31 * n + (this.minIntv == null ? 0 : this.minIntv.hashCode());
            n = 31 * n + (this.stepIntv == null ? 0 : this.stepIntv.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof StepwiseInterval)) {
                return false;
            }
            StepwiseInterval stepwiseInterval = (StepwiseInterval)object;
            if (this.maxIntv == null ? stepwiseInterval.maxIntv != null : !this.maxIntv.equals(stepwiseInterval.maxIntv)) {
                return false;
            }
            if (this.minIntv == null ? stepwiseInterval.minIntv != null : !this.minIntv.equals(stepwiseInterval.minIntv)) {
                return false;
            }
            return !(this.stepIntv == null ? stepwiseInterval.stepIntv != null : !this.stepIntv.equals(stepwiseInterval.stepIntv));
        }
    }

    public static class DiscreteInterval {
        public final int numerator;
        public final int denominator;

        DiscreteInterval(int n, int n2) {
            this.numerator = n;
            this.denominator = n2;
        }

        public int getNum() {
            return this.numerator;
        }

        public int getDenom() {
            return this.denominator;
        }

        public String toString() {
            return this.numerator + "/" + this.denominator;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.denominator;
            n = 31 * n + this.numerator;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof DiscreteInterval)) {
                return false;
            }
            DiscreteInterval discreteInterval = (DiscreteInterval)object;
            if (this.denominator != discreteInterval.denominator) {
                return false;
            }
            return this.numerator == discreteInterval.numerator;
        }
    }

    public static enum Type {
        UNSUPPORTED,
        DISCRETE,
        STEPWISE;

    }
}

