/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.ImageFormat;
import java.util.List;
import java.util.Vector;

public class ImageFormatList {
    private List<ImageFormat> formats = new Vector<ImageFormat>();
    private List<ImageFormat> JPEGformats = new Vector<ImageFormat>();
    private List<ImageFormat> RGBformats = new Vector<ImageFormat>();
    private List<ImageFormat> BGRformats = new Vector<ImageFormat>();
    private List<ImageFormat> YUV420formats = new Vector<ImageFormat>();
    private List<ImageFormat> YVU420formats = new Vector<ImageFormat>();

    private native void listFormats(long var1);

    ImageFormatList(long l) {
        this.listFormats(l);
        this.sortLists();
    }

    private void sortLists() {
        this.moveNativeFirst(this.RGBformats);
        this.moveToFirst(this.RGBformats, 7);
        this.moveToFirst(this.BGRformats, 6);
        this.moveToFirst(this.YUV420formats, 31);
        this.moveToFirst(this.YVU420formats, 17);
        this.moveNativeFirst(this.JPEGformats);
        this.moveToFirst(this.JPEGformats, 49);
    }

    private void moveToFirst(List<ImageFormat> list, int n) {
        for (ImageFormat imageFormat : list) {
            if (imageFormat.getIndex() != n) continue;
            list.remove(imageFormat);
            list.add(0, imageFormat);
            break;
        }
    }

    private void moveNativeFirst(List<ImageFormat> list) {
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (!this.formats.contains(list.get(n))) {
                list.add(list.remove(n));
                continue;
            }
            ++n;
        }
    }

    private ImageFormat getFormat(List<ImageFormat> list, String string) {
        for (ImageFormat imageFormat : list) {
            if (!imageFormat.getName().equals(string)) continue;
            return imageFormat;
        }
        return null;
    }

    private ImageFormat getFormat(List<ImageFormat> list, int n) {
        for (ImageFormat imageFormat : list) {
            if (imageFormat.getIndex() != n) continue;
            return imageFormat;
        }
        return null;
    }

    public List<ImageFormat> getNativeFormats() {
        return new Vector<ImageFormat>(this.formats);
    }

    public ImageFormat getNativeFormat(String string) {
        return this.getFormat(this.formats, string);
    }

    public ImageFormat getNativeFormat(int n) {
        return this.getFormat(this.formats, n);
    }

    public List<ImageFormat> getJPEGEncodableFormats() {
        return new Vector<ImageFormat>(this.JPEGformats);
    }

    public ImageFormat getJPEGEncodableFormat(String string) {
        return this.getFormat(this.JPEGformats, string);
    }

    public ImageFormat getJPEGEncodableFormat(int n) {
        return this.getFormat(this.JPEGformats, n);
    }

    public List<ImageFormat> getRGBEncodableFormats() {
        return new Vector<ImageFormat>(this.RGBformats);
    }

    public ImageFormat getRGBEncodableFormat(String string) {
        return this.getFormat(this.RGBformats, string);
    }

    public ImageFormat getRGBEncodableFormat(int n) {
        return this.getFormat(this.RGBformats, n);
    }

    public List<ImageFormat> getBGREncodableFormats() {
        return new Vector<ImageFormat>(this.BGRformats);
    }

    public ImageFormat getBGREncodableFormat(String string) {
        return this.getFormat(this.BGRformats, string);
    }

    public ImageFormat getBGREncodableFormat(int n) {
        return this.getFormat(this.BGRformats, n);
    }

    public List<ImageFormat> getYUVEncodableFormats() {
        return new Vector<ImageFormat>(this.YUV420formats);
    }

    public ImageFormat getYUVEncodableFormat(String string) {
        return this.getFormat(this.YUV420formats, string);
    }

    public ImageFormat getYUVEncodableFormat(int n) {
        return this.getFormat(this.YUV420formats, n);
    }

    public List<ImageFormat> getYVUEncodableFormats() {
        return new Vector<ImageFormat>(this.YVU420formats);
    }

    public ImageFormat getYVUEncodableFormat(String string) {
        return this.getFormat(this.YVU420formats, string);
    }

    public ImageFormat getYVUEncodableFormat(int n) {
        return this.getFormat(this.YVU420formats, n);
    }

    static {
        try {
            System.loadLibrary("v4l4j");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("Cant load v4l4j JNI library");
            throw unsatisfiedLinkError;
        }
    }
}

