/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.TunerInfo;
import au.edu.jcu.v4l4j.exceptions.NoTunerException;
import java.util.HashSet;
import java.util.Set;

public class InputInfo {
    private String name;
    private short type;
    private Set<Integer> supportedStandards;
    private TunerInfo tuner;
    private int index;

    private InputInfo(String string, int[] nArray, short s, TunerInfo tunerInfo, int n) {
        this.tuner = tunerInfo;
        this.supportedStandards = new HashSet<Integer>();
        for (int n2 : nArray) {
            this.supportedStandards.add(new Integer(n2));
        }
        this.type = s;
        this.name = string;
        this.index = n;
    }

    InputInfo(String string, int[] nArray, TunerInfo tunerInfo, int n) {
        this(string, nArray, 1, tunerInfo, n);
    }

    InputInfo(String string, int[] nArray, int n) {
        this(string, nArray, 2, null, n);
    }

    public String getName() {
        return this.name;
    }

    public short getType() {
        return this.type;
    }

    public Set<Integer> getSupportedStandards() {
        return this.supportedStandards;
    }

    public TunerInfo getTunerInfo() throws NoTunerException {
        if (this.tuner == null) {
            throw new NoTunerException("No tuner connected to this input");
        }
        return this.tuner;
    }

    public boolean hasTuner() {
        return this.tuner != null;
    }

    public int getIndex() {
        return this.index;
    }
}

