/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.AbstractGrabber;
import au.edu.jcu.v4l4j.DeviceInfo;
import au.edu.jcu.v4l4j.ImageFormat;
import au.edu.jcu.v4l4j.JPEGVideoFrame;
import au.edu.jcu.v4l4j.Tuner;
import au.edu.jcu.v4l4j.exceptions.ImageFormatException;
import au.edu.jcu.v4l4j.exceptions.V4L4JException;

public class JPEGFrameGrabber
extends AbstractGrabber {
    private int quality;

    JPEGFrameGrabber(DeviceInfo deviceInfo, long l, int n, int n2, int n3, int n4, int n5, Tuner tuner, ImageFormat imageFormat) throws V4L4JException {
        super(deviceInfo, l, n, n2, n3, n4, tuner, imageFormat, 1);
        this.setJPGQuality(n5);
    }

    @Override
    void init() throws V4L4JException {
        try {
            super.init();
            this.setQuality(this.object, this.quality);
        }
        catch (ImageFormatException imageFormatException) {
            ImageFormatException imageFormatException2;
            if (this.format == -1) {
                String string = "v4l4j was unable to find image format supported bythe \nvideo device and that can be encoded in JPEG.\nPlease let the author know about this, so that support\nfor this video device can be improved. See \nREADME file on how to submit v4l4j reports.";
                System.out.println(string);
                imageFormatException2 = new ImageFormatException(string);
            }
            throw imageFormatException2;
        }
    }

    public void setJPGQuality(int n) {
        this.state.checkReleased();
        if (n < 0) {
            n = 0;
        }
        if (n > 100) {
            n = 100;
        }
        this.setQuality(this.object, n);
        this.quality = n;
    }

    public int getJPGQuality() {
        this.state.checkReleased();
        return this.quality;
    }

    @Override
    public ImageFormat getImageFormat() {
        this.state.checkReleased();
        return this.dInfo.getFormatList().getJPEGEncodableFormat(this.format);
    }

    @Override
    protected void createBuffers(int n) {
        int n2 = this.nbV4LBuffers;
        while (n2-- > 0) {
            this.videoFrames.add(new JPEGVideoFrame(this, n));
        }
    }
}

