/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.AbstractGrabber;
import au.edu.jcu.v4l4j.PushSourceCallback;
import au.edu.jcu.v4l4j.exceptions.StateException;
import au.edu.jcu.v4l4j.exceptions.V4L4JException;

class PushSource
implements Runnable {
    private PushSourceCallback callback;
    private AbstractGrabber frameGrabber;
    private Thread thread;
    private int state;
    private static final int STATE_STOPPED = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_ABOUT_TO_STOP = 2;

    public PushSource(AbstractGrabber abstractGrabber, PushSourceCallback pushSourceCallback) {
        if (abstractGrabber == null || pushSourceCallback == null) {
            throw new NullPointerException("the frame grabber and callback cannot be null");
        }
        this.callback = pushSourceCallback;
        this.frameGrabber = abstractGrabber;
        this.thread = new Thread((Runnable)this, "Frame pusher");
        this.state = 0;
    }

    public final synchronized void startCapture() throws V4L4JException {
        if (this.state != 0) {
            throw new StateException("The capture has already been started");
        }
        this.state = 1;
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopCapture() {
        PushSource pushSource = this;
        synchronized (pushSource) {
            if (this.state == 0 || this.state == 2) {
                return;
            }
            this.state = 2;
        }
        if (this.thread.isAlive()) {
            this.thread.interrupt();
            try {
                if (!Thread.currentThread().equals(this.thread)) {
                    this.thread.join();
                }
                this.thread = null;
            }
            catch (InterruptedException interruptedException) {
                System.err.println("interrupted while waiting for frame pusher thread to complete");
                interruptedException.printStackTrace();
                throw new StateException("interrupted while waiting for frame pusher thread to complete", interruptedException);
            }
        }
    }

    public long getThreadId() {
        return this.thread.getId();
    }

    @Override
    public final void run() {
        while (!Thread.interrupted()) {
            try {
                this.callback.nextFrame(this.frameGrabber.getVideoFrame());
            }
            catch (Exception exception) {
                try {
                    if (this.frameGrabber.isStarted()) {
                        this.callback.exceptionReceived(new V4L4JException("Exception received while grabbing next frame", exception));
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                Thread.currentThread().interrupt();
            }
        }
        AbstractGrabber.Log("exiting");
        this.state = 0;
    }
}

