/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.FrameInterval;
import au.edu.jcu.v4l4j.exceptions.UnsupportedMethod;
import java.util.List;
import java.util.Vector;

public class ResolutionInfo {
    private final Type type;
    private StepwiseResolution stepwiseObject;
    private List<DiscreteResolution> discreteValues;

    private native int doGetType(int var1, long var2);

    private native void doGetStepwise(int var1, long var2);

    private native void doGetDiscrete(int var1, long var2);

    ResolutionInfo(int n, long l) {
        int n2;
        try {
            n2 = this.doGetType(n, l);
            if (n2 == 1) {
                this.discreteValues = new Vector<DiscreteResolution>();
                this.doGetDiscrete(n, l);
            } else if (n2 == 2) {
                this.doGetStepwise(n, l);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("There was an error checking the supported resolutions.\nPlease report this error to thev4l4j mailing list.\nSee REAME file for information on reporting bugs");
            this.type = Type.UNSUPPORTED;
            return;
        }
        this.type = n2 == 0 ? Type.UNSUPPORTED : (n2 == 1 ? Type.DISCRETE : Type.STEPWISE);
    }

    public Type getType() {
        return this.type;
    }

    public List<DiscreteResolution> getDiscreteResolutions() throws UnsupportedMethod {
        if (this.type != Type.DISCRETE) {
            throw new UnsupportedMethod("Supported resolutions are not discrete");
        }
        return new Vector<DiscreteResolution>(this.discreteValues);
    }

    public StepwiseResolution getStepwiseResolution() throws UnsupportedMethod {
        if (this.type != Type.STEPWISE) {
            throw new UnsupportedMethod("Supported resolutions are not stepwsie");
        }
        return this.stepwiseObject;
    }

    public String toString() {
        String string;
        if (this.type == Type.STEPWISE) {
            string = this.stepwiseObject.toString();
        } else if (this.type == Type.DISCRETE) {
            string = "";
            for (DiscreteResolution discreteResolution : this.discreteValues) {
                string = string + discreteResolution + " - ";
            }
        } else {
            string = "no resolution information";
        }
        return string;
    }

    public static class StepwiseResolution {
        public final int minWidth;
        public final int maxWidth;
        public final int stepWidth;
        public final int minHeight;
        public final int maxHeight;
        public final int stepHeight;
        public final FrameInterval minInterval;
        public final FrameInterval maxInterval;

        StepwiseResolution(int n, int n2, int n3, int n4, int n5, int n6, FrameInterval frameInterval, FrameInterval frameInterval2) {
            this.minWidth = n;
            this.maxWidth = n3;
            this.stepWidth = n5;
            this.minHeight = n2;
            this.maxHeight = n4;
            this.stepHeight = n6;
            this.minInterval = frameInterval;
            this.maxInterval = frameInterval2;
        }

        public int getMinWidth() {
            return this.minWidth;
        }

        public int getMaxWidth() {
            return this.maxWidth;
        }

        public int getWidthStep() {
            return this.stepWidth;
        }

        public int getMinHeight() {
            return this.minHeight;
        }

        public int getMaxHeight() {
            return this.maxHeight;
        }

        public int getHeightStep() {
            return this.stepHeight;
        }

        public FrameInterval getMinResFrameInterval() {
            return this.minInterval;
        }

        public FrameInterval getMaxResFrameInterval() {
            return this.maxInterval;
        }

        public String toString() {
            return "min: " + this.minWidth + "x" + this.minHeight + " (" + this.minInterval + ") - max: " + this.maxWidth + "x" + this.maxHeight + " (" + this.maxInterval + ") - step: " + this.stepWidth + "x" + this.stepHeight + ")\n";
        }
    }

    public static class DiscreteResolution {
        public final int width;
        public final int height;
        public final FrameInterval interval;

        private DiscreteResolution(int n, int n2, FrameInterval frameInterval) {
            this.width = n;
            this.height = n2;
            this.interval = frameInterval;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public FrameInterval getFrameInterval() {
            return this.interval;
        }

        public String toString() {
            return this.width + "x" + this.height + " (" + this.interval + ")";
        }
    }

    public static enum Type {
        UNSUPPORTED,
        DISCRETE,
        STEPWISE;

    }
}

