/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.TunerInfo;
import au.edu.jcu.v4l4j.exceptions.StateException;

public class Tuner {
    private long v4l4j_object;
    private TunerInfo info;
    private int index;
    private boolean released;

    private native long getFreq(long var1, int var3);

    private native void setFreq(long var1, int var3, long var4);

    private native int getAfc(long var1, int var3);

    private native int getRssi(long var1, int var3);

    Tuner(long l, TunerInfo tunerInfo) {
        this.info = tunerInfo;
        this.index = this.info.getIndex();
        this.v4l4j_object = l;
        this.released = false;
    }

    public synchronized double getFrequency() {
        this.checkRelease();
        return (double)this.getFreq(this.v4l4j_object, this.index) * 0.0625;
    }

    public synchronized void setFrequency(double d) {
        this.checkRelease();
        long l = (long)(d / 0.0625);
        this.setFreq(this.v4l4j_object, this.index, l);
    }

    public synchronized int getAFC() {
        this.checkRelease();
        return this.getAfc(this.v4l4j_object, this.index);
    }

    public synchronized int getRSSI() {
        this.checkRelease();
        return this.getRssi(this.v4l4j_object, this.index);
    }

    public synchronized int getIndex() {
        this.checkRelease();
        return this.index;
    }

    public synchronized TunerInfo getInfo() {
        this.checkRelease();
        return this.info;
    }

    synchronized void release() {
        this.released = true;
    }

    private void checkRelease() {
        if (this.released) {
            throw new StateException("The frame grabber associated with this tuner has been already released and the tuner must not be used anymore");
        }
    }
}

