/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.Tuner;
import au.edu.jcu.v4l4j.exceptions.StateException;
import java.util.List;
import java.util.Vector;

public class TunerList {
    private Vector<Tuner> tuners;
    private boolean released;

    TunerList(List<Tuner> list) {
        this.tuners = new Vector<Tuner>(list);
        this.released = false;
    }

    public synchronized List<Tuner> getList() {
        this.checkReleased();
        return new Vector<Tuner>(this.tuners);
    }

    public synchronized Tuner getTuner(int n) {
        this.checkReleased();
        for (Tuner tuner : this.tuners) {
            if (tuner.getIndex() != n) continue;
            return tuner;
        }
        throw new ArrayIndexOutOfBoundsException("No tuner with such index");
    }

    synchronized void release() {
        this.released = true;
        for (Tuner tuner : this.tuners) {
            tuner.release();
        }
    }

    private void checkReleased() {
        if (this.released) {
            throw new StateException("The tuner list has been released and must not be used");
        }
    }
}

