/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.AbstractGrabber;
import au.edu.jcu.v4l4j.BGRFrameGrabber;
import au.edu.jcu.v4l4j.Control;
import au.edu.jcu.v4l4j.ControlList;
import au.edu.jcu.v4l4j.DeviceInfo;
import au.edu.jcu.v4l4j.ImageFormat;
import au.edu.jcu.v4l4j.ImageFormatList;
import au.edu.jcu.v4l4j.InputInfo;
import au.edu.jcu.v4l4j.JPEGFrameGrabber;
import au.edu.jcu.v4l4j.RGBFrameGrabber;
import au.edu.jcu.v4l4j.RawFrameGrabber;
import au.edu.jcu.v4l4j.Tuner;
import au.edu.jcu.v4l4j.TunerInfo;
import au.edu.jcu.v4l4j.TunerList;
import au.edu.jcu.v4l4j.YUVFrameGrabber;
import au.edu.jcu.v4l4j.YVUFrameGrabber;
import au.edu.jcu.v4l4j.exceptions.ImageFormatException;
import au.edu.jcu.v4l4j.exceptions.NoTunerException;
import au.edu.jcu.v4l4j.exceptions.ReleaseException;
import au.edu.jcu.v4l4j.exceptions.StateException;
import au.edu.jcu.v4l4j.exceptions.V4L4JException;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class VideoDevice {
    private AbstractGrabber fg;
    private DeviceInfo deviceInfo;
    private ControlList controls;
    private TunerList tuners;
    private String deviceFile;
    private State state;
    private boolean supportJPEG;
    private boolean supportRGB24;
    private boolean supportBGR24;
    private boolean supportYUV420;
    private boolean supportYVU420;
    private long v4l4jObject;

    private native long doInit(String var1) throws V4L4JException;

    private native void doRelease(long var1);

    private native Control[] doGetControlList(long var1);

    private native void doReleaseControlList(long var1);

    private native void doGetTunerActions(long var1);

    private native void doReleaseTunerActions(long var1);

    public VideoDevice(String string) throws V4L4JException {
        if (!new File(string).canRead()) {
            throw new V4L4JException("The device file is not readable");
        }
        this.state = new State();
        this.deviceFile = string;
        this.v4l4jObject = this.doInit(this.deviceFile);
        try {
            this.initDeviceInfo();
        }
        catch (V4L4JException v4L4JException) {
            this.deviceInfo = null;
            this.supportJPEG = false;
            this.supportRGB24 = false;
            this.supportBGR24 = false;
            this.supportYUV420 = false;
            this.supportYVU420 = false;
        }
    }

    private void initDeviceInfo() throws V4L4JException {
        this.deviceInfo = new DeviceInfo(this.v4l4jObject, this.deviceFile);
        ImageFormatList imageFormatList = this.deviceInfo.getFormatList();
        this.supportJPEG = imageFormatList.getJPEGEncodableFormats().size() != 0;
        this.supportRGB24 = imageFormatList.getRGBEncodableFormats().size() != 0;
        this.supportBGR24 = imageFormatList.getBGREncodableFormats().size() != 0;
        this.supportYUV420 = imageFormatList.getYUVEncodableFormats().size() != 0;
        this.supportYVU420 = imageFormatList.getYVUEncodableFormats().size() != 0;
        Vector<Tuner> vector = new Vector<Tuner>();
        this.doGetTunerActions(this.v4l4jObject);
        for (InputInfo inputInfo : this.deviceInfo.getInputs()) {
            try {
                vector.add(new Tuner(this.v4l4jObject, inputInfo.getTunerInfo()));
            }
            catch (NoTunerException noTunerException) {}
        }
        if (vector.size() != 0) {
            this.tuners = new TunerList(vector);
        }
    }

    public void release() {
        this.release(true);
    }

    public void release(boolean bl) {
        this.state.release(bl);
        if (this.tuners != null) {
            this.tuners.release();
        }
        this.doReleaseTunerActions(this.v4l4jObject);
        if (this.deviceInfo != null) {
            this.deviceInfo.release();
        }
        this.doRelease(this.v4l4jObject);
        this.state.commit();
    }

    public DeviceInfo getDeviceInfo() throws V4L4JException {
        if (this.deviceInfo != null) {
            return this.deviceInfo;
        }
        throw new V4L4JException("Error getting information about device");
    }

    public String getDevicefile() {
        return this.deviceFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ControlList getControlList() {
        VideoDevice videoDevice = this;
        synchronized (videoDevice) {
            if (this.controls == null) {
                this.state.get();
                this.controls = new ControlList(this.doGetControlList(this.v4l4jObject));
            }
            return this.controls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseControlList() {
        VideoDevice videoDevice = this;
        synchronized (videoDevice) {
            if (this.controls != null) {
                this.controls.release();
                this.doReleaseControlList(this.v4l4jObject);
                this.controls = null;
                this.state.put();
            }
        }
    }

    public boolean supportJPEGConversion() {
        return this.supportJPEG;
    }

    public boolean supportRGBConversion() {
        return this.supportRGB24;
    }

    public boolean supportBGRConversion() {
        return this.supportBGR24;
    }

    public boolean supportYUVConversion() {
        return this.supportYUV420;
    }

    public boolean supportYVUConversion() {
        return this.supportYVU420;
    }

    public JPEGFrameGrabber getJPEGFrameGrabber(int n, int n2, int n3, int n4, int n5, ImageFormat imageFormat) throws V4L4JException {
        if (!this.supportJPEG || this.deviceInfo == null) {
            throw new ImageFormatException("This video device does not support JPEG-encoding of its frames.");
        }
        if (imageFormat != null) {
            if (!this.deviceInfo.getFormatList().getJPEGEncodableFormats().contains(imageFormat)) {
                throw new ImageFormatException("The image format " + imageFormat.getName() + " cannot be JPEG " + "encoded.");
            }
        } else {
            imageFormat = this.deviceInfo.getFormatList().getJPEGEncodableFormats().get(0);
        }
        VideoDevice videoDevice = this;
        synchronized (videoDevice) {
            if (this.fg == null) {
                this.state.get();
                this.fg = new JPEGFrameGrabber(this.deviceInfo, this.v4l4jObject, n, n2, n3, n4, n5, this.findTuner(n3), imageFormat);
                try {
                    this.fg.init();
                }
                catch (V4L4JException v4L4JException) {
                    this.fg = null;
                    this.state.put();
                    throw v4L4JException;
                }
                catch (StateException stateException) {
                    this.fg = null;
                    this.state.put();
                    throw stateException;
                }
                catch (Throwable throwable) {
                    this.fg = null;
                    this.state.put();
                    throw new V4L4JException("Error", throwable);
                }
                return (JPEGFrameGrabber)this.fg;
            }
            if (this.fg.getClass().isInstance(JPEGFrameGrabber.class)) {
                return (JPEGFrameGrabber)this.fg;
            }
            this.state.put();
            throw new StateException("A FrameGrabber object already exists");
        }
    }

    public JPEGFrameGrabber getJPEGFrameGrabber(int n, int n2, int n3, int n4, int n5) throws V4L4JException {
        return this.getJPEGFrameGrabber(n, n2, n3, n4, n5, null);
    }

    public RGBFrameGrabber getRGBFrameGrabber(int n, int n2, int n3, int n4, ImageFormat imageFormat) throws V4L4JException {
        if (!this.supportRGB24 || this.deviceInfo == null) {
            throw new ImageFormatException("This video device does not support RGB-encoding of its frames.");
        }
        if (imageFormat != null) {
            if (!this.deviceInfo.getFormatList().getRGBEncodableFormats().contains(imageFormat)) {
                throw new ImageFormatException("The image format " + imageFormat.getName() + " cannot be converted to RGB24");
            }
        } else {
            imageFormat = this.deviceInfo.getFormatList().getRGBEncodableFormats().get(0);
        }
        VideoDevice videoDevice = this;
        synchronized (videoDevice) {
            if (this.fg == null) {
                this.state.get();
                this.fg = new RGBFrameGrabber(this.deviceInfo, this.v4l4jObject, n, n2, n3, n4, this.findTuner(n3), imageFormat);
                try {
                    this.fg.init();
                }
                catch (V4L4JException v4L4JException) {
                    this.fg = null;
                    this.state.put();
                    throw v4L4JException;
                }
                catch (StateException stateException) {
                    this.fg = null;
                    this.state.put();
                    throw stateException;
                }
                catch (Throwable throwable) {
                    this.fg = null;
                    this.state.put();
                    throw new V4L4JException("Error", throwable);
                }
                return (RGBFrameGrabber)this.fg;
            }
            if (this.fg.getClass().isInstance(RGBFrameGrabber.class)) {
                return (RGBFrameGrabber)this.fg;
            }
            this.state.put();
            throw new StateException("A FrameGrabber object already exists");
        }
    }

    public RGBFrameGrabber getRGBFrameGrabber(int n, int n2, int n3, int n4) throws V4L4JException {
        return this.getRGBFrameGrabber(n, n2, n3, n4, null);
    }

    public BGRFrameGrabber getBGRFrameGrabber(int n, int n2, int n3, int n4, ImageFormat imageFormat) throws V4L4JException {
        if (!this.supportBGR24 || this.deviceInfo == null) {
            throw new ImageFormatException("This video device does not support BGR-encoding of its frames.");
        }
        if (imageFormat != null) {
            if (!this.deviceInfo.getFormatList().getBGREncodableFormats().contains(imageFormat)) {
                throw new ImageFormatException("The image format " + imageFormat.getName() + " cannot be converted to BGR24");
            }
        } else {
            imageFormat = this.deviceInfo.getFormatList().getBGREncodableFormats().get(0);
        }
        VideoDevice videoDevice = this;
        synchronized (videoDevice) {
            if (this.fg == null) {
                this.state.get();
                this.fg = new BGRFrameGrabber(this.deviceInfo, this.v4l4jObject, n, n2, n3, n4, this.findTuner(n3), imageFormat);
                try {
                    this.fg.init();
                }
                catch (V4L4JException v4L4JException) {
                    this.fg = null;
                    this.state.put();
                    throw v4L4JException;
                }
                catch (StateException stateException) {
                    this.fg = null;
                    this.state.put();
                    throw stateException;
                }
                catch (Throwable throwable) {
                    this.fg = null;
                    this.state.put();
                    throw new V4L4JException("Error", throwable);
                }
                return (BGRFrameGrabber)this.fg;
            }
            if (this.fg.getClass().isInstance(BGRFrameGrabber.class)) {
                return (BGRFrameGrabber)this.fg;
            }
            this.state.put();
            throw new StateException("A FrameGrabber object already exists");
        }
    }

    public BGRFrameGrabber getBGRFrameGrabber(int n, int n2, int n3, int n4) throws V4L4JException {
        return this.getBGRFrameGrabber(n, n2, n3, n4, null);
    }

    public YUVFrameGrabber getYUVFrameGrabber(int n, int n2, int n3, int n4, ImageFormat imageFormat) throws V4L4JException {
        if (!this.supportYUV420 || this.deviceInfo == null) {
            throw new ImageFormatException("This video device does not support YUV-encoding of its frames.");
        }
        if (imageFormat != null) {
            if (!this.deviceInfo.getFormatList().getYUVEncodableFormats().contains(imageFormat)) {
                throw new ImageFormatException("The image format " + imageFormat.getName() + " cannot be converted to YUV420");
            }
        } else {
            imageFormat = this.deviceInfo.getFormatList().getYUVEncodableFormats().get(0);
        }
        VideoDevice videoDevice = this;
        synchronized (videoDevice) {
            if (this.fg == null) {
                this.state.get();
                this.fg = new YUVFrameGrabber(this.deviceInfo, this.v4l4jObject, n, n2, n3, n4, this.findTuner(n3), imageFormat);
                try {
                    this.fg.init();
                }
                catch (V4L4JException v4L4JException) {
                    this.fg = null;
                    this.state.put();
                    throw v4L4JException;
                }
                catch (StateException stateException) {
                    this.fg = null;
                    this.state.put();
                    throw stateException;
                }
                catch (Throwable throwable) {
                    this.fg = null;
                    this.state.put();
                    throw new V4L4JException("Error", throwable);
                }
                return (YUVFrameGrabber)this.fg;
            }
            if (this.fg.getClass().isInstance(YUVFrameGrabber.class)) {
                return (YUVFrameGrabber)this.fg;
            }
            this.state.put();
            throw new StateException("A FrameGrabber object already exists");
        }
    }

    public YUVFrameGrabber getYUVFrameGrabber(int n, int n2, int n3, int n4) throws V4L4JException {
        return this.getYUVFrameGrabber(n, n2, n3, n4, null);
    }

    public YVUFrameGrabber getYVUFrameGrabber(int n, int n2, int n3, int n4, ImageFormat imageFormat) throws V4L4JException {
        if (!this.supportYVU420 || this.deviceInfo == null) {
            throw new ImageFormatException("This video device does not support YVU-encoding of its frames.");
        }
        if (imageFormat != null) {
            if (!this.deviceInfo.getFormatList().getYVUEncodableFormats().contains(imageFormat)) {
                throw new ImageFormatException("The image format " + imageFormat.getName() + " cannot be converted to YVU420");
            }
        } else {
            imageFormat = this.deviceInfo.getFormatList().getYVUEncodableFormats().get(0);
        }
        VideoDevice videoDevice = this;
        synchronized (videoDevice) {
            if (this.fg == null) {
                this.state.get();
                this.fg = new YVUFrameGrabber(this.deviceInfo, this.v4l4jObject, n, n2, n3, n4, this.findTuner(n3), imageFormat);
                try {
                    this.fg.init();
                }
                catch (V4L4JException v4L4JException) {
                    this.fg = null;
                    this.state.put();
                    throw v4L4JException;
                }
                catch (StateException stateException) {
                    this.fg = null;
                    this.state.put();
                    throw stateException;
                }
                catch (Throwable throwable) {
                    this.fg = null;
                    this.state.put();
                    throw new V4L4JException("Error", throwable);
                }
                return (YVUFrameGrabber)this.fg;
            }
            if (this.fg.getClass().isInstance(YUVFrameGrabber.class)) {
                return (YVUFrameGrabber)this.fg;
            }
            this.state.put();
            throw new StateException("A FrameGrabber object already exists");
        }
    }

    public YVUFrameGrabber getYVUFrameGrabber(int n, int n2, int n3, int n4) throws V4L4JException {
        return this.getYVUFrameGrabber(n, n2, n3, n4, null);
    }

    public RawFrameGrabber getRawFrameGrabber(int n, int n2, int n3, int n4, ImageFormat imageFormat) throws V4L4JException {
        if (imageFormat == null) {
            throw new ImageFormatException("The image format can not be null");
        }
        VideoDevice videoDevice = this;
        synchronized (videoDevice) {
            if (this.fg == null) {
                this.state.get();
                this.fg = new RawFrameGrabber(this.deviceInfo, this.v4l4jObject, n, n2, n3, n4, this.findTuner(n3), imageFormat);
                try {
                    this.fg.init();
                }
                catch (V4L4JException v4L4JException) {
                    this.fg = null;
                    this.state.put();
                    throw v4L4JException;
                }
                catch (StateException stateException) {
                    this.fg = null;
                    this.state.put();
                    throw stateException;
                }
                catch (Throwable throwable) {
                    this.fg = null;
                    this.state.put();
                    throw new V4L4JException("Error", throwable);
                }
                return (RawFrameGrabber)this.fg;
            }
            if (this.fg.getClass().isInstance(RawFrameGrabber.class)) {
                return (RawFrameGrabber)this.fg;
            }
            this.state.put();
            throw new StateException("Another FrameGrabber object already exists");
        }
    }

    public RawFrameGrabber getRawFrameGrabber(int n, int n2, int n3, int n4) throws V4L4JException {
        if (this.deviceInfo == null) {
            throw new ImageFormatException("No DeviceInfo could be obtained. The device is probably used by another application");
        }
        return this.getRawFrameGrabber(n, n2, n3, n4, this.deviceInfo.getFormatList().getNativeFormats().get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseFrameGrabber() {
        VideoDevice videoDevice = this;
        synchronized (videoDevice) {
            if (this.fg != null) {
                try {
                    this.fg.release();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    throw new StateException("Cant release resources used by framegrabber", throwable);
                }
                this.fg = null;
                this.state.put();
            }
        }
    }

    public TunerList getTunerList() throws NoTunerException {
        if (this.tuners == null) {
            throw new NoTunerException("This video device does not have any tuners");
        }
        return this.tuners;
    }

    private Tuner findTuner(int n) {
        if (this.deviceInfo != null) {
            for (InputInfo inputInfo : this.deviceInfo.getInputs()) {
                if (inputInfo.getIndex() != n || !inputInfo.hasTuner()) continue;
                try {
                    return this.tuners.getTuner(inputInfo.getTunerInfo().getIndex());
                }
                catch (NoTunerException noTunerException) {
                }
            }
        }
        return null;
    }

    public static void main(String[] stringArray) throws V4L4JException {
        Object object;
        VideoDevice videoDevice = new VideoDevice(stringArray[0]);
        DeviceInfo deviceInfo = videoDevice.getDeviceInfo();
        System.out.println("name: " + deviceInfo.getName());
        System.out.println("Device file: " + deviceInfo.getDeviceFile());
        System.out.println("Supported formats:");
        for (ImageFormat iterator2 : deviceInfo.getFormatList().getNativeFormats()) {
            System.out.println("\t" + iterator2.toNiceString());
        }
        System.out.println("\tFormats that can be RGB24-converted: " + (videoDevice.supportRGBConversion() ? "" : "None"));
        if (videoDevice.supportRGBConversion()) {
            for (ImageFormat imageFormat : deviceInfo.getFormatList().getRGBEncodableFormats()) {
                System.out.println("\t\t" + imageFormat.toNiceString());
            }
        }
        System.out.println("\tFormats that can be BGR24-converted: " + (videoDevice.supportBGRConversion() ? "" : "None"));
        if (videoDevice.supportBGRConversion()) {
            for (ImageFormat imageFormat : deviceInfo.getFormatList().getBGREncodableFormats()) {
                System.out.println("\t\t" + imageFormat.toNiceString());
            }
        }
        System.out.println("\tFormats that can be YUV420-converted: " + (videoDevice.supportYUVConversion() ? "" : "None"));
        if (videoDevice.supportYUVConversion()) {
            for (ImageFormat imageFormat : deviceInfo.getFormatList().getYUVEncodableFormats()) {
                System.out.println("\t\t" + imageFormat.toNiceString());
            }
        }
        System.out.println("\tFormats that can be YVU420-converted: " + (videoDevice.supportYVUConversion() ? "" : "None"));
        if (videoDevice.supportYVUConversion()) {
            for (ImageFormat imageFormat : deviceInfo.getFormatList().getYVUEncodableFormats()) {
                System.out.println("\t\t" + imageFormat.toNiceString());
            }
        }
        System.out.println("\tFormats that can be JPEG-encoded: " + (videoDevice.supportJPEGConversion() ? "" : "None"));
        if (videoDevice.supportJPEGConversion()) {
            for (ImageFormat imageFormat : deviceInfo.getFormatList().getJPEGEncodableFormats()) {
                System.out.println("\t\t" + imageFormat.toNiceString());
            }
        }
        System.out.println("Inputs:");
        for (InputInfo inputInfo : deviceInfo.getInputs()) {
            System.out.println("\tName: " + inputInfo.getName());
            System.out.println("\tType: " + inputInfo.getType() + "(" + (inputInfo.getType() == 2 ? "Camera" : "Tuner") + ")");
            System.out.println("\tIndex: " + inputInfo.getIndex());
            System.out.println("\tSupported standards:");
            for (Integer n : inputInfo.getSupportedStandards()) {
                System.out.print("\t\t" + n);
                if (n == 1) {
                    System.out.println("(PAL)");
                    continue;
                }
                if (n == 3) {
                    System.out.println("(NTSC)");
                    continue;
                }
                if (n == 2) {
                    System.out.println("(SECAM)");
                    continue;
                }
                System.out.println("(None/Webcam)");
            }
            if (inputInfo.getType() != 1) continue;
            object = inputInfo.getTunerInfo();
            System.out.println("\tTuner");
            System.out.println("\t\tname: " + ((TunerInfo)object).getName());
            System.out.println("\t\tIndex: " + ((TunerInfo)object).getIndex());
            System.out.println("\t\tRange high: " + ((TunerInfo)object).getRangeHigh());
            System.out.println("\t\tRange low: " + ((TunerInfo)object).getRangeLow());
            System.out.println("\t\tUnit: " + ((TunerInfo)object).getUnit() + "(" + (((TunerInfo)object).getUnit() == 2 ? "MHz" : "kHz") + ")");
            System.out.println("\t\tType: " + ((TunerInfo)object).getType() + "(" + (((TunerInfo)object).getType() == 1 ? "Radio" : "TV") + ")");
        }
        List<Control> list = videoDevice.getControlList().getList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (Control)iterator.next();
            System.out.print("Control: " + ((Control)object).getName() + " - min: " + ((Control)object).getMinValue() + " - max: " + ((Control)object).getMaxValue() + " - step: " + ((Control)object).getStepValue() + " - value: ");
            try {
                System.out.println(((Control)object).getValue());
            }
            catch (V4L4JException v4L4JException) {
                System.out.println(" ERROR");
            }
        }
        videoDevice.releaseControlList();
        videoDevice.release();
    }

    static {
        try {
            System.loadLibrary("v4l4j");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("Cant load v4l4j JNI library");
            throw unsatisfiedLinkError;
        }
    }

    private static class State {
        private int state = this.INIT;
        private int temp = this.INIT;
        private int users = 0;
        private int INIT = 1;
        private int RELEASED = 2;

        public synchronized void get() {
            if (this.state == this.INIT && this.temp != this.RELEASED) {
                ++this.users;
            } else {
                throw new StateException("This VideoDevice has not been initialised or is about to be removed, and can not be used");
            }
        }

        public synchronized void put() {
            if (this.state == this.INIT) {
                if (--this.users == 0 && this.temp == this.RELEASED) {
                    this.notify();
                }
            } else {
                throw new StateException("This VideoDevice has not been initialised and can not be used");
            }
        }

        public synchronized void release() {
            this.release(true);
        }

        public synchronized void release(boolean bl) {
            int n = this.temp;
            if (this.state == this.INIT && this.temp != this.RELEASED) {
                this.temp = this.RELEASED;
                while (this.users != 0) {
                    try {
                        if (bl) {
                            this.wait();
                            continue;
                        }
                        this.temp = n;
                        throw new ReleaseException("Still in use");
                    }
                    catch (InterruptedException interruptedException) {
                        this.temp = n;
                        System.err.println("Interrupted while waiting for VideoDevice users to complete");
                        interruptedException.printStackTrace();
                        throw new StateException("There are remaining users of this VideoDevice and it can not be released");
                    }
                }
                return;
            }
            throw new StateException("This VideoDevice has not been initialised and can not be used");
        }

        public synchronized void commit() {
            this.state = this.temp;
        }
    }
}

