/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j;

import au.edu.jcu.v4l4j.AbstractGrabber;
import au.edu.jcu.v4l4j.DeviceInfo;
import au.edu.jcu.v4l4j.ImageFormat;
import au.edu.jcu.v4l4j.Tuner;
import au.edu.jcu.v4l4j.UncompressedVideoFrame;
import au.edu.jcu.v4l4j.exceptions.ImageFormatException;
import au.edu.jcu.v4l4j.exceptions.V4L4JException;

public class YUVFrameGrabber
extends AbstractGrabber {
    YUVFrameGrabber(DeviceInfo deviceInfo, long l, int n, int n2, int n3, int n4, Tuner tuner, ImageFormat imageFormat) throws ImageFormatException {
        super(deviceInfo, l, n, n2, n3, n4, tuner, imageFormat, 4);
    }

    @Override
    void init() throws V4L4JException {
        try {
            super.init();
        }
        catch (ImageFormatException imageFormatException) {
            ImageFormatException imageFormatException2;
            if (this.format == -1) {
                String string = "v4l4j was unable to find image format supported by the \nvideo device and that can be converted to YUV420.\nPlease let the author know about this, so that support\nfor this video device can be improved. See \nREADME file on how to submit v4l4j reports.";
                System.err.println(string);
                imageFormatException2 = new ImageFormatException(string);
            }
            throw imageFormatException2;
        }
    }

    @Override
    public ImageFormat getImageFormat() {
        this.state.checkReleased();
        return this.dInfo.getFormatList().getYUVEncodableFormat(this.format);
    }

    @Override
    protected void createBuffers(int n) {
        int n2 = this.nbV4LBuffers;
        while (n2-- > 0) {
            this.videoFrames.add(new UncompressedVideoFrame(this, n, null, null));
        }
    }
}

