/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j.examples;

import au.edu.jcu.v4l4j.DeviceInfo;
import au.edu.jcu.v4l4j.ImageFormat;
import au.edu.jcu.v4l4j.InputInfo;
import au.edu.jcu.v4l4j.VideoDevice;
import au.edu.jcu.v4l4j.examples.ControlViewer;
import au.edu.jcu.v4l4j.examples.JPEGViewer;
import au.edu.jcu.v4l4j.examples.RGBViewer;
import au.edu.jcu.v4l4j.exceptions.NoTunerException;
import au.edu.jcu.v4l4j.exceptions.V4L4JException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;

public class DeviceChooser
extends WindowAdapter
implements ActionListener {
    private static String v4lSysfsPath = "/sys/class/video4linux/";
    private JFrame frame = new JFrame("V4L device file selection");
    private JPanel mainPanel = new JPanel();
    private JComboBox deviceFiles;
    private DeviceInfoPane info = null;
    private int width;
    private int height;

    public DeviceChooser(String string, int n, int n2) {
        this.width = n;
        this.height = n2;
        this.deviceFiles = string == null ? new JComboBox<Object>(this.listV4LDeviceFiles()) : new JComboBox<Object>(new Object[]{string});
        this.initGUI();
        this.actionPerformed(null);
        this.deviceFiles.addActionListener(this);
        this.frame.setDefaultCloseOperation(2);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void initGUI() {
        this.frame.getContentPane().add(this.mainPanel);
        this.frame.addWindowListener(this);
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 3));
        this.deviceFiles.setAlignmentX(0.5f);
        Dimension dimension = new Dimension(120, 25);
        this.deviceFiles.setMaximumSize(dimension);
        this.mainPanel.add(this.deviceFiles);
        dimension = new Dimension(600, 500);
        this.mainPanel.setMinimumSize(dimension);
        this.mainPanel.setSize(dimension);
        this.mainPanel.setPreferredSize(dimension);
        this.mainPanel.setMaximumSize(dimension);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (this.info != null) {
            this.info.close();
        }
    }

    private Object[] listV4LDeviceFiles() {
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        File file = new File(v4lSysfsPath);
        for (String string : stringArray = file.list()) {
            if (string.indexOf("video") == -1) continue;
            vector.add("/dev/" + string);
        }
        if (vector.size() == 0) {
            System.err.println("Unable to detect any V4L device file\nSet the 'test.device' property to a valid\nvideo device file and run this program again ");
            System.exit(0);
        }
        return vector.toArray();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = (String)this.deviceFiles.getSelectedItem();
        if (this.info != null) {
            this.info.close();
            this.mainPanel.remove(this.info.getPanel());
        }
        try {
            this.info = new DeviceInfoPane(string, this);
            this.info.getPanel().setAlignmentX(0.5f);
            this.mainPanel.add(this.info.getPanel());
        }
        catch (V4L4JException v4L4JException) {
            System.out.println(v4L4JException.getMessage());
            this.info = null;
        }
        this.mainPanel.validate();
        this.mainPanel.repaint();
    }

    public void close() {
        this.frame.dispose();
    }

    public static void main(String[] stringArray) {
        final String string = System.getProperty("test.device");
        final int n = System.getProperty("test.width") != null ? Integer.parseInt(System.getProperty("test.width")) : 640;
        final int n2 = System.getProperty("test.height") != null ? Integer.parseInt(System.getProperty("test.height")) : 480;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DeviceChooser(string, n, n2);
            }
        });
    }

    public static class DeviceInfoPane
    implements ActionListener {
        private static String RGB_BUTTON_STR = "Run RGB viewer";
        private static String JPEG_BUTTON_STR = "Run JPEG viewer";
        private static String CTRL_ONLY_STR = "Run control-only viewer";
        private JPanel mainPane;
        private JPanel dataPane;
        private JPanel buttonPane;
        private JLabel name;
        private JLabel nativeFmt;
        private JLabel JPEGEncFmts;
        private JLabel RGBEncFmts;
        private JLabel BGREncFmts;
        private JLabel YUVEncFmts;
        private JLabel YVUEncFmts;
        private JLabel input;
        private JLabel inputType;
        private JLabel tunerType;
        private JLabel standard;
        private JLabel nameValue;
        private JLabel inputTypeValue;
        private JLabel tunerTypeValue;
        private JLabel nativeFmtValues;
        private JLabel JPEGEncFmtsValues;
        private JLabel RGBEncFmtsValues;
        private JLabel BGREncFmtsValues;
        private JLabel YUVEncFmtsValues;
        private JLabel YVUEncFmtsValues;
        private JComboBox inputs;
        private JComboBox standards;
        private DeviceInfo di;
        private VideoDevice vd;
        private JButton rgbView;
        private JButton jpegView;
        private DeviceChooser chooser;

        public DeviceInfoPane(String string, DeviceChooser deviceChooser) throws V4L4JException {
            this.chooser = deviceChooser;
            String string2 = "";
            this.vd = new VideoDevice(string);
            try {
                this.di = this.vd.getDeviceInfo();
            }
            catch (V4L4JException v4L4JException) {
                this.di = null;
                this.initControlsOnly();
                return;
            }
            this.mainPane = new JPanel();
            this.dataPane = new JPanel();
            this.buttonPane = new JPanel();
            this.name = new JLabel("Name :");
            this.nativeFmt = new JLabel("native image formats :");
            this.JPEGEncFmts = new JLabel("JPEG encodable formats :");
            this.RGBEncFmts = new JLabel("RGB24 encodable formats :");
            this.BGREncFmts = new JLabel("BGR24 encodable formats :");
            this.YUVEncFmts = new JLabel("YUV420 encodable formats :");
            this.YVUEncFmts = new JLabel("YVU420 encodable formats :");
            this.input = new JLabel("Inputs :");
            this.inputType = new JLabel("Input type :");
            this.tunerType = new JLabel("Tuner type :");
            this.standard = new JLabel("Standards :");
            this.nameValue = new JLabel(this.di.getName());
            for (ImageFormat object : this.di.getFormatList().getNativeFormats()) {
                string2 = string2 + (string2.equals("") ? object.getName() : " - " + object.getName());
            }
            this.nativeFmtValues = new JLabel(string2);
            string2 = "";
            for (ImageFormat imageFormat : this.di.getFormatList().getJPEGEncodableFormats()) {
                string2 = string2 + (string2.equals("") ? imageFormat.getName() : " - " + imageFormat.getName());
            }
            this.JPEGEncFmtsValues = new JLabel(string2);
            string2 = "";
            for (ImageFormat imageFormat : this.di.getFormatList().getRGBEncodableFormats()) {
                string2 = string2 + (string2.equals("") ? imageFormat.getName() : " - " + imageFormat.getName());
            }
            this.RGBEncFmtsValues = new JLabel(string2);
            string2 = "";
            for (ImageFormat imageFormat : this.di.getFormatList().getBGREncodableFormats()) {
                string2 = string2 + (string2.equals("") ? imageFormat.getName() : " - " + imageFormat.getName());
            }
            this.BGREncFmtsValues = new JLabel(string2);
            string2 = "";
            for (ImageFormat imageFormat : this.di.getFormatList().getYUVEncodableFormats()) {
                string2 = string2 + (string2.equals("") ? imageFormat.getName() : " - " + imageFormat.getName());
            }
            this.YUVEncFmtsValues = new JLabel(string2);
            string2 = "";
            for (ImageFormat imageFormat : this.di.getFormatList().getYVUEncodableFormats()) {
                string2 = string2 + (string2.equals("") ? imageFormat.getName() : " - " + imageFormat.getName());
            }
            this.YVUEncFmtsValues = new JLabel(string2);
            Vector vector = new Vector();
            for (InputInfo inputInfo : this.di.getInputs()) {
                vector.add(inputInfo.getName());
            }
            this.inputs = new JComboBox<Object>(vector.toArray());
            this.inputTypeValue = new JLabel();
            this.tunerTypeValue = new JLabel();
            this.standards = new JComboBox();
            this.rgbView = new JButton(RGB_BUTTON_STR);
            this.rgbView.addActionListener(this);
            this.jpegView = new JButton(JPEG_BUTTON_STR);
            this.jpegView.addActionListener(this);
            this.initGUI();
        }

        private void initControlsOnly() {
            this.mainPane = new JPanel();
            this.mainPane.setLayout(new BoxLayout(this.mainPane, 3));
            this.name = new JLabel("Unable to get device information");
            this.name.setAlignmentX(0.5f);
            this.rgbView = new JButton(CTRL_ONLY_STR);
            this.rgbView.setAlignmentX(0.5f);
            this.rgbView.addActionListener(this);
            this.mainPane.add(Box.createVerticalStrut(5));
            this.mainPane.add(this.name);
            this.mainPane.add(Box.createVerticalStrut(5));
            this.mainPane.add(this.rgbView);
        }

        private void initGUI() {
            this.mainPane.setLayout(new BoxLayout(this.mainPane, 3));
            Dimension dimension = new Dimension(200, 25);
            Dimension dimension2 = new Dimension(Integer.MAX_VALUE, 25);
            this.dataPane.setLayout(new SpringLayout());
            this.name.setPreferredSize(dimension);
            this.name.setMinimumSize(dimension);
            this.dataPane.add(this.name);
            this.dataPane.add(this.nameValue);
            this.nativeFmt.setPreferredSize(dimension);
            this.nativeFmt.setMinimumSize(dimension);
            this.dataPane.add(this.nativeFmt);
            this.dataPane.add(this.nativeFmtValues);
            this.RGBEncFmts.setPreferredSize(dimension);
            this.RGBEncFmts.setMinimumSize(dimension);
            this.dataPane.add(this.RGBEncFmts);
            this.dataPane.add(this.RGBEncFmtsValues);
            this.BGREncFmts.setPreferredSize(dimension);
            this.BGREncFmts.setMinimumSize(dimension);
            this.dataPane.add(this.BGREncFmts);
            this.dataPane.add(this.BGREncFmtsValues);
            this.YUVEncFmts.setPreferredSize(dimension);
            this.BGREncFmts.setMinimumSize(dimension);
            this.dataPane.add(this.YUVEncFmts);
            this.dataPane.add(this.YUVEncFmtsValues);
            this.YVUEncFmts.setPreferredSize(dimension);
            this.YVUEncFmts.setMinimumSize(dimension);
            this.dataPane.add(this.YVUEncFmts);
            this.dataPane.add(this.YVUEncFmtsValues);
            this.JPEGEncFmts.setPreferredSize(dimension);
            this.JPEGEncFmts.setMinimumSize(dimension);
            this.dataPane.add(this.JPEGEncFmts);
            this.dataPane.add(this.JPEGEncFmtsValues);
            this.input.setPreferredSize(dimension);
            this.input.setMinimumSize(dimension);
            this.dataPane.add(this.input);
            this.inputs.setMaximumSize(dimension2);
            this.inputs.setPreferredSize(dimension2);
            this.inputs.setSize(dimension2);
            this.dataPane.add(this.inputs);
            this.inputType.setPreferredSize(dimension);
            this.inputType.setMinimumSize(dimension);
            this.dataPane.add(this.inputType);
            this.dataPane.add(this.inputTypeValue);
            this.tunerType.setPreferredSize(dimension);
            this.tunerType.setMinimumSize(dimension);
            this.dataPane.add(this.tunerType);
            this.dataPane.add(this.tunerTypeValue);
            this.standard.setPreferredSize(dimension);
            this.standard.setMinimumSize(dimension);
            this.dataPane.add(this.standard);
            this.standards.setMaximumSize(dimension2);
            this.standards.setPreferredSize(dimension2);
            this.standards.setSize(dimension2);
            this.dataPane.add(this.standards);
            DeviceInfoPane.makeCompactGrid(this.dataPane, 11, 2, 1, 1, 0, 2);
            this.buttonPane.setLayout(new BoxLayout(this.buttonPane, 2));
            if (this.di.getFormatList().getRGBEncodableFormats().size() != 0) {
                this.buttonPane.add(Box.createHorizontalGlue());
                this.buttonPane.add(this.rgbView);
            }
            if (this.di.getFormatList().getJPEGEncodableFormats().size() != 0) {
                this.buttonPane.add(Box.createHorizontalGlue());
                this.buttonPane.add(this.jpegView);
            }
            if (this.di.getFormatList().getRGBEncodableFormats().size() == 0 && this.di.getFormatList().getJPEGEncodableFormats().size() == 0) {
                this.buttonPane.add(Box.createHorizontalGlue());
                this.rgbView.setText(CTRL_ONLY_STR);
                this.buttonPane.add(this.rgbView);
            }
            this.buttonPane.add(Box.createHorizontalGlue());
            this.mainPane.add(this.dataPane);
            this.mainPane.add(Box.createHorizontalStrut(5));
            this.mainPane.add(this.buttonPane);
            this.updateInput();
            this.inputs.addActionListener(this);
        }

        private void updateInput() {
            for (InputInfo inputInfo : this.di.getInputs()) {
                if (!inputInfo.getName().equals(this.inputs.getSelectedItem())) continue;
                if (inputInfo.getType() == 2) {
                    this.inputTypeValue.setText("Camera");
                    this.tunerTypeValue.setText("-");
                } else {
                    this.inputTypeValue.setText("Tuner");
                    try {
                        this.tunerTypeValue.setText(inputInfo.getTunerInfo().getName() + " - " + (inputInfo.getTunerInfo().getType() == 1 ? "Radio" : "TV"));
                    }
                    catch (NoTunerException noTunerException) {
                        // empty catch block
                    }
                }
                this.standards.removeAllItems();
                for (Integer n : inputInfo.getSupportedStandards()) {
                    if (n == 3) {
                        this.standards.addItem("NTSC");
                        continue;
                    }
                    if (n == 1) {
                        this.standards.addItem("PAL");
                        continue;
                    }
                    if (n == 2) {
                        this.standards.addItem("SECAM");
                        continue;
                    }
                    if (n != 0) continue;
                    this.standards.addItem("WEBCAM");
                }
            }
            this.dataPane.validate();
            this.dataPane.repaint();
        }

        public static void makeCompactGrid(Container container, int n, int n2, int n3, int n4, int n5, int n6) {
            SpringLayout springLayout;
            try {
                springLayout = (SpringLayout)container.getLayout();
            }
            catch (ClassCastException classCastException) {
                System.err.println("The first argument to makeCompactGrid must use SpringLayout.");
                return;
            }
            Spring spring = Spring.constant(n3);
            for (int i = 0; i < n2; ++i) {
                int n7;
                Spring spring2 = Spring.constant(0);
                for (n7 = 0; n7 < n; ++n7) {
                    spring2 = Spring.max(spring2, DeviceInfoPane.getConstraintsForCell(n7, i, container, n2).getWidth());
                }
                for (n7 = 0; n7 < n; ++n7) {
                    SpringLayout.Constraints constraints = DeviceInfoPane.getConstraintsForCell(n7, i, container, n2);
                    constraints.setX(spring);
                    constraints.setWidth(spring2);
                }
                spring = Spring.sum(spring, Spring.sum(spring2, Spring.constant(n5)));
            }
            Spring spring3 = Spring.constant(n4);
            for (int i = 0; i < n; ++i) {
                int n8;
                Spring spring4 = Spring.constant(0);
                for (n8 = 0; n8 < n2; ++n8) {
                    spring4 = Spring.max(spring4, DeviceInfoPane.getConstraintsForCell(i, n8, container, n2).getHeight());
                }
                for (n8 = 0; n8 < n2; ++n8) {
                    SpringLayout.Constraints constraints = DeviceInfoPane.getConstraintsForCell(i, n8, container, n2);
                    constraints.setY(spring3);
                    constraints.setHeight(spring4);
                }
                spring3 = Spring.sum(spring3, Spring.sum(spring4, Spring.constant(n6)));
            }
            SpringLayout.Constraints constraints = springLayout.getConstraints(container);
            constraints.setConstraint("South", spring3);
            constraints.setConstraint("East", spring);
        }

        private static SpringLayout.Constraints getConstraintsForCell(int n, int n2, Container container, int n3) {
            SpringLayout springLayout = (SpringLayout)container.getLayout();
            Component component = container.getComponent(n * n3 + n2);
            return springLayout.getConstraints(component);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JComboBox) {
                this.updateInput();
            } else if (actionEvent.getSource() instanceof JButton) {
                JButton jButton = (JButton)actionEvent.getSource();
                this.chooser.close();
                if (jButton.getText().equals(CTRL_ONLY_STR)) {
                    new ControlViewer(this.vd);
                } else {
                    int n = 0;
                    int n2 = 0;
                    if (((String)this.standards.getSelectedItem()).equals("PAL")) {
                        n = 1;
                    } else if (((String)this.standards.getSelectedItem()).equals("NTSC")) {
                        n = 3;
                    } else if (((String)this.standards.getSelectedItem()).equals("SECAM")) {
                        n = 2;
                    } else if (((String)this.standards.getSelectedItem()).equals("WEBCAM")) {
                        n = 0;
                    }
                    for (InputInfo inputInfo : this.di.getInputs()) {
                        if (!inputInfo.getName().equals((String)this.inputs.getSelectedItem())) continue;
                        n2 = inputInfo.getIndex();
                    }
                    if (jButton.getText().indexOf(RGB_BUTTON_STR) != -1) {
                        try {
                            new RGBViewer(this.vd, this.chooser.width, this.chooser.height, n, n2);
                        }
                        catch (V4L4JException v4L4JException) {
                            v4L4JException.printStackTrace();
                        }
                    } else {
                        try {
                            new JPEGViewer(this.vd, this.chooser.width, this.chooser.height, n, n2, 80);
                        }
                        catch (V4L4JException v4L4JException) {
                            v4L4JException.printStackTrace();
                        }
                    }
                }
            }
        }

        public JPanel getPanel() {
            return this.mainPane;
        }

        public void close() {
            this.vd.release();
        }
    }
}

