/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j.examples;

import au.edu.jcu.v4l4j.FrameGrabber;
import au.edu.jcu.v4l4j.ImageFormatList;
import au.edu.jcu.v4l4j.VideoDevice;
import au.edu.jcu.v4l4j.exceptions.V4L4JException;
import java.io.IOException;

public class GetFrameRate {
    public static final int captureLength = 10;
    private int inFmt;
    private int outFmt;
    private int width;
    private int height;
    private int channel;
    private int std;
    private int intv;
    private FrameGrabber fg;
    private VideoDevice vd;
    private ImageFormatList imfList;

    public GetFrameRate(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7) throws V4L4JException {
        this.inFmt = n;
        this.outFmt = n2;
        this.width = n3;
        this.height = n4;
        this.channel = n5;
        this.std = n6;
        this.intv = n7;
        try {
            this.vd = new VideoDevice(string);
            this.imfList = this.vd.getDeviceInfo().getFormatList();
            if (this.outFmt == 0) {
                this.getRawFg();
            } else if (this.outFmt == 1 && this.vd.supportJPEGConversion()) {
                this.getJPEGfg();
            } else if (this.outFmt == 2 && this.vd.supportRGBConversion()) {
                this.getRGBfg();
            } else if (this.outFmt == 3 && this.vd.supportBGRConversion()) {
                this.getBGRfg();
            } else if (this.outFmt == 4 && this.vd.supportYUVConversion()) {
                this.getYUVfg();
            } else if (this.outFmt == 5 && this.vd.supportYVUConversion()) {
                this.getYVUfg();
            } else {
                System.out.println("Unknown output format: " + this.outFmt);
                throw new V4L4JException("unknown output format");
            }
            System.out.println("Input image format: " + this.fg.getImageFormat().getName());
        }
        catch (V4L4JException v4L4JException) {
            v4L4JException.printStackTrace();
            System.out.println("Failed to instanciate the FrameGrabber (" + string + ")");
            this.vd.release();
            throw v4L4JException;
        }
        this.width = this.fg.getWidth();
        this.height = this.fg.getHeight();
        this.std = this.fg.getStandard();
        this.channel = this.fg.getChannel();
    }

    private void getJPEGfg() throws V4L4JException {
        if (this.inFmt == -1 || this.imfList.getJPEGEncodableFormat(this.inFmt) == null) {
            System.out.println("Invalid format / no capture format specified, let v4l4j find a suitable one");
            this.fg = this.vd.getJPEGFrameGrabber(this.width, this.height, this.channel, this.std, 80);
        } else {
            System.out.println("Trying input format " + this.imfList.getJPEGEncodableFormat(this.inFmt).getName());
            this.fg = this.vd.getJPEGFrameGrabber(this.width, this.height, this.channel, this.std, 80, this.imfList.getJPEGEncodableFormat(this.inFmt));
        }
        System.out.println("Output image format: JPEG");
    }

    private void getRGBfg() throws V4L4JException {
        if (this.inFmt == -1 || this.imfList.getRGBEncodableFormat(this.inFmt) == null) {
            System.out.println("Invalid format / no capture format specified, let v4l4j find a suitable one");
            this.fg = this.vd.getRGBFrameGrabber(this.width, this.height, this.channel, this.std);
        } else {
            System.out.println("Trying input format " + this.imfList.getRGBEncodableFormat(this.inFmt).getName());
            this.fg = this.vd.getRGBFrameGrabber(this.width, this.height, this.channel, this.std, this.imfList.getRGBEncodableFormat(this.inFmt));
        }
        System.out.println("Output image format: RGB");
    }

    private void getBGRfg() throws V4L4JException {
        if (this.inFmt == -1 || this.imfList.getBGREncodableFormat(this.inFmt) == null) {
            System.out.println("Invalid format / no capture format specified, let v4l4j find a suitable one");
            this.fg = this.vd.getBGRFrameGrabber(this.width, this.height, this.channel, this.std);
        } else {
            System.out.println("Trying input format " + this.imfList.getBGREncodableFormat(this.inFmt).getName());
            this.fg = this.vd.getBGRFrameGrabber(this.width, this.height, this.channel, this.std, this.imfList.getBGREncodableFormat(this.inFmt));
        }
        System.out.println("Output image format: BGR");
    }

    private void getYUVfg() throws V4L4JException {
        if (this.inFmt == -1 || this.imfList.getYUVEncodableFormat(this.inFmt) == null) {
            System.out.println("Invalid format / no capture format specified, let v4l4j find a suitable one");
            this.fg = this.vd.getYUVFrameGrabber(this.width, this.height, this.channel, this.std);
        } else {
            System.out.println("Trying input format " + this.imfList.getYUVEncodableFormat(this.inFmt).getName());
            this.fg = this.vd.getYUVFrameGrabber(this.width, this.height, this.channel, this.std, this.imfList.getYUVEncodableFormat(this.inFmt));
        }
        System.out.println("Output image format: YUV");
    }

    private void getYVUfg() throws V4L4JException {
        if (this.inFmt == -1 || this.imfList.getYVUEncodableFormat(this.inFmt) == null) {
            System.out.println("Invalid format / no capture format specified, let v4l4j find a suitable one");
            this.fg = this.vd.getYVUFrameGrabber(this.width, this.height, this.channel, this.std);
        } else {
            System.out.println("Trying input format " + this.imfList.getYVUEncodableFormat(this.inFmt).getName());
            this.fg = this.vd.getYVUFrameGrabber(this.width, this.height, this.channel, this.std, this.imfList.getYVUEncodableFormat(this.inFmt));
        }
        System.out.println("Output image format: YVU");
    }

    private void getRawFg() throws V4L4JException {
        if (this.inFmt == -1 || this.imfList.getNativeFormat(this.inFmt) == null) {
            System.out.println("Invalid format / no capture format specified, v4l4j will pick the first one");
            this.fg = this.vd.getRawFrameGrabber(this.width, this.height, this.channel, this.std);
        } else {
            System.out.println("Trying input format " + this.imfList.getNativeFormat(this.inFmt).getName());
            this.fg = this.vd.getRawFrameGrabber(this.width, this.height, this.channel, this.std, this.imfList.getNativeFormat(this.inFmt));
        }
        System.out.println("Output image format: RAW (same as input)");
    }

    private void startCapture() throws V4L4JException {
        if (this.intv != -1) {
            try {
                System.out.println("setting frame rate to " + this.intv);
                this.fg.setFrameInterval(1, this.intv);
            }
            catch (Exception exception) {
                System.out.println("Couldnt set the frame interval");
            }
        }
        try {
            this.fg.startCapture();
        }
        catch (V4L4JException v4L4JException) {
            v4L4JException.printStackTrace();
            System.out.println("Failed to start capture");
            this.vd.releaseFrameGrabber();
            this.vd.release();
            throw v4L4JException;
        }
    }

    public void startTest() throws V4L4JException {
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        this.startCapture();
        try {
            this.fg.getVideoFrame().recycle();
            System.out.println("Starting test capture at " + this.width + "x" + this.height + " for " + 10 + " seconds");
            l2 = l = System.currentTimeMillis();
            while (l2 < l + 10000L) {
                this.fg.getVideoFrame().recycle();
                ++n;
                l2 = System.currentTimeMillis();
            }
            System.out.println(" =====  TEST RESULTS  =====");
            System.out.println("\tFrames captured :" + n);
            System.out.println("\tFPS: " + (float)n / (float)(l2 / 1000L - l / 1000L));
            System.out.println(" =====  END  RESULTS  =====");
        }
        catch (V4L4JException v4L4JException) {
            v4L4JException.printStackTrace();
            System.out.println("Failed to perform test capture");
            throw v4L4JException;
        }
        finally {
            this.fg.stopCapture();
            this.vd.releaseFrameGrabber();
            this.vd.release();
        }
    }

    public static void main(String[] stringArray) throws V4L4JException, IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        String string;
        try {
            string = stringArray[0];
        }
        catch (Exception exception) {
            string = "/dev/video0";
        }
        try {
            n7 = Integer.parseInt(stringArray[1]);
        }
        catch (Exception exception) {
            n7 = 0;
        }
        try {
            n6 = Integer.parseInt(stringArray[2]);
        }
        catch (Exception exception) {
            n6 = 0;
        }
        try {
            n5 = Integer.parseInt(stringArray[3]);
        }
        catch (Exception exception) {
            n5 = 0;
        }
        try {
            n4 = Integer.parseInt(stringArray[4]);
        }
        catch (Exception exception) {
            n4 = 0;
        }
        try {
            n3 = Integer.parseInt(stringArray[5]);
        }
        catch (Exception exception) {
            n3 = -1;
        }
        try {
            n2 = Integer.parseInt(stringArray[6]);
        }
        catch (Exception exception) {
            n2 = 0;
        }
        try {
            n = Integer.parseInt(stringArray[7]);
        }
        catch (Exception exception) {
            n = -1;
        }
        System.out.println("This program will open " + string + ", capture frames for " + 10 + " seconds and print the FPS");
        new GetFrameRate(string, n3, n2, n7, n6, n4, n5, n).startTest();
    }
}

