/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j.examples;

import au.edu.jcu.v4l4j.FrameGrabber;
import au.edu.jcu.v4l4j.ImageFormat;
import au.edu.jcu.v4l4j.VideoDevice;
import au.edu.jcu.v4l4j.VideoFrame;
import au.edu.jcu.v4l4j.examples.ImageProcessor;
import au.edu.jcu.v4l4j.examples.VideoViewer;
import au.edu.jcu.v4l4j.exceptions.V4L4JException;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;

public class RGBViewer
implements ImageProcessor {
    private int width;
    private int height;
    private int std;
    private int channel;
    private VideoDevice vd;
    private VideoViewer viewer;

    public RGBViewer(VideoDevice videoDevice, int n, int n2, int n3, int n4) throws V4L4JException {
        List<ImageFormat> list;
        this.viewer = new VideoViewer(videoDevice, this);
        this.vd = videoDevice;
        if (!this.vd.supportRGBConversion()) {
            String string = "Image from this video device cannot be converted\nto RGB. If no other application is currently using the\ndevice, please submit a bug report about this issue,\nso support for your device can be added to v4l4j.\nSee README file in the v4l4j/ directory for directions.";
            JOptionPane.showMessageDialog(null, string);
            list = new Vector<ImageFormat>();
        } else {
            list = this.vd.getDeviceInfo().getFormatList().getRGBEncodableFormats();
        }
        this.width = n;
        this.height = n2;
        this.std = n3;
        this.channel = n4;
        this.viewer.initGUI(list.toArray(), n, n2, "RGB");
    }

    @Override
    public FrameGrabber getGrabber(ImageFormat imageFormat) throws V4L4JException {
        return this.vd.getRGBFrameGrabber(this.width, this.height, this.channel, this.std, imageFormat);
    }

    @Override
    public void releaseGrabber() {
        this.vd.releaseFrameGrabber();
    }

    @Override
    public void processImage(VideoFrame videoFrame) {
        this.viewer.drawBufferedImage(videoFrame.getBufferedImage());
    }

    public static void main(String[] stringArray) throws V4L4JException, IOException {
        int n;
        int n2;
        int n3;
        int n4;
        String string;
        try {
            string = stringArray[0];
        }
        catch (Exception exception) {
            string = "/dev/video0";
        }
        try {
            n4 = Integer.parseInt(stringArray[1]);
        }
        catch (Exception exception) {
            n4 = 640;
        }
        try {
            n3 = Integer.parseInt(stringArray[2]);
        }
        catch (Exception exception) {
            n3 = 480;
        }
        try {
            n2 = Integer.parseInt(stringArray[3]);
        }
        catch (Exception exception) {
            n2 = 0;
        }
        try {
            n = Integer.parseInt(stringArray[4]);
        }
        catch (Exception exception) {
            n = 0;
        }
        new RGBViewer(new VideoDevice(string), n4, n3, n2, n);
    }
}

