/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j.examples;

import au.edu.jcu.v4l4j.Control;
import au.edu.jcu.v4l4j.FrameGrabber;
import au.edu.jcu.v4l4j.FrameInterval;
import au.edu.jcu.v4l4j.ImageFormat;
import au.edu.jcu.v4l4j.Tuner;
import au.edu.jcu.v4l4j.TunerInfo;
import au.edu.jcu.v4l4j.VideoDevice;
import au.edu.jcu.v4l4j.VideoFrame;
import au.edu.jcu.v4l4j.examples.ImageProcessor;
import au.edu.jcu.v4l4j.exceptions.ControlException;
import au.edu.jcu.v4l4j.exceptions.V4L4JException;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VideoViewer
extends WindowAdapter
implements Runnable {
    private JLabel video;
    private JLabel fps;
    private JLabel freq;
    private JFrame f;
    private JComboBox formats;
    private IntervalGUI intervals;
    private JPanel controlPanel;
    private JPanel captureButtons;
    private JScrollPane controlScrollPane;
    private JPanel videoPanel;
    private JButton startCap;
    private JButton stopCap;
    private JSpinner freqSpinner;
    private Tuner tuner;
    private TunerInfo tinfo;
    private long start = 0L;
    private int n;
    private int width;
    private int height;
    private FrameGrabber fg;
    private Hashtable<String, Control> controls;
    private Thread captureThread;
    private boolean stop;
    private VideoDevice vd;
    private ImageProcessor processor;
    private BufferedImage img;
    private WritableRaster raster;
    private static ImageIcon v4l4jIcon = VideoViewer.createImageIcon("resources/v4l4j.png");
    private static int FPS_REFRESH = 1000;

    public VideoViewer(VideoDevice videoDevice, ImageProcessor imageProcessor) {
        this.vd = videoDevice;
        this.fg = null;
        this.processor = imageProcessor;
        this.controls = this.vd.getControlList().getTable();
        this.stop = false;
        this.captureThread = null;
    }

    public static ImageIcon createImageIcon(String string) {
        URL uRL = VideoViewer.class.getClassLoader().getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        return null;
    }

    public VideoDevice getVideoDevice() {
        return this.vd;
    }

    public void initGUI(Object[] objectArray, final int n, final int n2, String string) {
        this.f = new JFrame();
        this.f.setLayout(new BoxLayout(this.f.getContentPane(), 2));
        this.f.setIconImage(v4l4jIcon.getImage());
        this.videoPanel = new JPanel();
        this.videoPanel.setLayout(new BoxLayout(this.videoPanel, 3));
        this.video = new JLabel(v4l4jIcon);
        this.video.setPreferredSize(new Dimension(n, n2));
        this.video.setAlignmentX(0.5f);
        this.video.setAlignmentY(0.5f);
        this.videoPanel.add(this.video);
        this.captureButtons = new JPanel();
        this.captureButtons.setLayout(new BoxLayout(this.captureButtons, 2));
        this.formats = new JComboBox<Object>(objectArray);
        this.formats.setAlignmentX(0.5f);
        Dimension dimension = new Dimension(100, 25);
        this.formats.setSize(dimension);
        this.formats.setPreferredSize(dimension);
        this.formats.setMaximumSize(dimension);
        FrameInterval frameInterval = null;
        try {
            frameInterval = this.vd.getDeviceInfo().listIntervals((ImageFormat)objectArray[0], n, n2);
        }
        catch (V4L4JException v4L4JException) {
            // empty catch block
        }
        this.intervals = new IntervalGUI();
        this.intervals.setInterval(frameInterval);
        this.formats.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameInterval frameInterval = null;
                try {
                    frameInterval = VideoViewer.this.vd.getDeviceInfo().listIntervals((ImageFormat)VideoViewer.this.formats.getSelectedItem(), n, n2);
                }
                catch (V4L4JException v4L4JException) {
                    // empty catch block
                }
                VideoViewer.this.intervals.setInterval(frameInterval);
            }
        });
        this.startCap = new JButton("Start");
        this.startCap.setAlignmentX(0.5f);
        if (objectArray.length == 0) {
            this.startCap.setEnabled(false);
            this.formats.setEnabled(false);
            this.intervals.setEnabled(false);
        } else {
            this.startCap.setEnabled(true);
        }
        this.stopCap = new JButton("Stop");
        this.stopCap.setAlignmentX(0.5f);
        this.stopCap.setEnabled(false);
        this.fps = new JLabel("FPS: 0.0");
        this.fps.setAlignmentX(0.5f);
        this.freq = new JLabel("Frequency");
        this.freq.setAlignmentX(0.5f);
        this.freq.setVisible(false);
        this.freqSpinner = new JSpinner();
        this.freqSpinner.setAlignmentX(0.5f);
        this.freqSpinner.setVisible(false);
        this.freqSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                VideoViewer.this.tuner.setFrequency(((SpinnerNumberModel)VideoViewer.this.freqSpinner.getModel()).getNumber().doubleValue());
            }
        });
        this.captureButtons.add(Box.createGlue());
        this.captureButtons.add(this.formats);
        this.captureButtons.add(Box.createGlue());
        this.captureButtons.add(this.intervals.getPanel());
        this.captureButtons.add(Box.createGlue());
        this.captureButtons.add(this.startCap);
        this.captureButtons.add(Box.createGlue());
        this.captureButtons.add(this.freq);
        this.captureButtons.add(Box.createGlue());
        this.captureButtons.add(this.stopCap);
        this.captureButtons.add(Box.createGlue());
        this.captureButtons.add(this.freqSpinner);
        this.captureButtons.add(Box.createGlue());
        this.captureButtons.add(this.fps);
        this.captureButtons.add(Box.createGlue());
        this.startCap.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                VideoViewer.this.startCapture();
            }
        });
        this.stopCap.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                VideoViewer.this.stopCapture();
            }
        });
        this.videoPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.videoPanel.add(this.captureButtons);
        this.controlPanel = new JPanel();
        this.controlScrollPane = new JScrollPane(this.controlPanel);
        this.controlScrollPane.getVerticalScrollBar().setBlockIncrement(40);
        this.controlScrollPane.getVerticalScrollBar().setUnitIncrement(25);
        this.controlScrollPane.setPreferredSize(new Dimension(300, n2));
        this.controlPanel.setLayout(new BoxLayout(this.controlPanel, 3));
        this.f.getContentPane().add(this.videoPanel);
        this.f.getContentPane().add(this.controlScrollPane);
        this.initControlPane();
        this.f.setDefaultCloseOperation(2);
        this.f.addWindowListener(this);
        try {
            this.f.setTitle(string + " capture from " + this.vd.getDeviceInfo().getName());
        }
        catch (V4L4JException v4L4JException) {
            this.f.setTitle(string + " capture from " + this.vd.getDevicefile());
        }
        this.f.pack();
        this.f.setVisible(true);
    }

    private void initControlPane() {
        for (Control control : this.controls.values()) {
            ControlGUI controlGUI = this.getControlGUI(control);
            if (controlGUI == null) continue;
            this.controlPanel.add(controlGUI.getPanel());
        }
    }

    private ControlGUI getControlGUI(Control control) {
        ControlModelGUI controlModelGUI = null;
        if (control.getType() == 1) {
            controlModelGUI = new SliderControl(control);
        } else if (control.getType() == 0) {
            controlModelGUI = new ButtonControl(control);
        } else if (control.getType() == 2) {
            controlModelGUI = new SwitchControl(control);
        } else if (control.getType() == 3) {
            controlModelGUI = new MenuControl(control);
        }
        return controlModelGUI;
    }

    public void setImageIcon(byte[] byArray) {
        if (this.start == 0L) {
            this.start = System.currentTimeMillis();
        } else if (System.currentTimeMillis() > this.start + (long)FPS_REFRESH) {
            this.fps.setText(String.format("FPS: %5.2f", Float.valueOf(1000.0f * (float)this.n / (float)(System.currentTimeMillis() - this.start))));
            this.start = System.currentTimeMillis();
            this.n = 0;
        }
        this.video.setIcon(new ImageIcon(byArray));
        ++this.n;
    }

    public void setImageRaster(Raster raster) {
        if (this.start == 0L) {
            this.start = System.currentTimeMillis();
        } else if (System.currentTimeMillis() > this.start + (long)FPS_REFRESH) {
            this.fps.setText(String.format("FPS: %5.2f", Float.valueOf(1000.0f * (float)this.n / (float)(System.currentTimeMillis() - this.start))));
            this.start = System.currentTimeMillis();
            this.n = 0;
        }
        this.img.setData(raster);
        this.video.getGraphics().drawImage(this.img, 0, 0, this.width, this.height, null);
        ++this.n;
    }

    public void drawBufferedImage(BufferedImage bufferedImage) {
        if (this.start == 0L) {
            this.start = System.currentTimeMillis();
        } else if (System.currentTimeMillis() > this.start + (long)FPS_REFRESH) {
            this.fps.setText(String.format("FPS: %5.2f", Float.valueOf(1000.0f * (float)this.n / (float)(System.currentTimeMillis() - this.start))));
            this.start = System.currentTimeMillis();
            this.n = 0;
        }
        this.video.getGraphics().drawImage(bufferedImage, 0, 0, this.width, this.height, null);
        ++this.n;
    }

    @Override
    public void run() {
        try {
            while (!this.stop) {
                VideoFrame videoFrame = this.fg.getVideoFrame();
                this.processor.processImage(videoFrame);
                videoFrame.recycle();
            }
        }
        catch (V4L4JException v4L4JException) {
            v4L4JException.printStackTrace();
            System.out.println("Failed to capture image");
            JOptionPane.showMessageDialog(this.f, "Failed to capture image:\n" + v4L4JException.getMessage());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.out.println("Failed to capture image");
            JOptionPane.showMessageDialog(this.f, "Failed to capture image:\n" + throwable.getMessage());
        }
    }

    private void startCapture() {
        if (this.captureThread == null) {
            IntervalGUI.Interval interval = null;
            try {
                interval = this.intervals.getInterval();
            }
            catch (Exception exception) {
                return;
            }
            try {
                this.fg = this.processor.getGrabber((ImageFormat)this.formats.getSelectedItem());
            }
            catch (V4L4JException v4L4JException) {
                JOptionPane.showMessageDialog(this.f, "Error obtaining the frame grabber");
                v4L4JException.printStackTrace();
                return;
            }
            try {
                if (interval != null) {
                    this.fg.setFrameInterval(interval.num, interval.denom);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.fg.startCapture();
            }
            catch (V4L4JException v4L4JException) {
                JOptionPane.showMessageDialog(this.f, "Failed to start capture:\n" + v4L4JException.getMessage());
                v4L4JException.printStackTrace();
                this.processor.releaseGrabber();
                return;
            }
            this.width = this.fg.getWidth();
            this.height = this.fg.getHeight();
            this.video.setMaximumSize(new Dimension(this.width, this.height));
            this.video.setSize(new Dimension(this.width, this.height));
            this.controlScrollPane.setPreferredSize(new Dimension(300, this.height));
            this.formats.setEnabled(false);
            this.intervals.setEnabled(false);
            this.startCap.setEnabled(false);
            this.stopCap.setEnabled(true);
            try {
                this.tuner = this.fg.getTuner();
                this.tinfo = this.vd.getDeviceInfo().getInputs().get(this.fg.getChannel()).getTunerInfo();
                this.freqSpinner.setModel(new SpinnerNumberModel(new Double(this.tuner.getFrequency()), new Double(this.tinfo.getRangeLow()), new Double(this.tinfo.getRangeHigh()), new Double(1.0)));
                this.freq.setVisible(true);
                this.freqSpinner.setVisible(true);
            }
            catch (V4L4JException v4L4JException) {
                // empty catch block
            }
            this.f.pack();
            this.raster = Raster.createInterleavedRaster(new DataBufferByte(new byte[this.width * this.height * 3], this.width * this.height * 3), this.width, this.height, 3 * this.width, 3, new int[]{0, 1, 2}, null);
            ColorSpace colorSpace = ColorSpace.getInstance(1000);
            ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, false, false, 1, 0);
            this.img = new BufferedImage(componentColorModel, this.raster, false, null);
            this.stop = false;
            this.captureThread = new Thread((Runnable)this, "Capture Thread");
            this.captureThread.start();
            System.out.println("Input format: " + this.fg.getImageFormat().getName());
        }
    }

    private void stopCapture() {
        if (this.captureThread != null) {
            if (this.captureThread.isAlive()) {
                this.stop = true;
                try {
                    this.captureThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.fg.stopCapture();
            this.vd.releaseFrameGrabber();
            this.captureThread = null;
            this.formats.setEnabled(true);
            this.intervals.setEnabled(true);
            this.freq.setVisible(false);
            this.freqSpinner.setVisible(false);
            this.video.setIcon(v4l4jIcon);
            this.startCap.setEnabled(true);
            this.stopCap.setEnabled(false);
            this.video.validate();
            this.video.repaint();
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.stopCapture();
        this.vd.releaseFrameGrabber();
        this.vd.releaseControlList();
        this.vd.release();
        this.f.dispose();
    }

    public class MenuControl
    extends ControlModelGUI
    implements ActionListener {
        private JComboBox box;
        String[] names;
        Integer[] values;

        public MenuControl(Control control) {
            super(control);
            this.names = new String[0];
            this.values = new Integer[0];
            this.names = this.ctrl.getDiscreteValueNames().toArray(this.names);
            this.values = this.ctrl.getDiscreteValues().toArray(this.values);
            int n = control.getDefaultValue();
            this.box = new JComboBox<String>(this.names);
            try {
                n = control.getValue();
            }
            catch (ControlException controlException) {
                // empty catch block
            }
            this.box.setSelectedIndex(this.ctrl.getDiscreteValues().indexOf(n));
            this.initPanel();
        }

        private void initPanel() {
            this.box.addActionListener(this);
            this.contentPanel.add(this.box);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.ctrl.setValue(this.values[this.box.getSelectedIndex()]);
            }
            catch (ControlException controlException) {
                JOptionPane.showMessageDialog(null, "Error setting value.\n" + controlException.getMessage());
            }
        }
    }

    public class SwitchControl
    extends ControlModelGUI
    implements ItemListener {
        private JCheckBox box;

        public SwitchControl(Control control) {
            super(control);
            int n = control.getDefaultValue();
            this.box = new JCheckBox();
            this.box.setAlignmentX(0.5f);
            try {
                n = control.getValue();
            }
            catch (ControlException controlException) {
                // empty catch block
            }
            this.box.setSelected(n == 1);
            this.box.addItemListener(this);
            this.contentPanel.add(this.box);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            try {
                if (itemEvent.getStateChange() == 2) {
                    this.ctrl.setValue(0);
                } else {
                    this.ctrl.setValue(1);
                }
            }
            catch (ControlException controlException) {
                JOptionPane.showMessageDialog(null, "Error setting value.\n" + controlException.getMessage());
            }
        }
    }

    public class ButtonControl
    extends ControlModelGUI
    implements ActionListener {
        private JButton button;

        public ButtonControl(Control control) {
            super(control);
            this.button = new JButton("Activate");
            this.button.setAlignmentX(0.5f);
            this.button.addActionListener(this);
            this.contentPanel.add(this.button);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.ctrl.setValue(0);
            }
            catch (ControlException controlException) {
                JOptionPane.showMessageDialog(null, "Error setting value.\n" + controlException.getMessage());
            }
        }
    }

    public class SliderControl
    extends ControlModelGUI
    implements ChangeListener {
        private JSlider slider;

        public SliderControl(Control control) {
            super(control);
            int n = control.getDefaultValue();
            try {
                n = control.getValue();
            }
            catch (ControlException controlException) {
                // empty catch block
            }
            this.slider = new JSlider(0, control.getMinValue(), control.getMaxValue(), n);
            this.setSlider();
            this.contentPanel.add(this.slider);
            this.updateValue(n);
        }

        private void setSlider() {
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            int n = (this.ctrl.getMaxValue() - this.ctrl.getMinValue()) / this.ctrl.getStepValue() + 1;
            int n2 = this.ctrl.getDefaultValue();
            this.slider.setSnapToTicks(true);
            this.slider.setPaintTicks(false);
            this.slider.setMinorTickSpacing(this.ctrl.getStepValue());
            hashtable.put(this.ctrl.getMinValue(), new JLabel(String.valueOf(this.ctrl.getMinValue())));
            hashtable.put(this.ctrl.getMaxValue(), new JLabel(String.valueOf(this.ctrl.getMaxValue())));
            hashtable.put(n2, new JLabel(String.valueOf(n2)));
            if (n < 100 && n > 10) {
                this.slider.setMajorTickSpacing(n2 / 2);
                this.slider.setPaintTicks(true);
            } else if (n < 10) {
                this.slider.setMajorTickSpacing(n2);
                this.slider.setPaintTicks(true);
            }
            this.slider.setLabelTable(hashtable);
            this.slider.setPaintLabels(true);
            this.slider.addChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (!jSlider.getValueIsAdjusting()) {
                int n = 0;
                try {
                    n = this.ctrl.setValue(jSlider.getValue());
                }
                catch (ControlException controlException) {
                    JOptionPane.showMessageDialog(null, "Error setting value.\n" + controlException.getMessage());
                    try {
                        n = this.ctrl.getValue();
                    }
                    catch (ControlException controlException2) {
                        n = this.ctrl.getDefaultValue();
                    }
                }
                finally {
                    this.updateValue(n);
                    jSlider.removeChangeListener(this);
                    jSlider.setValue(n);
                    jSlider.addChangeListener(this);
                }
            }
        }
    }

    public class ControlModelGUI
    implements ControlGUI {
        protected JPanel contentPanel;
        private JLabel value;
        protected Control ctrl;

        public ControlModelGUI(Control control) {
            this.ctrl = control;
            this.initControlGUI();
        }

        private void initControlGUI() {
            this.contentPanel = new JPanel();
            this.contentPanel.setAlignmentX(0.5f);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), this.ctrl.getName());
            titledBorder.setTitleJustification(1);
            this.contentPanel.setBorder(titledBorder);
            if (this.ctrl.getType() != 0 && this.ctrl.getType() != 2) {
                this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 3));
                this.value = new JLabel("Value: ");
                this.contentPanel.add(this.value);
                this.contentPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            } else {
                this.contentPanel.setLayout(new GridLayout());
                this.value = null;
            }
        }

        public final void updateValue(int n) {
            if (this.value != null) {
                this.value.setText("Value: " + String.valueOf(n));
            }
        }

        @Override
        public final JPanel getPanel() {
            return this.contentPanel;
        }
    }

    public class IntervalGUI
    implements ControlGUI {
        protected JPanel contentPanel = new JPanel();
        private FrameInterval intv;
        private JComboBox discreteList;
        private JTextField stepwiseValue;

        public IntervalGUI() {
            this.contentPanel.setAlignmentX(0.5f);
            this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 2));
        }

        public void setInterval(FrameInterval frameInterval) {
            this.intv = frameInterval;
            this.contentPanel.removeAll();
            this.contentPanel.revalidate();
            if (this.intv == null) {
                return;
            }
            if (this.intv.getType() == FrameInterval.Type.DISCRETE) {
                this.discreteList = new JComboBox<Object>(this.intv.getDiscreteIntervals().toArray());
                this.contentPanel.add(this.discreteList);
            } else if (this.intv.getType() == FrameInterval.Type.STEPWISE) {
                this.stepwiseValue = new JTextField(8);
                this.stepwiseValue.setText(this.intv.getStepwiseInterval().maxIntv.numerator + "/" + this.intv.getStepwiseInterval().maxIntv.denominator);
                this.stepwiseValue.setToolTipText("Min:" + this.intv.getStepwiseInterval().minIntv.numerator + "/" + this.intv.getStepwiseInterval().minIntv.denominator + " - Max: " + this.intv.getStepwiseInterval().maxIntv.numerator + "/" + this.intv.getStepwiseInterval().maxIntv.denominator + " - Step: " + this.intv.getStepwiseInterval().stepIntv.numerator + "/" + this.intv.getStepwiseInterval().stepIntv.denominator);
                this.contentPanel.add(this.stepwiseValue);
            }
        }

        public Interval getInterval() {
            if (this.intv == null) {
                return null;
            }
            if (this.intv.getType() == FrameInterval.Type.DISCRETE) {
                FrameInterval.DiscreteInterval discreteInterval = (FrameInterval.DiscreteInterval)this.discreteList.getSelectedItem();
                return new Interval(discreteInterval.numerator, discreteInterval.denominator);
            }
            if (this.intv.getType() == FrameInterval.Type.STEPWISE) {
                return this.validateStepwsiseValue();
            }
            return null;
        }

        public void setEnabled(boolean bl) {
            if (this.intv == null) {
                return;
            }
            if (this.intv.getType() == FrameInterval.Type.DISCRETE) {
                this.discreteList.setEnabled(bl);
            } else if (this.intv.getType() == FrameInterval.Type.STEPWISE) {
                this.stepwiseValue.setEnabled(bl);
            }
        }

        private Interval validateStepwsiseValue() {
            String[] stringArray = this.stepwiseValue.getText().split("/");
            if (stringArray.length == 2) {
                int n = 0;
                int n2 = 1;
                try {
                    n = Integer.parseInt(stringArray[0]);
                    n2 = Integer.parseInt(stringArray[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    String string = "The frame interval is invalid. It must\nbe in the form 'X/Y'";
                    JOptionPane.showMessageDialog(null, string);
                    throw numberFormatException;
                }
                if (n < 0 || n2 < 0) {
                    String string = "The frame interval is invalid.";
                    JOptionPane.showMessageDialog(null, string);
                    throw new NumberFormatException();
                }
                if (this.compareFrac(this.intv.getStepwiseInterval().minIntv.getNum(), this.intv.getStepwiseInterval().minIntv.getDenom(), n, n2) <= 0 && this.compareFrac(this.intv.getStepwiseInterval().minIntv.getNum(), this.intv.getStepwiseInterval().minIntv.getDenom(), n, n2) >= 0) {
                    return new Interval(n, n2);
                }
                String string = "The frame interval (" + n + "/" + n2 + ") is " + "outside the\nallowed range (" + this.intv.getStepwiseInterval().minIntv.getNum() + "/" + this.intv.getStepwiseInterval().minIntv.getDenom() + " to" + this.intv.getStepwiseInterval().maxIntv.getNum() + "/" + this.intv.getStepwiseInterval().minIntv.getDenom() + ")";
                JOptionPane.showMessageDialog(null, string);
                return null;
            }
            String string = "The frame interval is invalid. It must\nbe in the form 'X/Y'";
            JOptionPane.showMessageDialog(null, string);
            throw new NumberFormatException();
        }

        private int compareFrac(int n, int n2, int n3, int n4) {
            long l = n * n4;
            long l2 = n3 * n2;
            return l < l2 ? -1 : (l == l2 ? 0 : 1);
        }

        @Override
        public JPanel getPanel() {
            return this.contentPanel;
        }

        public class Interval {
            public int num;
            public int denom;

            public Interval(int n, int n2) {
                this.num = n;
                this.denom = n2;
            }
        }
    }

    public static interface ControlGUI {
        public JPanel getPanel();
    }
}

