/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j.examples.server;

import au.edu.jcu.v4l4j.ControlList;
import au.edu.jcu.v4l4j.JPEGFrameGrabber;
import au.edu.jcu.v4l4j.VideoDevice;
import au.edu.jcu.v4l4j.VideoFrame;
import au.edu.jcu.v4l4j.examples.server.ClientConnection;
import au.edu.jcu.v4l4j.exceptions.V4L4JException;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

public class CamServer
implements Runnable {
    private ServerSocket serverSocket;
    private VideoDevice videoDevice;
    private JPEGFrameGrabber frameGrabber;
    private ControlList controlList;
    private Thread captureThread;
    private Thread serverThread;
    private Vector<ClientConnection> clients;
    private String httpLineFromClient;
    private static final int MAIN_PAGE = 0;
    private static final int WEBCAM_PAGE = 1;
    private static final int CONTROL_PAGE = 2;
    private static final int VIDEO_STREAM = 3;
    private static final int UPDATE_CONTROL_VALUE = 4;

    public CamServer(String string, int n, int n2, int n3) throws V4L4JException, IOException {
        this.videoDevice = new VideoDevice(string);
        this.frameGrabber = this.videoDevice.getJPEGFrameGrabber(n, n2, 0, 0, 80);
        this.controlList = this.videoDevice.getControlList();
        this.clients = new Vector();
        this.serverSocket = new ServerSocket(n3);
        System.out.println("Server listening at " + this.serverSocket.getInetAddress().getHostAddress() + ":" + this.serverSocket.getLocalPort());
        this.captureThread = new Thread((Runnable)this, "Capture thread");
        this.serverThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Vector vector = null;
                try {
                    while (!Thread.interrupted() && CamServer.this.captureThread.isAlive()) {
                        CamServer.this.serverMainLoop();
                    }
                }
                catch (IOException iOException) {
                }
                catch (V4L4JException v4L4JException) {
                    v4L4JException.printStackTrace();
                }
                Vector vector2 = CamServer.this.clients;
                synchronized (vector2) {
                    vector = new Vector(CamServer.this.clients);
                }
                for (ClientConnection clientConnection : vector) {
                    clientConnection.stop();
                }
                System.out.println("Server thread exiting");
            }
        }, "Server thread");
    }

    public void start() {
        this.captureThread.start();
        while (!this.captureThread.isAlive()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.serverThread.start();
    }

    public void stop() {
        if (this.captureThread.isAlive()) {
            this.captureThread.interrupt();
            try {
                this.captureThread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.serverThread.isAlive()) {
            this.serverThread.interrupt();
            try {
                this.serverThread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.videoDevice.releaseFrameGrabber();
        this.videoDevice.releaseControlList();
        this.videoDevice.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void serverMainLoop() throws IOException, V4L4JException {
        BufferedReader bufferedReader = null;
        FilterOutputStream filterOutputStream = null;
        int n = 0;
        Socket socket = this.serverSocket.accept();
        System.out.println("Connection from " + socket.getInetAddress().getHostAddress() + ":" + socket.getPort());
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            filterOutputStream = new DataOutputStream(socket.getOutputStream());
            n = this.parseLine(bufferedReader);
        }
        catch (IOException iOException) {
            bufferedReader.close();
            filterOutputStream.close();
            socket.close();
            return;
        }
        if (n == 3) {
            try {
                Vector<ClientConnection> vector = this.clients;
                synchronized (vector) {
                    this.clients.add(new ClientConnection(socket, bufferedReader, (DataOutputStream)filterOutputStream));
                    if (this.clients.size() != 1) return;
                    this.frameGrabber.startCapture();
                    this.clients.notifyAll();
                    return;
                }
            }
            catch (IOException iOException) {
                System.out.println("Disconnected from " + socket.getInetAddress().getHostAddress() + ":" + socket.getPort());
                bufferedReader.close();
                filterOutputStream.close();
                socket.close();
            }
            return;
        }
        try {
            switch (n) {
                case 1: {
                    ClientConnection.sendWebcamPage((DataOutputStream)filterOutputStream);
                    return;
                }
                case 4: {
                    ClientConnection.updateControlValue(this.controlList, this.frameGrabber, this.httpLineFromClient);
                }
                case 2: {
                    ClientConnection.sendControlListPage(this.controlList, this.frameGrabber.getJPGQuality(), (DataOutputStream)filterOutputStream);
                    return;
                }
                default: {
                    ClientConnection.sendMainPage((DataOutputStream)filterOutputStream);
                    return;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        finally {
            try {
                System.out.println("Disconnected from " + socket.getInetAddress().getHostAddress() + ":" + socket.getPort());
                bufferedReader.close();
                filterOutputStream.close();
                socket.close();
            }
            catch (Exception exception) {}
        }
    }

    private int parseLine(BufferedReader bufferedReader) throws IOException {
        this.httpLineFromClient = bufferedReader.readLine();
        if (this.httpLineFromClient == null) {
            throw new IOException("Read null line");
        }
        if (this.httpLineFromClient.indexOf("webcam") != -1) {
            return 1;
        }
        if (this.httpLineFromClient.indexOf("control") != -1) {
            return 2;
        }
        if (this.httpLineFromClient.indexOf("stream") != -1) {
            return 3;
        }
        if (this.httpLineFromClient.indexOf("update") != -1) {
            return 4;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Vector<ClientConnection> vector = null;
        VideoFrame videoFrame = null;
        try {
            while (!Thread.interrupted()) {
                this.waitForAtLeast1Client();
                videoFrame = this.frameGrabber.getVideoFrame();
                Vector<ClientConnection> vector2 = this.clients;
                synchronized (vector2) {
                    vector = new Vector<ClientConnection>(this.clients);
                }
                for (ClientConnection clientConnection : vector) {
                    try {
                        clientConnection.sendNextFrame(videoFrame);
                    }
                    catch (IOException iOException) {
                        Vector<ClientConnection> vector3 = this.clients;
                        synchronized (vector3) {
                            clientConnection.stop();
                            this.clients.remove(clientConnection);
                            if (this.clients.size() == 0) {
                                this.frameGrabber.stopCapture();
                            }
                        }
                    }
                }
                videoFrame.recycle();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (V4L4JException v4L4JException) {
            v4L4JException.printStackTrace();
        }
        System.out.println("Capture thread exiting");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAtLeast1Client() throws InterruptedException {
        Vector<ClientConnection> vector = this.clients;
        synchronized (vector) {
            while (this.clients.size() == 0) {
                this.clients.wait();
            }
        }
    }

    public static void main(String[] stringArray) throws V4L4JException, IOException {
        String string = System.getProperty("test.device") != null ? System.getProperty("test.device") : "/dev/video0";
        int n = System.getProperty("test.width") != null ? Integer.parseInt(System.getProperty("test.width")) : 640;
        int n2 = System.getProperty("test.height") != null ? Integer.parseInt(System.getProperty("test.height")) : 480;
        CamServer camServer = new CamServer(string, n, n2, 8080);
        camServer.start();
        System.out.println("Press enter to exit.");
        System.in.read();
        camServer.stop();
    }
}

