/*
 * Decompiled with CFR 0.152.
 */
package au.edu.jcu.v4l4j.examples.server;

import au.edu.jcu.v4l4j.Control;
import au.edu.jcu.v4l4j.ControlList;
import au.edu.jcu.v4l4j.JPEGFrameGrabber;
import au.edu.jcu.v4l4j.VideoFrame;
import au.edu.jcu.v4l4j.exceptions.ControlException;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Map;
import java.util.StringTokenizer;

public class ClientConnection {
    private static String mjpegHeader = "HTTP/1.0 200 OK\r\nExpires: 0\r\nPragma: no-cache\r\nCache-Control: no-cache\r\nContent-Type: multipart/x-mixed-replace;boundary=\"boundary\"\r\n\r\n";
    private static String mjpegFrameheader = "--boundary\r\nContent-Type: image/jpeg\r\nContent-Length: ";
    private static String mainPageHTML = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\" http://www.w3.org/TR/html4/frameset.dtd><html><head><title>v4l4j mini server</title></head><frameset cols=\"4*,6*\"><frame src=\"control\" name=\"control list\"><frame src=\"webcam\" name=\"video stream\"></frameset></html>";
    private static String webcamPageHTML = "<html><body><table><td><tr><img src=\"stream.jpg\"></tr></td></table></body></html>";
    private static String controlPageHTMLHeader = "<html><body><table>";
    private static String controlPageHTMLFooter = "</table></body></html>";
    private Socket clientSocket;
    private BufferedReader inStream;
    private DataOutputStream outStream;

    public ClientConnection(Socket socket, BufferedReader bufferedReader, DataOutputStream dataOutputStream) throws IOException {
        if (socket == null || bufferedReader == null || dataOutputStream == null) {
            throw new NullPointerException("client, in and out cannot be null");
        }
        this.clientSocket = socket;
        this.inStream = bufferedReader;
        this.outStream = dataOutputStream;
        this.outStream.writeBytes(mjpegHeader);
    }

    public void stop() {
        try {
            System.out.println("Disconnected from " + this.clientSocket.getInetAddress().getHostAddress() + ":" + this.clientSocket.getPort());
            this.inStream.close();
            this.outStream.close();
            this.clientSocket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void sendNextFrame(VideoFrame videoFrame) throws IOException {
        this.outStream.writeBytes(mjpegFrameheader + Integer.toString(videoFrame.getFrameLength()) + "\r\n\r\n");
        this.outStream.write(videoFrame.getBytes(), 0, videoFrame.getFrameLength());
    }

    public static void sendMainPage(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBytes(mainPageHTML);
    }

    public static void sendWebcamPage(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBytes(webcamPageHTML);
    }

    public static void sendControlListPage(ControlList controlList, int n, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBytes(controlPageHTMLHeader);
        dataOutputStream.writeBytes("<tr>");
        dataOutputStream.writeBytes("<td>JPEG Quality</td>");
        dataOutputStream.writeBytes("<td><form action=\"update\">");
        dataOutputStream.writeBytes("<input type=\"hidden\" name=\"id\" value=\"-1\">");
        dataOutputStream.writeBytes("<input type=\"text\" name=\"val\" value=\"" + n + "\" size=\"10\" maxlength=\"10\">");
        dataOutputStream.writeBytes("<br>Min: 0 - Max: 100 - Step: 1");
        dataOutputStream.writeBytes("</td><td><input type=\"submit\" name=\"set\" value=\"set\"></form></td></tr>");
        for (Control control : controlList.getList()) {
            dataOutputStream.writeBytes("<tr>");
            dataOutputStream.writeBytes("<td>" + control.getName() + "</td>");
            dataOutputStream.writeBytes("<td><form action=\"update\">");
            dataOutputStream.writeBytes("<input type=\"hidden\" name=\"id\" value=\"" + controlList.getList().indexOf(control) + "\">");
            try {
                switch (control.getType()) {
                    case 0: {
                        dataOutputStream.writeBytes("<input type=\"hidden\" name=\"val\" value=\"0\">");
                        dataOutputStream.writeBytes("</td><td><input type=\"submit\" name=\"Activate\">");
                        break;
                    }
                    case 1: {
                        dataOutputStream.writeBytes("<input type=\"text\" name=\"val\" value=\"" + control.getValue() + "\" size=\"10\" maxlength=\"10\">");
                        dataOutputStream.writeBytes("<br>Min: " + control.getMinValue() + " - Max: " + control.getMaxValue() + " - Step: " + control.getStepValue());
                        dataOutputStream.writeBytes("</td><td><input type=\"submit\" name=\"set\" value=\"set\">");
                        break;
                    }
                    case 3: {
                        dataOutputStream.writeBytes("<select name=\"val\" size=\"1\">");
                        Map<String, Integer> map = control.getDiscreteValuesMap();
                        for (String string : map.keySet()) {
                            dataOutputStream.writeBytes("<option value=\"" + map.get(string) + "\"");
                            if (control.getValue() == map.get(string).intValue()) {
                                dataOutputStream.writeBytes(" selected=\"selected\"");
                            }
                            dataOutputStream.writeBytes(" >");
                            dataOutputStream.writeBytes(string);
                            dataOutputStream.writeBytes("</option>");
                        }
                        dataOutputStream.writeBytes("</select>");
                        dataOutputStream.writeBytes("</td><td><input type=\"submit\" name=\"set\" value=\"set\">");
                        break;
                    }
                    case 2: {
                        dataOutputStream.writeBytes("<input type=\"checkbox\" name=\"val\" value=\"");
                        if (control.getValue() == 1) {
                            dataOutputStream.writeBytes("0\" checked=\"checked\">");
                        } else {
                            dataOutputStream.writeBytes("1\">");
                        }
                        dataOutputStream.writeBytes("</td><td><input type=\"submit\" name=\"set\" value=\"set\">");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            dataOutputStream.writeBytes("</form></td>");
            dataOutputStream.writeBytes("</tr>");
        }
        dataOutputStream.writeBytes(controlPageHTMLFooter);
    }

    public static void updateControlValue(ControlList controlList, JPEGFrameGrabber jPEGFrameGrabber, String string) throws ControlException {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "?=&", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("id") && stringTokenizer.hasMoreTokens()) {
                try {
                    n = Integer.parseInt(stringTokenizer.nextToken());
                    bl2 = true;
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!string2.equalsIgnoreCase("val") || !stringTokenizer.hasMoreTokens()) continue;
            try {
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (bl2 && !bl && controlList.getList().get(n).getType() == 2) {
            bl = true;
            n2 = 0;
        }
        if (bl && bl2) {
            if (n == -1) {
                jPEGFrameGrabber.setJPGQuality(n2);
            } else {
                controlList.getList().get(n).setValue(n2);
            }
        }
    }
}

