/*
 * Decompiled with CFR 0.152.
 */
package lcm.lcm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;
import lcm.lcm.LCMDataInputStream;
import lcm.lcm.LCMDataOutputStream;
import lcm.lcm.LCMEncodable;
import lcm.lcm.LCMSubscriber;
import lcm.lcm.LogFileProvider;
import lcm.lcm.Provider;
import lcm.lcm.TCPProvider;
import lcm.lcm.UDPMulticastProvider;
import lcm.lcm.URLParser;

public class LCM {
    ArrayList<SubscriptionRecord> subscriptions = new ArrayList();
    ArrayList<Provider> providers = new ArrayList();
    HashMap<String, ArrayList<SubscriptionRecord>> subscriptionsMap = new HashMap();
    boolean closed = false;
    static LCM singleton;
    LCMDataOutputStream encodeBuffer = new LCMDataOutputStream(new byte[1024]);

    public LCM(String ... stringArray) throws IOException {
        if (stringArray.length == 0) {
            String object = System.getenv("LCM_DEFAULT_URL");
            stringArray = object == null ? new String[]{"udpm://239.255.76.67:7667"} : new String[]{object};
        }
        for (String string : stringArray) {
            URLParser uRLParser;
            String string2;
            if ((null == string || string.equals("")) && (string = System.getenv("LCM_DEFAULT_URL")) == null) {
                string = "udpm://239.255.76.67:7667";
            }
            if ((string2 = (uRLParser = new URLParser(string)).get("protocol")).equals("udpm")) {
                this.providers.add(new UDPMulticastProvider(this, uRLParser));
                continue;
            }
            if (string2.equals("tcpq")) {
                this.providers.add(new TCPProvider(this, uRLParser));
                continue;
            }
            if (string2.equals("file")) {
                this.providers.add(new LogFileProvider(this, uRLParser));
                continue;
            }
            System.err.println("LCM: Unknown URL protocol: " + string2);
        }
    }

    public static LCM getSingleton() {
        if (singleton == null) {
            try {
                singleton = new LCM(new String[0]);
            }
            catch (Exception exception) {
                System.err.println("LC singleton fail: " + exception);
                System.exit(-1);
                return null;
            }
        }
        return singleton;
    }

    public int getNumSubscriptions() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        return this.subscriptions.size();
    }

    public void publish(String string, String string2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException();
        }
        string2 = string2 + "\u0000";
        byte[] byArray = string2.getBytes();
        this.publish(string, byArray, 0, byArray.length);
    }

    public synchronized void publish(String string, LCMEncodable lCMEncodable) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        try {
            this.encodeBuffer.reset();
            lCMEncodable.encode(this.encodeBuffer);
            this.publish(string, this.encodeBuffer.getBuffer(), 0, this.encodeBuffer.size());
        }
        catch (IOException iOException) {
            System.err.println("LC publish fail: " + iOException);
        }
    }

    public synchronized void publish(String string, byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException();
        }
        for (Provider provider : this.providers) {
            provider.publish(string, byArray, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String string, LCMSubscriber lCMSubscriber) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        SubscriptionRecord subscriptionRecord = new SubscriptionRecord();
        subscriptionRecord.regex = string;
        subscriptionRecord.pat = Pattern.compile(string);
        subscriptionRecord.lcsub = lCMSubscriber;
        Object object = this;
        synchronized (object) {
            for (Provider object2 : this.providers) {
                object2.subscribe(string);
            }
        }
        object = this.subscriptions;
        synchronized (object) {
            this.subscriptions.add(subscriptionRecord);
            for (String string2 : this.subscriptionsMap.keySet()) {
                if (!subscriptionRecord.pat.matcher(string2).matches()) continue;
                ArrayList<SubscriptionRecord> arrayList = this.subscriptionsMap.get(string2);
                arrayList.add(subscriptionRecord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String string, LCMSubscriber lCMSubscriber) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        Object object = this;
        synchronized (object) {
            for (Provider object2 : this.providers) {
                object2.unsubscribe(string);
            }
        }
        object = this.subscriptions;
        synchronized (object) {
            Iterator<Object> iterator = this.subscriptions.iterator();
            while (iterator.hasNext()) {
                SubscriptionRecord subscriptionRecord = (SubscriptionRecord)iterator.next();
                if (lCMSubscriber != null && subscriptionRecord.lcsub != lCMSubscriber || string != null && !subscriptionRecord.regex.equals(string)) continue;
                iterator.remove();
            }
            for (String string2 : this.subscriptionsMap.keySet()) {
                Iterator<SubscriptionRecord> iterator2 = this.subscriptionsMap.get(string2).iterator();
                while (iterator2.hasNext()) {
                    SubscriptionRecord subscriptionRecord = iterator2.next();
                    if (lCMSubscriber != null && subscriptionRecord.lcsub != lCMSubscriber || string != null && !subscriptionRecord.regex.equals(string)) continue;
                    iterator2.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMessage(String string, byte[] byArray, int n, int n2) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        ArrayList<SubscriptionRecord> arrayList = this.subscriptions;
        synchronized (arrayList) {
            ArrayList<SubscriptionRecord> arrayList2 = this.subscriptionsMap.get(string);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList();
                this.subscriptionsMap.put(string, arrayList2);
                for (SubscriptionRecord subscriptionRecord : this.subscriptions) {
                    if (!subscriptionRecord.pat.matcher(string).matches()) continue;
                    arrayList2.add(subscriptionRecord);
                }
            }
            for (SubscriptionRecord subscriptionRecord : arrayList2) {
                subscriptionRecord.lcsub.messageReceived(this, string, new LCMDataInputStream(byArray, n, n2));
            }
        }
    }

    public synchronized void subscribeAll(LCMSubscriber lCMSubscriber) {
        this.subscribe(".*", lCMSubscriber);
    }

    public synchronized void close() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        for (Provider provider : this.providers) {
            provider.close();
        }
        this.providers = null;
        this.closed = true;
    }

    public static void main(String[] stringArray) {
        LCM lCM;
        try {
            lCM = new LCM(new String[0]);
        }
        catch (IOException iOException) {
            System.err.println("ex: " + iOException);
            return;
        }
        lCM.subscribeAll(new SimpleSubscriber());
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                    lCM.publish("TEST", "foobar");
                }
            }
            catch (Exception exception) {
                System.err.println("ex: " + exception);
                continue;
            }
            break;
        }
    }

    static class SimpleSubscriber
    implements LCMSubscriber {
        SimpleSubscriber() {
        }

        public void messageReceived(LCM lCM, String string, LCMDataInputStream lCMDataInputStream) {
            System.err.println("RECV: " + string);
        }
    }

    static class SubscriptionRecord {
        String regex;
        Pattern pat;
        LCMSubscriber lcsub;

        SubscriptionRecord() {
        }
    }
}

