/*
 * Decompiled with CFR 0.152.
 */
package lcm.lcm;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;

public final class LCMDataInputStream
implements DataInput {
    byte[] buf;
    int pos = 0;
    int len;
    int startpos;
    int endpos;

    public LCMDataInputStream(byte[] byArray) {
        this.buf = byArray;
        this.endpos = byArray.length + 1;
    }

    public LCMDataInputStream(byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.pos = n;
        this.startpos = n;
        this.endpos = n + n2 + 1;
    }

    void needInput(int n) throws EOFException {
        if (this.pos + n >= this.endpos) {
            throw new EOFException("LCMDataInputStream needed " + n + " bytes, only " + this.available() + " available.");
        }
    }

    public int available() {
        return this.endpos - this.pos - 1;
    }

    public void close() {
    }

    public void reset() {
        this.pos = this.startpos;
    }

    public boolean readBoolean() throws IOException {
        this.needInput(1);
        return this.buf[this.pos++] != 0;
    }

    public byte readByte() throws IOException {
        this.needInput(1);
        return this.buf[this.pos++];
    }

    public int readUnsignedByte() throws IOException {
        this.needInput(1);
        return this.buf[this.pos++] & 0xFF;
    }

    public char readChar() throws IOException {
        return (char)this.readShort();
    }

    public short readShort() throws IOException {
        this.needInput(2);
        return (short)((this.buf[this.pos++] & 0xFF) << 8 | (this.buf[this.pos++] & 0xFF) << 0);
    }

    public int readUnsignedShort() throws IOException {
        this.needInput(2);
        return (this.buf[this.pos++] & 0xFF) << 8 | (this.buf[this.pos++] & 0xFF) << 0;
    }

    public int readInt() throws IOException {
        this.needInput(4);
        return (this.buf[this.pos++] & 0xFF) << 24 | (this.buf[this.pos++] & 0xFF) << 16 | (this.buf[this.pos++] & 0xFF) << 8 | (this.buf[this.pos++] & 0xFF) << 0;
    }

    public long readLong() throws IOException {
        this.needInput(8);
        return ((long)this.buf[this.pos++] & 0xFFL) << 56 | ((long)this.buf[this.pos++] & 0xFFL) << 48 | ((long)this.buf[this.pos++] & 0xFFL) << 40 | ((long)this.buf[this.pos++] & 0xFFL) << 32 | ((long)this.buf[this.pos++] & 0xFFL) << 24 | ((long)this.buf[this.pos++] & 0xFFL) << 16 | ((long)this.buf[this.pos++] & 0xFFL) << 8 | ((long)this.buf[this.pos++] & 0xFFL) << 0;
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public void readFully(byte[] byArray) throws IOException {
        this.needInput(byArray.length);
        System.arraycopy(this.buf, this.pos, byArray, 0, byArray.length);
        this.pos += byArray.length;
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.needInput(n2);
        System.arraycopy(this.buf, this.pos, byArray, n, n2);
        this.pos += n2;
    }

    public void readFullyBytesAsChars(char[] cArray) throws IOException {
        this.needInput(cArray.length);
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)(this.buf[this.pos++] & 0xFF);
        }
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            this.needInput(1);
            byte by = this.buf[this.pos++];
            if (by == 0) break;
            stringBuffer.append((char)by);
        }
        return stringBuffer.toString();
    }

    public String readStringZ() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.buf[this.pos++] & 0xFF) != 0) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public String readUTF() throws IOException {
        assert (false);
        return null;
    }

    public int skipBytes(int n) {
        this.pos += n;
        return n;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int getBufferOffset() {
        return this.pos;
    }
}

