/*
 * Decompiled with CFR 0.152.
 */
package lcm.lcm;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import lcm.lcm.LCM;
import lcm.lcm.Provider;
import lcm.lcm.URLParser;

public class TCPProvider
implements Provider {
    LCM lcm;
    static final int DEFAULT_PORT = 7700;
    static final String DEFAULT_NETWORK = "127.0.0.1:7700";
    InetAddress inetAddr;
    int inetPort;
    ReaderThread reader;
    public static final int MAGIC_SERVER = 678828026;
    public static final int MAGIC_CLIENT = 678828027;
    public static final int VERSION = 256;
    public static final int MESSAGE_TYPE_PUBLISH = 1;
    public static final int MESSAGE_TYPE_SUBSCRIBE = 2;
    public static final int MESSAGE_TYPE_UNSUBSCRIBE = 3;

    public TCPProvider(LCM lCM, URLParser uRLParser) throws IOException {
        this.lcm = lCM;
        String[] stringArray = uRLParser.get("network", DEFAULT_NETWORK).split(":");
        if (stringArray.length == 1) {
            this.inetAddr = InetAddress.getByName(stringArray[0]);
            this.inetPort = 7700;
        } else if (stringArray.length == 2) {
            this.inetAddr = InetAddress.getByName(stringArray[0]);
            this.inetPort = Integer.valueOf(stringArray[1]);
        } else {
            System.err.println("TCPProvider: Don't know how to parse " + uRLParser.get("network", DEFAULT_NETWORK));
            System.exit(-1);
        }
        this.reader = new ReaderThread();
        this.reader.start();
    }

    public synchronized void publish(String string, byte[] byArray, int n, int n2) {
        try {
            this.publishEx(string, byArray, n, n2);
        }
        catch (Exception exception) {
            System.err.println("ex: " + exception);
        }
    }

    private void sockWriteAndFlush(byte[] byArray) {
        OutputStream outputStream = this.reader.getOutputStream();
        if (outputStream != null) {
            try {
                outputStream.write(byArray);
                outputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public synchronized void subscribe(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("lcm.TCPProvider: Bad channel name" + string);
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length() + 8);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(2);
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray, 0, byArray.length);
            this.sockWriteAndFlush(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void unsubscribe(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("lcm.TCPProvider: Bad channel name" + string);
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length() + 8);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(3);
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray, 0, byArray.length);
            this.sockWriteAndFlush(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void close() {
        if (null != this.reader) {
            this.reader.close();
            try {
                this.reader.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.reader = null;
    }

    static final void safeSleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void publishEx(String string, byte[] byArray, int n, int n2) throws Exception {
        byte[] byArray2 = string.getBytes("US-ASCII");
        int n3 = byArray2.length + n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2 + string.length() + 32);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(1);
        dataOutputStream.writeInt(byArray2.length);
        dataOutputStream.write(byArray2, 0, byArray2.length);
        dataOutputStream.writeInt(n2);
        dataOutputStream.write(byArray, n, n2);
        this.sockWriteAndFlush(byteArrayOutputStream.toByteArray());
    }

    class ReaderThread
    extends Thread {
        Socket sock;
        DataInputStream ins;
        OutputStream outs;
        boolean exit = false;
        int serverVersion;

        ReaderThread() {
        }

        public void run() {
            while (!this.exit) {
                try {
                    this.sock = new Socket(TCPProvider.this.inetAddr, TCPProvider.this.inetPort);
                    OutputStream outputStream = this.sock.getOutputStream();
                    DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
                    dataOutputStream.writeInt(678828027);
                    dataOutputStream.writeInt(256);
                    dataOutputStream.flush();
                    this.outs = outputStream;
                    this.ins = new DataInputStream(new BufferedInputStream(this.sock.getInputStream()));
                    int n = this.ins.readInt();
                    if (n != 678828026) {
                        this.sock.close();
                        continue;
                    }
                    this.serverVersion = this.ins.readInt();
                }
                catch (IOException iOException) {
                    System.err.println("lcm.TCPProvider: Unable to connect to " + TCPProvider.this.inetAddr + ":" + TCPProvider.this.inetPort);
                    TCPProvider.safeSleep(500);
                    continue;
                }
                try {
                    while (!this.exit) {
                        int n = this.ins.readInt();
                        int n2 = this.ins.readInt();
                        byte[] byArray = new byte[n2];
                        this.ins.readFully(byArray);
                        int n3 = this.ins.readInt();
                        byte[] byArray2 = new byte[n3];
                        this.ins.readFully(byArray2);
                        TCPProvider.this.lcm.receiveMessage(new String(byArray), byArray2, 0, byArray2.length);
                    }
                }
                catch (IOException iOException) {
                }
            }
        }

        void close() {
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.exit = true;
        }

        OutputStream getOutputStream() {
            return this.outs;
        }
    }
}

