/*
 * Decompiled with CFR 0.152.
 */
package lcm.logging;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import lcm.lcm.LCM;
import lcm.logging.JScrubber;
import lcm.logging.JScrubberListener;
import lcm.logging.Log;

public class LogPlayer
extends JComponent {
    Log log;
    JButton playButton = new JButton("Play ");
    JButton stepButton = new JButton("Step");
    JButton fasterButton;
    JButton slowerButton;
    JLabel speedLabel = new JLabel("1.0", 0);
    double speed = 1.0;
    static final int POS_MAX = 10000;
    JLabel posLabel = new JLabel("Event 0");
    JLabel timeLabel = new JLabel("Time 0.0s");
    JLabel actualSpeedLabel = new JLabel("1.0x");
    JLabel logName = new JLabel("---");
    PlayerThread player = null;
    LCM lcm;
    long timeOffset = 0L;
    JFileChooser jfc = new JFileChooser();
    String currentLogPath;
    double total_seconds;
    BlockingQueue<QueuedEvent> events = new LinkedBlockingQueue<QueuedEvent>();
    Object sync = new Object();
    FilterTableModel filterTableModel = new FilterTableModel();
    ArrayList<Filter> filters = new ArrayList();
    JTable filterTable = new JTable(this.filterTableModel);
    HashMap<String, Filter> filterMap = new HashMap();
    JTextField inchannel = new JTextField();
    JTextField outchannel = new JTextField();
    JScrubber js = new JScrubber();
    boolean show_absolute_time = false;
    JTextField stepChannelField = new JTextField("");
    long lastEventTime;
    long lastSystemTime;
    static LogPlayer p;

    static final double slowerSpeed(double d) {
        return d / 2.0;
    }

    static final double fasterSpeed(double d) {
        return d * 2.0;
    }

    void setSpeed(double d) {
        this.speedLabel.setText("" + d);
        this.speed = d;
    }

    public LogPlayer(String string) throws IOException {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(0, 0, 0, 0);
        int n = 0;
        this.logName.setText("No log loaded");
        this.logName.setFont(new Font("SansSerif", 0, 10));
        this.timeLabel.setFont(new Font("SansSerif", 0, 10));
        this.posLabel.setFont(new Font("SansSerif", 0, 10));
        this.actualSpeedLabel.setFont(new Font("SansSerif", 0, 10));
        this.fasterButton = new JButton(new ImageIcon(LogPlayer.makeArrowImage(Color.blue, this.getBackground(), false)));
        this.fasterButton.setRolloverIcon(new ImageIcon(LogPlayer.makeArrowImage(Color.magenta, this.getBackground(), false)));
        this.fasterButton.setPressedIcon(new ImageIcon(LogPlayer.makeArrowImage(Color.red, this.getBackground(), false)));
        this.fasterButton.setBorderPainted(false);
        this.fasterButton.setContentAreaFilled(false);
        this.slowerButton = new JButton(new ImageIcon(LogPlayer.makeArrowImage(Color.blue, this.getBackground(), true)));
        this.slowerButton.setRolloverIcon(new ImageIcon(LogPlayer.makeArrowImage(Color.magenta, this.getBackground(), true)));
        this.slowerButton.setPressedIcon(new ImageIcon(LogPlayer.makeArrowImage(Color.red, this.getBackground(), true)));
        this.slowerButton.setBorderPainted(false);
        this.slowerButton.setContentAreaFilled(false);
        Font font = new Font("SansSerif", 0, 10);
        this.fasterButton.setFont(font);
        this.slowerButton.setFont(font);
        this.playButton.setFont(font);
        this.stepButton.setFont(font);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 3, 0, 0));
        jPanel.add(this.slowerButton);
        jPanel.add(this.speedLabel);
        jPanel.add(this.fasterButton);
        this.add((Component)this.logName, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this.playButton, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        this.add((Component)this.stepButton, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(3, n, 0, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        this.add((Component)this.js, new GridBagConstraints(0, ++n, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.timeLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.actualSpeedLabel, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.posLabel, new GridBagConstraints(3, n, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)new JScrollPane(this.filterTable), new GridBagConstraints(0, ++n, 0, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(Box.createHorizontalStrut(90), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add(Box.createHorizontalStrut(100), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        ++n;
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JLabel("Channel Prefix: "), "West");
        jPanel2.add((Component)this.stepChannelField, "Center");
        JButton jButton = new JButton("Toggle Selected");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int[] nArray = LogPlayer.this.filterTable.getSelectedRows();
                for (n = 0; n < nArray.length; ++n) {
                    Filter filter = LogPlayer.this.filters.get(nArray[n]);
                    filter.enabled = !filter.enabled;
                }
                LogPlayer.this.filterTableModel.fireTableDataChanged();
                for (n = 0; n < nArray.length; ++n) {
                    LogPlayer.this.filterTable.addRowSelectionInterval(nArray[n], nArray[n]);
                }
            }
        });
        this.add((Component)jButton, new GridBagConstraints(0, n, 2, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        this.add((Component)jPanel2, new GridBagConstraints(2, n, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.setPlaying(false);
        this.fasterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPlayer.this.setSpeed(LogPlayer.fasterSpeed(LogPlayer.this.speed));
            }
        });
        this.slowerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPlayer.this.setSpeed(LogPlayer.slowerSpeed(LogPlayer.this.speed));
            }
        });
        this.playButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPlayer.this.events.offer(new PlayPauseEvent());
            }
        });
        this.stepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPlayer.this.events.offer(new StepEvent());
            }
        });
        this.lcm = null == string ? new LCM(new String[0]) : new LCM(string);
        this.logName.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    LogPlayer.this.openDialog();
                }
            }
        });
        this.timeLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                LogPlayer.this.show_absolute_time = !LogPlayer.this.show_absolute_time;
            }
        });
        this.js.set(0.0);
        this.js.addScrubberListener(new MyScrubberListener());
        this.filterTable.getColumnModel().getColumn(2).setMaxWidth(50);
        this.playButton.setEnabled(false);
        new UDPThread().start();
        new QueueThread().start();
    }

    String getOutputFileFromDialog() {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showSaveDialog(this);
        if (n != 0) {
            return null;
        }
        return jFileChooser.getSelectedFile().getPath();
    }

    void openDialog() {
        this.doStop();
        int n = this.jfc.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        try {
            this.setLog(this.jfc.getSelectedFile().getPath());
        }
        catch (IOException iOException) {
            System.out.println("Exception: " + iOException);
        }
    }

    void savePreferences() throws IOException {
        if (this.currentLogPath == null) {
            return;
        }
        String string = this.currentLogPath + ".jlp";
        FileWriter fileWriter = new FileWriter(string);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        ArrayList<JScrubber.Bookmark> arrayList = this.js.getBookmarks();
        for (JScrubber.Bookmark object : arrayList) {
            String string2 = "PLAIN";
            if (object.type == 1) {
                string2 = "LREPEAT";
            }
            if (object.type == 2) {
                string2 = "RREPEAT";
            }
            bufferedWriter.write("BOOKMARK " + string2 + " " + object.position + "\n");
        }
        bufferedWriter.write("ZOOMFRAC " + this.js.getZoomFraction() + "\n");
        for (Filter filter : this.filters) {
            bufferedWriter.write("CHANNEL " + filter.inchannel + " " + filter.outchannel + " " + filter.enabled + "\n");
        }
        bufferedWriter.close();
        fileWriter.close();
    }

    void loadPreferences(String string) throws IOException {
        String string2;
        BufferedReader bufferedReader;
        this.js.clearBookmarks();
        this.filterMap.clear();
        this.filters.clear();
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        while ((string2 = bufferedReader.readLine()) != null) {
            String[] stringArray = string2.split("\\s+");
            if (stringArray[0].equals("BOOKMARK") && stringArray.length == 3) {
                int n = 0;
                if (stringArray[1].equals("RREPEAT")) {
                    n = 2;
                }
                if (stringArray[1].equals("LREPEAT")) {
                    n = 1;
                }
                this.js.addBookmark(n, Double.parseDouble(stringArray[2]));
            }
            if (stringArray[0].equals("CHANNEL") && stringArray.length == 4) {
                Filter filter = this.filterMap.get(stringArray[1]);
                if (filter == null) {
                    filter = new Filter();
                    filter.inchannel = stringArray[1];
                    filter.outchannel = stringArray[1];
                    this.filterMap.put(stringArray[1], filter);
                    this.filters.add(filter);
                }
                filter.outchannel = stringArray[2];
                filter.enabled = Boolean.parseBoolean(stringArray[3]);
            }
            if (!stringArray[0].equals("ZOOMFRAC")) continue;
            this.js.setZoomFraction(Double.parseDouble(stringArray[1]));
        }
        this.filterTableModel.fireTableDataChanged();
    }

    void setLog(String string) throws IOException {
        if (this.currentLogPath != null) {
            this.savePreferences();
        }
        this.currentLogPath = string;
        this.log = new Log(string, "r");
        this.logName.setText(new File(string).getName());
        try {
            Log.Event event = this.log.readNext();
            this.timeOffset = event.utime;
            this.playButton.setEnabled(true);
            this.log.seekPositionFraction(0.1);
            Log.Event event2 = this.log.readNext();
            this.log.seekPositionFraction(0.9);
            Log.Event event3 = this.log.readNext();
            this.total_seconds = (double)(event3.utime - event2.utime) / 1000000.0 / 0.8;
            System.out.printf("Total seconds: %f\n", this.total_seconds);
            this.log.seekPositionFraction(0.0);
        }
        catch (IOException iOException) {
            System.out.println("exception: " + iOException);
        }
        this.loadPreferences(string + ".jlp");
        this.doPlay();
    }

    void setPlaying(boolean bl) {
        this.playButton.setText(bl ? "Pause" : "Play");
        this.stepButton.setEnabled(!bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doStop() {
        PlayerThread playerThread;
        Object object = this.sync;
        synchronized (object) {
            if (this.player == null) {
                return;
            }
            playerThread = this.player;
            playerThread.requestStop();
        }
        try {
            playerThread.join();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Exception: " + interruptedException);
        }
    }

    void doPlay() {
        if (this.player != null) {
            return;
        }
        this.player = new PlayerThread();
        this.player.start();
    }

    void doStep() {
        if (this.player != null) {
            return;
        }
        this.player = new PlayerThread(this.stepChannelField.getText());
        this.player.start();
    }

    void doSeek(double d) {
        assert (this.player == null);
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        try {
            this.log.seekPositionFraction(d);
            Log.Event event = this.log.readNext();
            this.log.seekPositionFraction(d);
            this.js.set(this.log.getPositionFraction());
            this.lastSystemTime = 0L;
            this.updateDisplay(event);
        }
        catch (IOException iOException) {
            System.out.println("exception: " + iOException);
        }
    }

    void updateDisplay(Log.Event event) {
        if (this.show_absolute_time) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.S z");
            Date date = new Date(event.utime / 1000L);
            this.timeLabel.setText(simpleDateFormat.format(date));
        } else {
            this.timeLabel.setText(String.format("%.3f s", (double)(event.utime - this.timeOffset) / 1000000.0));
        }
        this.posLabel.setText("" + event.eventNumber);
        long l = System.currentTimeMillis();
        double d = (double)(l - this.lastSystemTime) / 1000.0;
        if (d > 0.5) {
            double d2 = (double)(event.utime - this.lastEventTime) / 1000000.0 / d;
            this.lastEventTime = event.utime;
            this.lastSystemTime = l;
            this.actualSpeedLabel.setText(String.format("%.2f x", d2));
        }
    }

    public static void usage() {
        System.err.println("usage: lcm-spy [options]");
        System.err.println("");
        System.err.println("lcm-logplayer-gui is the Lightweight Communications and Marshalling");
        System.err.println("log playback tool.  It provides a graphical user interface for playing logfiles");
        System.err.println("recorded with lcm-logger.  Features include random access, different playback ");
        System.err.println("speeds, channel suppression and remapping, and more.");
        System.err.println("");
        System.err.println("Options:");
        System.err.println("  -l, --lcm-url=URL      Use the specified LCM URL");
        System.err.println("  -h, --help             Shows this help text and exits");
        System.err.println("");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        int n;
        if (System.getProperty("java.vendor").indexOf("Free Software Foundation") >= 0) {
            System.err.println("WARNING: Detected gcj. The LCM log player is not known to work well with gcj.");
            System.err.println("         The Sun JRE is recommended.");
        }
        String string = null;
        for (n = 0; n < stringArray.length; ++n) {
            String string2 = stringArray[n];
            if (string2.equals("-h") || string2.equals("--help")) {
                LogPlayer.usage();
                continue;
            }
            if (!string2.equals("-l") && !string2.equals("--lcm-url") && !string2.startsWith("--lcm-url=")) break;
            String string3 = null;
            if (string2.startsWith("--lcm-url=")) {
                string3 = string2.split("=")[1];
            } else if (n < stringArray.length) {
                string3 = stringArray[++n];
            }
            if (null == string3) {
                LogPlayer.usage();
                continue;
            }
            string = string3;
        }
        try {
            p = new LogPlayer(string);
            JFrame jFrame = new JFrame("LogPlayer");
            jFrame.setLayout(new BorderLayout());
            jFrame.add((Component)p, "Center");
            jFrame.pack();
            jFrame.setSize(jFrame.getWidth(), 300);
            jFrame.setVisible(true);
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    try {
                        p.savePreferences();
                    }
                    catch (IOException iOException) {
                        System.out.println("Couldn't save preferences: " + iOException);
                    }
                    System.exit(0);
                }
            });
            if (n < stringArray.length) {
                p.setLog(stringArray[n]);
            } else {
                p.openDialog();
            }
        }
        catch (IOException iOException) {
            System.out.println("Exception: " + iOException);
        }
    }

    static BufferedImage makeArrowImage(Color color, Color color2, boolean bl) {
        int n = 18;
        int n2 = 18;
        BufferedImage bufferedImage = new BufferedImage(n2, n, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(new Color(0, 0, 0, 0));
        graphics2D.fillRect(0, 0, n2, n);
        if (bl) {
            graphics2D.translate(n2 - 1, n / 2);
            graphics2D.scale(-n / 2, n / 2);
        } else {
            graphics2D.translate(0, n / 2);
            graphics2D.scale(n / 2, n / 2);
        }
        graphics2D.setStroke(new BasicStroke(0.0f));
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, -1.0f);
        generalPath.lineTo(1.0f, 0.0f);
        generalPath.lineTo(0.0f, 1.0f);
        generalPath.lineTo(0.0f, -1.0f);
        graphics2D.setColor(color);
        graphics2D.fill(generalPath);
        graphics2D.setColor(Color.black);
        graphics2D.translate(0.75, 0.0);
        graphics2D.setColor(color);
        graphics2D.fill(generalPath);
        graphics2D.setColor(Color.black);
        return bufferedImage;
    }

    static {
        System.setProperty("java.net.preferIPv4Stack", "true");
        System.out.println("LC: Disabling IPV6 support");
    }

    class FilterTableModel
    extends AbstractTableModel {
        FilterTableModel() {
        }

        public int getRowCount() {
            return LogPlayer.this.filters.size();
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Log channel";
                }
                case 1: {
                    return "Playback channel";
                }
                case 2: {
                    return "Enable";
                }
            }
            return "??";
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: 
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Boolean.class;
                }
            }
            return null;
        }

        public Object getValueAt(int n, int n2) {
            Filter filter = LogPlayer.this.filters.get(n);
            switch (n2) {
                case 0: {
                    return filter.inchannel;
                }
                case 1: {
                    return filter.outchannel;
                }
                case 2: {
                    return filter.enabled;
                }
            }
            return "??";
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1 || n2 == 2;
        }

        public void setValueAt(Object object, int n, int n2) {
            Filter filter = LogPlayer.this.filters.get(n);
            if (n2 == 1) {
                filter.outchannel = (String)object;
            }
            if (n2 == 2) {
                filter.enabled = (Boolean)object;
            }
        }
    }

    class PlayerThread
    extends Thread {
        boolean stopflag = false;
        String stopOnChannel;

        public PlayerThread() {
        }

        public PlayerThread(String string) {
            this.stopOnChannel = string;
        }

        public void requestStop() {
            this.stopflag = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            double d = 0.0;
            Object object = LogPlayer.this.sync;
            synchronized (object) {
                LogPlayer.this.setPlaying(true);
            }
            try {
                while (!this.stopflag) {
                    object = LogPlayer.this.log.readNext();
                    if (LogPlayer.this.speed != d) {
                        l4 = ((Log.Event)object).utime;
                        l3 = System.nanoTime() / 1000L;
                        d = LogPlayer.this.speed;
                    }
                    long l6 = ((Log.Event)object).utime - l4;
                    long l7 = System.nanoTime() / 1000L - l3;
                    long l8 = (long)(LogPlayer.this.speed * 16.0);
                    long l9 = l6 - l8 * l7 / 16L;
                    l5 = ((Log.Event)object).utime;
                    try {
                        long l10;
                        for (long i = l9 / 1000L; i > 0L && !this.stopflag; i -= l10) {
                            l10 = Math.min(50L, i);
                            Thread.sleep(l10);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println("Interrupted");
                    }
                    if (!this.stopflag) {
                        Filter filter = LogPlayer.this.filterMap.get(((Log.Event)object).channel);
                        if (filter == null) {
                            filter = new Filter();
                            filter.inchannel = ((Log.Event)object).channel;
                            filter.outchannel = ((Log.Event)object).channel;
                            LogPlayer.this.filterMap.put(filter.inchannel, filter);
                            LogPlayer.this.filters.add(filter);
                            Collections.sort(LogPlayer.this.filters);
                            LogPlayer.this.filterTableModel.fireTableDataChanged();
                        }
                        if (filter.enabled && filter.outchannel.length() > 0) {
                            LogPlayer.this.lcm.publish(filter.outchannel, ((Log.Event)object).data, 0, ((Log.Event)object).data.length);
                        }
                        LogPlayer.this.js.set(LogPlayer.this.log.getPositionFraction());
                        long l11 = System.currentTimeMillis();
                        if (l11 - l2 > 100L) {
                            LogPlayer.this.updateDisplay((Log.Event)object);
                            l2 = l11;
                        }
                        if (this.stopOnChannel == null || !((Log.Event)object).channel.startsWith(this.stopOnChannel)) continue;
                        this.stopflag = true;
                    }
                    break;
                }
            }
            catch (EOFException eOFException) {
                this.stopflag = true;
            }
            catch (IOException iOException) {
                System.out.println("Exception: " + iOException);
                this.stopflag = true;
            }
            object = LogPlayer.this.sync;
            synchronized (object) {
                LogPlayer.this.setPlaying(false);
                LogPlayer.this.player = null;
            }
        }
    }

    class UDPThread
    extends Thread {
        UDPThread() {
        }

        public void run() {
            DatagramSocket datagramSocket;
            DatagramPacket datagramPacket = new DatagramPacket(new byte[1024], 1024);
            try {
                datagramSocket = new DatagramSocket(53261, Inet4Address.getByName("127.0.0.1"));
            }
            catch (SocketException socketException) {
                System.out.println("Exception: " + socketException);
                return;
            }
            catch (UnknownHostException unknownHostException) {
                System.out.println("Exception: " + unknownHostException);
                return;
            }
            while (true) {
                try {
                    while (true) {
                        double d;
                        double d2;
                        datagramSocket.receive(datagramPacket);
                        String string = new String(datagramPacket.getData(), 0, datagramPacket.getLength());
                        string = string.trim();
                        if (string.equals("PLAYPAUSETOGGLE")) {
                            LogPlayer.this.events.offer(new PlayPauseEvent());
                            continue;
                        }
                        if (string.equals("STEP")) {
                            LogPlayer.this.events.offer(new StepEvent());
                            continue;
                        }
                        if (string.equals("FASTER")) {
                            LogPlayer.this.setSpeed(LogPlayer.fasterSpeed(LogPlayer.this.speed));
                            continue;
                        }
                        if (string.equals("SLOWER")) {
                            LogPlayer.this.setSpeed(LogPlayer.slowerSpeed(LogPlayer.this.speed));
                            continue;
                        }
                        if (string.startsWith("BACK")) {
                            d2 = Double.parseDouble(string.substring(4));
                            d = LogPlayer.this.log.getPositionFraction() - d2 / LogPlayer.this.total_seconds;
                            LogPlayer.this.events.offer(new SeekEvent(d));
                            continue;
                        }
                        if (string.startsWith("FORWARD")) {
                            d2 = Double.parseDouble(string.substring(7));
                            d = LogPlayer.this.log.getPositionFraction() + d2 / LogPlayer.this.total_seconds;
                            LogPlayer.this.events.offer(new SeekEvent(d));
                            continue;
                        }
                        System.out.println("Unknown remote command: " + string);
                    }
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
        }
    }

    class MyScrubberListener
    implements JScrubberListener {
        MyScrubberListener() {
        }

        public void scrubberMovedByUser(JScrubber jScrubber, double d) {
            LogPlayer.this.events.offer(new SeekEvent(d));
        }

        public void scrubberPassedRepeat(JScrubber jScrubber, double d, double d2) {
            LogPlayer.this.events.offer(new SeekEvent(d2));
        }

        public void scrubberExportRegion(JScrubber jScrubber, double d, double d2) {
            System.out.printf("Export %15f %15f\n", d, d2);
            String string = LogPlayer.this.getOutputFileFromDialog();
            if (string == null) {
                return;
            }
            System.out.println("Exporting to " + string);
            try {
                Log log = new Log(LogPlayer.this.log.getPath(), "r");
                Log log2 = new Log(string, "rw");
                log.seekPositionFraction(d);
                while (log.getPositionFraction() < d2) {
                    Log.Event event = log.readNext();
                    Filter filter = LogPlayer.this.filterMap.get(event.channel);
                    if (filter == null || !filter.enabled) continue;
                    log2.write(event);
                }
                log.close();
                log2.close();
                System.out.printf("Done!\n", new Object[0]);
            }
            catch (IOException iOException) {
                System.out.println("Exception: " + iOException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Filter
    implements Comparable<Filter> {
        String inchannel;
        String outchannel;
        boolean enabled = true;

        Filter() {
        }

        @Override
        public int compareTo(Filter filter) {
            return this.inchannel.compareTo(filter.inchannel);
        }
    }

    class StepEvent
    implements QueuedEvent {
        StepEvent() {
        }

        public void execute(LogPlayer logPlayer) {
            LogPlayer.this.doStep();
        }
    }

    class SeekEvent
    implements QueuedEvent {
        double pos;

        public SeekEvent(double d) {
            this.pos = d;
        }

        public void execute(LogPlayer logPlayer) {
            boolean bl;
            boolean bl2 = bl = LogPlayer.this.player != null;
            if (bl) {
                LogPlayer.this.doStop();
            }
            LogPlayer.this.doSeek(this.pos);
            if (bl) {
                LogPlayer.this.doPlay();
            }
        }
    }

    class PlayPauseEvent
    implements QueuedEvent {
        boolean toggle = false;
        boolean playstate;

        public PlayPauseEvent() {
            this.toggle = true;
        }

        public PlayPauseEvent(boolean bl) {
            this.playstate = bl;
        }

        public void execute(LogPlayer logPlayer) {
            if (this.toggle) {
                if (LogPlayer.this.player != null) {
                    LogPlayer.this.doStop();
                } else {
                    LogPlayer.this.doPlay();
                }
            } else if (this.playstate) {
                LogPlayer.this.doPlay();
            } else {
                LogPlayer.this.doStop();
            }
        }
    }

    class QueueThread
    extends Thread {
        QueueThread() {
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        QueuedEvent queuedEvent = LogPlayer.this.events.take();
                        queuedEvent.execute(LogPlayer.this);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    static interface QueuedEvent {
        public void execute(LogPlayer var1);
    }
}

