/*
 * Decompiled with CFR 0.152.
 */
package lcm.spy;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import javax.swing.JPanel;

public class ObjectPanel
extends JPanel {
    String name;
    Object o;
    int lastwidth = 400;
    int lastheight = 100;
    ArrayList<Section> sections = new ArrayList();

    public ObjectPanel(String string) {
        this.name = string;
        this.addMouseListener(new MyMouseAdapter());
    }

    public void setObject(Object object) {
        this.o = object;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.lastwidth, this.lastheight);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(Color.black);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        PaintState paintState = new PaintState();
        paintState.g = graphics;
        paintState.fm = fontMetrics;
        paintState.y = paintState.textheight = 15;
        paintState.indent_level = 1;
        paintState.x[0] = 0;
        paintState.x[1] = Math.min(200, n / 3);
        paintState.x[2] = Math.min(paintState.x[1] + 200, 2 * n / 3);
        if (this.o != null) {
            this.paintRecurse(graphics, paintState, "", this.o.getClass(), this.o, false);
        }
        paintState.finish();
        if (paintState.y != this.lastheight) {
            this.lastheight = paintState.y;
            this.invalidate();
            this.getParent().validate();
        }
    }

    void paintRecurse(Graphics graphics, PaintState paintState, String string, Class clazz, Object object, boolean bl) {
        if (object == null) {
            paintState.drawStrings(clazz == null ? "(null)" : clazz.getName(), string, "(null)", bl);
            return;
        }
        if (clazz.equals(Byte.TYPE)) {
            paintState.drawStrings(clazz.getName(), string, String.format("0x%02X   %03d   %+04d   %c", (Byte)object, ((Byte)object).intValue() & 0xFF, (Byte)object, (Byte)object & 0xFF), bl);
        } else if (clazz.isPrimitive()) {
            paintState.drawStrings(clazz.getName(), string, object.toString(), bl);
        } else if (object instanceof Enum) {
            paintState.drawStrings(clazz.getName(), string, ((Enum)object).name(), bl);
        } else if (clazz.equals(String.class)) {
            paintState.drawStrings("String", string, object.toString(), bl);
        } else if (clazz.isArray()) {
            int n = Array.getLength(object);
            int n2 = paintState.beginSection(clazz.getComponentType() + "[]", string + "[" + n + "]", "");
            for (int i = 0; i < n; ++i) {
                this.paintRecurse(graphics, paintState, string + "[" + i + "]", clazz.getComponentType(), Array.get(object, i), bl);
            }
            paintState.endSection(n2);
        } else {
            Field[] fieldArray;
            int n = paintState.beginSection(clazz.getName(), string, "");
            for (Field field : fieldArray = clazz.getFields()) {
                try {
                    this.paintRecurse(graphics, paintState, field.getName(), field.getType(), field.get(object), bl || (field.getModifiers() & 8) != 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            paintState.endSection(n);
        }
    }

    class MyMouseAdapter
    extends MouseAdapter {
        MyMouseAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = -1;
            for (int i = 0; i < ObjectPanel.this.sections.size(); ++i) {
                Section section = ObjectPanel.this.sections.get(i);
                if (n < section.x0 || n > section.x1 || n2 < section.y0 || n2 > section.y1) continue;
                n3 = i;
            }
            if (n3 >= 0) {
                ObjectPanel.this.sections.get((int)n3).collapsed ^= true;
            }
        }
    }

    class PaintState {
        Color[] indentColors = new Color[]{new Color(255, 255, 255), new Color(230, 230, 255), new Color(200, 200, 255)};
        Graphics g;
        FontMetrics fm;
        int indent_level;
        int color_level;
        int y;
        int textheight;
        int[] x = new int[3];
        int indentpx = 20;
        int maxwidth;
        int nextsection = 0;
        int collapse_depth = 0;

        PaintState() {
        }

        public int beginSection(String string, String string2, String string3) {
            Section section;
            int n;
            if ((n = this.nextsection++) == ObjectPanel.this.sections.size()) {
                section = new Section();
                ObjectPanel.this.sections.add(section);
            }
            section = ObjectPanel.this.sections.get(n);
            if (this.collapse_depth == 0) {
                this.beginColorBlock();
                this.spacer();
                Font font = this.g.getFont();
                this.g.setFont(font.deriveFont(1));
                String string4 = section.collapsed ? "+" : "-";
                this.g.setColor(Color.white);
                this.g.fillRect(this.x[0] + this.indent_level * this.indentpx, this.y, 1, 1);
                this.g.setColor(Color.black);
                this.g.drawString(string4, this.x[0] + this.indent_level * this.indentpx, this.y);
                this.g.drawString(string, this.x[0] + this.indent_level * this.indentpx + 10, this.y);
                this.g.drawString(string2, this.x[1], this.y);
                this.g.drawString(string3, this.x[2], this.y);
                this.g.setFont(font);
                section.x0 = this.x[0];
                section.x1 = ObjectPanel.this.getWidth();
                section.y0 = this.y - this.textheight;
                section.y1 = this.y;
                this.y += this.textheight;
                this.indent();
            } else {
                section.x0 = 0;
                section.x1 = 0;
                section.y0 = 0;
                section.y1 = 0;
            }
            if (ObjectPanel.this.sections.get((int)n).collapsed) {
                ++this.collapse_depth;
            }
            return n;
        }

        public void endSection(int n) {
            Section section = ObjectPanel.this.sections.get(n);
            section.y1 = this.y;
            if (ObjectPanel.this.sections.get((int)n).collapsed) {
                --this.collapse_depth;
            }
            this.unindent();
            this.spacer();
            this.endColorBlock();
            this.spacer();
        }

        public void drawStrings(String string, String string2, String string3, boolean bl) {
            if (this.collapse_depth > 0) {
                return;
            }
            Font font = this.g.getFont();
            if (bl) {
                this.g.setFont(font.deriveFont(2));
            }
            this.g.drawString(string, this.x[0] + this.indent_level * this.indentpx, this.y);
            this.g.drawString(string2, this.x[1], this.y);
            this.g.drawString(string3, this.x[2], this.y);
            this.y += this.textheight;
            this.g.setFont(font);
        }

        public void spacer() {
            if (this.collapse_depth > 0) {
                return;
            }
            this.y += this.textheight / 2;
        }

        public void beginColorBlock() {
            if (this.collapse_depth > 0) {
                return;
            }
            ++this.color_level;
            this.g.setColor(this.indentColors[this.color_level % this.indentColors.length]);
            this.g.fillRect(this.x[0] + this.indent_level * this.indentpx - this.indentpx / 2, this.y - this.fm.getMaxAscent(), ObjectPanel.this.getWidth(), ObjectPanel.this.getHeight());
            this.g.setColor(Color.black);
        }

        public void endColorBlock() {
            if (this.collapse_depth > 0) {
                return;
            }
            --this.color_level;
            this.g.setColor(this.indentColors[this.color_level % this.indentColors.length]);
            this.g.fillRect(this.x[0] + this.indent_level * this.indentpx - this.indentpx / 2, this.y - this.fm.getMaxAscent(), ObjectPanel.this.getWidth(), ObjectPanel.this.getHeight());
            this.g.setColor(Color.black);
        }

        public void indent() {
            ++this.indent_level;
        }

        public void unindent() {
            --this.indent_level;
        }

        public void finish() {
            this.g.setColor(Color.white);
            this.g.fillRect(0, this.y, ObjectPanel.this.getWidth(), ObjectPanel.this.getHeight());
        }
    }

    class Section {
        int x0;
        int y0;
        int x1;
        int y1;
        boolean collapsed;

        Section() {
        }
    }
}

