/*
 * Decompiled with CFR 0.152.
 */
package lcm.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassDiscoverer {
    public static void findClasses(ClassVisitor classVisitor) {
        String string = System.getProperty("path.separator");
        String string2 = System.getenv("CLASSPATH") + string + System.getProperty("java.class.path");
        ClassDiscoverer.findClasses(string2, classVisitor);
    }

    public static void findClasses(String string, ClassVisitor classVisitor) {
        URLClassLoader uRLClassLoader;
        if (string == null) {
            return;
        }
        String string2 = System.getProperty("path.separator");
        String[] stringArray = string.split(string2);
        try {
            URL[] uRLArray = new URL[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                uRLArray[i] = new File(stringArray[i]).toURL();
            }
            uRLClassLoader = new URLClassLoader(uRLArray);
        }
        catch (IOException iOException) {
            System.out.println("ClassDiscoverer ERR: " + iOException);
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (!string3.endsWith(".jar") || !new File(string3).exists()) continue;
            try {
                JarFile jarFile = new JarFile(string3);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    String string4 = jarEntry.getName();
                    if (!string4.endsWith(".class")) continue;
                    String string5 = string4.substring(0, string4.length() - 6);
                    string5 = string5.replace('/', '.');
                    string5 = string5.replace('\\', '.');
                    try {
                        Class<?> clazz = uRLClassLoader.loadClass(string5);
                        if (clazz == null) continue;
                        classVisitor.classFound(string3, clazz);
                    }
                    catch (Throwable throwable) {
                        System.out.println("ClassDiscoverer: " + throwable);
                        System.out.println("                 jar: " + string3);
                        System.out.println("                 class: " + string4);
                    }
                }
                continue;
            }
            catch (IOException iOException) {
                System.out.println("Error extracting " + stringArray[i]);
            }
        }
    }

    public static void main(String[] stringArray) {
        ClassVisitor classVisitor = new ClassVisitor(){

            public void classFound(String string, Class clazz) {
                System.out.printf("%-30s %s\n", string, clazz);
            }
        };
        ClassDiscoverer.findClasses(classVisitor);
    }

    public static interface ClassVisitor {
        public void classFound(String var1, Class var2);
    }
}

