/*
 * Decompiled with CFR 0.152.
 */
package maslab.camera;

import au.edu.jcu.v4l4j.Control;
import au.edu.jcu.v4l4j.ControlList;
import au.edu.jcu.v4l4j.DeviceInfo;
import au.edu.jcu.v4l4j.FrameGrabber;
import au.edu.jcu.v4l4j.PushSourceCallback;
import au.edu.jcu.v4l4j.VideoDevice;
import au.edu.jcu.v4l4j.VideoFrame;
import au.edu.jcu.v4l4j.exceptions.ControlException;
import au.edu.jcu.v4l4j.exceptions.V4L4JException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;
import maslab.camera.ImageConvert;

public class Camera
implements PushSourceCallback {
    public static final int DEFAULT_WIDTH = 320;
    public static final int DEFAULT_HEIGHT = 240;
    private final String dev;
    private int width;
    private int height;
    private VideoDevice vd;
    private FrameGrabber fg;
    private ControlList cl;
    private final Object lock = new Object();
    private final String encoding;
    private boolean newFrameAvailable = false;
    private VideoFrame currentFrame;
    private Thread hook = null;

    public Camera(String dev, int width, int height, int q) throws IOException {
        this.dev = dev;
        try {
            this.vd = new VideoDevice(dev);
            this.cl = this.vd.getControlList();
            this.fg = this.vd.getJPEGFrameGrabber(width, height, 0, 0, q);
            this.encoding = "MJPG";
            this.width = this.fg.getWidth();
            this.height = this.fg.getHeight();
            this.fg.setPushSourceMode(this);
            this.fg.setFrameInterval(1, 30);
            this.fg.startCapture();
            this.addShutdownHook();
        }
        catch (V4L4JException e) {
            e.printStackTrace();
            throw new IOException("Error opening camera!");
        }
    }

    public Camera(String dev, int width, int height) throws IOException {
        this.dev = dev;
        try {
            this.vd = new VideoDevice(dev);
            this.cl = this.vd.getControlList();
            this.fg = this.vd.getRawFrameGrabber(width, height, 0, 0);
            this.encoding = "YUYV";
            this.width = this.fg.getWidth();
            this.height = this.fg.getHeight();
            this.fg.setPushSourceMode(this);
            this.fg.setFrameInterval(1, 30);
            this.fg.startCapture();
            this.addShutdownHook();
        }
        catch (V4L4JException e) {
            e.printStackTrace();
            throw new IOException("Error opening camera!");
        }
    }

    public Camera(String dev) throws IOException {
        this(dev, 320, 240);
    }

    public void changeFrameRate(int fps) throws IOException {
        this.fg.stopCapture();
        this.fg.setFrameInterval(1, fps);
        try {
            this.fg.startCapture();
        }
        catch (V4L4JException e) {
            e.printStackTrace();
            throw new IOException(e);
        }
    }

    public static Camera makeCamera() throws IOException {
        return Camera.makeCamera(Camera.findMaslabWebCam());
    }

    public static Camera makeCamera(String dev) throws IOException {
        return new Camera(dev);
    }

    public static Camera makeCamera(String dev, int w, int h) throws IOException {
        if (w == 640 && h == 480) {
            return new Camera(dev, w, h, 80);
        }
        return new Camera(dev, w, h);
    }

    public static String findMaslabWebCam() {
        String out = null;
        for (int k = 0; k < 10; ++k) {
            String dev = "/dev/video" + k;
            try {
                VideoDevice vd = new VideoDevice(dev);
                DeviceInfo info = vd.getDeviceInfo();
                if (!info.getName().contains("LifeCam VX-2000")) continue;
                out = dev;
                break;
            }
            catch (V4L4JException e) {
                // empty catch block
            }
        }
        return out;
    }

    private void addShutdownHook() {
        if (this.hook == null) {
            this.hook = new Thread(){

                @Override
                public void run() {
                    Camera.this.releaseResourcesInner();
                }
            };
            Runtime.getRuntime().addShutdownHook(this.hook);
        }
    }

    private void releaseResourcesInner() {
        this.fg.stopCapture();
        this.vd.releaseFrameGrabber();
        this.vd.releaseControlList();
        this.vd.release();
    }

    public void close() {
        Runtime.getRuntime().removeShutdownHook(this.hook);
        this.releaseResourcesInner();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getDevice() {
        return this.dev;
    }

    @Deprecated
    public synchronized BufferedImage capture() {
        return this.capture(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized BufferedImage capture(boolean wait) {
        Object object = this.lock;
        synchronized (object) {
            if (wait && !this.newFrameAvailable) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return null;
                }
            } else if (!this.newFrameAvailable) {
                return null;
            }
            VideoFrame vf = this.currentFrame;
            this.newFrameAvailable = false;
            BufferedImage out = ImageConvert.convertToImage(this.encoding, this.width, this.height, vf.getBytes());
            return out;
        }
    }

    public int getValue(String control) throws IOException {
        int out = -1;
        try {
            out = this.cl.getControl(control).getValue();
        }
        catch (ControlException e) {
            e.printStackTrace();
            throw new IOException("Error getting value for control: " + control);
        }
        return out;
    }

    public int setValue(String control, int value) throws IOException {
        try {
            return this.cl.getControl(control).setValue(value);
        }
        catch (ControlException e) {
            e.printStackTrace();
            throw new IOException("Error setting value for control: " + control);
        }
    }

    public int getMaxValue(String control) {
        Integer out = null;
        out = this.cl.getControl(control).getMaxValue();
        return out;
    }

    public int getMinValue(String control) {
        return this.cl.getControl(control).getMinValue();
    }

    public int getSharpness() throws IOException {
        return this.getValue("Sharpness");
    }

    public int setSharpness(int value) throws IOException {
        return this.setValue("Sharpness", value);
    }

    public int getMaxSharpness() {
        return this.getMaxValue("Sharpness");
    }

    public int getMinSharpness() {
        return this.getMinValue("Sharpness");
    }

    public int getContrast() throws IOException {
        return this.getValue("Contrast");
    }

    public int setContrast(int value) throws IOException {
        return this.setValue("Contrast", value);
    }

    public int getMaxContrast() {
        return this.getMaxValue("Contrast");
    }

    public int getMinContrast() {
        return this.getMinValue("Contrast");
    }

    public int getBrightness() throws IOException {
        return this.getValue("Brightness");
    }

    public int setBrightness(int value) throws IOException {
        return this.setValue("Brightness", value);
    }

    public int getMaxBrightness() {
        return this.getMaxValue("Brightness");
    }

    public int getMinBrightness() {
        return this.getMinValue("Brightness");
    }

    public int getWhiteBalance() throws IOException {
        return this.getValue("White Balance Temperature");
    }

    public int setWhiteBalance(int value) throws IOException {
        return this.setValue("White Balance Temperature", value);
    }

    public int toggleAutoWhiteBalance(boolean auto) throws IOException {
        return this.setValue("White Balance Temperature, Auto", auto ? 1 : 0);
    }

    public int getMaxWhiteBalance() {
        return this.getMaxValue("White Balance Temperature");
    }

    public int getMinWhiteBalance() {
        return this.getMinValue("White Balance Temperature");
    }

    public int getExposure() throws IOException {
        return this.getValue("Exposure (Absolute)");
    }

    public int setExposure(int value) throws IOException {
        this.setValue("Exposure, Auto", 1);
        return this.setValue("Exposure (Absolute)", value);
    }

    public int toggleAutoExposure(boolean auto) throws IOException {
        return this.setValue("Exposure, Auto Priority", auto ? 1 : 0);
    }

    public int getMaxExposure() {
        return this.getMaxValue("Exposure (Absolute)");
    }

    public int getMinExposure() {
        return this.getMinValue("Exposure (Absolute)");
    }

    public ControlList getControlList() {
        return this.cl;
    }

    public static void main(String[] args) throws IOException {
        Camera cam = new Camera("/dev/video1");
        System.out.println("Camera opened on: " + cam.getDevice());
        System.out.println("True width: " + cam.getWidth());
        System.out.println("True Height: " + cam.getHeight());
        System.out.println("Capturing image.");
        BufferedImage img = cam.capture();
        File outFile = new File("test.jpg");
        ImageIO.write((RenderedImage)img, "jpg", outFile);
        System.out.println("Testing frame rate.");
        long begin = System.currentTimeMillis();
        for (int k = 0; k < 100; ++k) {
            img = cam.capture(true);
        }
        long end = System.currentTimeMillis();
        System.out.println("Frame rate: " + 100.0 / (double)(end - begin) * 1000.0);
        System.out.println("Available controls:");
        System.out.println(cam.cl.getTable().keySet());
        for (Map.Entry<String, Control> entry : cam.cl.getTable().entrySet()) {
            System.out.println(entry.getKey() + "," + entry.getValue().getType());
            if (entry.getValue().getType() != 3) continue;
            for (Map.Entry<String, Integer> e : entry.getValue().getDiscreteValuesMap().entrySet()) {
                System.out.println(e.getKey() + ":" + e.getValue());
            }
        }
        System.out.println("Button:0");
        System.out.println("slider:1");
        System.out.println("switch:2");
        System.out.println("discrete:3");
    }

    @Override
    public void exceptionReceived(V4L4JException arg0) {
        System.err.println("Exception received while retrieving frames!!");
        System.err.println("Talk to a staff member if this keeps happening.");
        arg0.printStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nextFrame(VideoFrame arg0) {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentFrame != null) {
                this.currentFrame.recycle();
            }
            this.currentFrame = arg0;
            this.newFrameAvailable = true;
            this.lock.notifyAll();
        }
    }
}

