/*
 * Decompiled with CFR 0.152.
 */
package maslab.camera;

import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import maslab.camera.Camera;
import maslab.camera.ImageUtil;
import maslab.telemetry.channel.ImageChannel;

public class CameraViewer
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Camera cam;
    private final JLabel lblCam = new JLabel();

    public CameraViewer(String dev, int w, int h) throws IOException {
        super("Maslab Camera Viewer");
        this.cam = Camera.makeCamera(Camera.findMaslabWebCam(), w, h);
        BufferedImage img = this.cam.capture(true);
        ImageIcon icon = new ImageIcon(img);
        this.lblCam.setIcon(icon);
        this.add(this.lblCam);
    }

    public void run(boolean hsv, boolean delay) throws IOException {
        ImageChannel chan = new ImageChannel("CameraViewer");
        int k = 0;
        while (true) {
            if (delay) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            BufferedImage img = this.cam.capture(true);
            if (hsv) {
                img = ImageUtil.rgbToHsv(img);
            }
            ImageIcon icon = new ImageIcon(img);
            if (k % 1 == 0) {
                chan.publish(img);
            }
            this.lblCam.setIcon(icon);
            Thread.yield();
            ++k;
        }
    }

    public static void main(String[] args) throws IOException {
        int w = 320;
        int h = 240;
        boolean hsv = false;
        boolean delay = false;
        switch (args.length) {
            case 4: {
                h = Integer.parseInt(args[3]);
                w = Integer.parseInt(args[2]);
            }
            case 2: {
                delay = Boolean.parseBoolean(args[1]);
            }
            case 1: {
                hsv = Boolean.parseBoolean(args[0]);
            }
        }
        CameraViewer viewer = new CameraViewer("/dev/video1", w, h);
        viewer.pack();
        viewer.setVisible(true);
        viewer.run(hsv, delay);
    }
}

