/*
 * Decompiled with CFR 0.152.
 */
package maslab.camera;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.plugins.jpeg.JPEGImageReadParam;
import javax.imageio.plugins.jpeg.JPEGQTable;
import javax.imageio.stream.MemoryCacheImageInputStream;

class ImageConvert {
    ImageConvert() {
    }

    public static BufferedImage debayerGBRG(String format, int width, int height, byte[] d) {
        int nwidth = width / 2;
        int nheight = height / 2;
        BufferedImage im = new BufferedImage(nwidth, nheight, 1);
        int[] i = ((DataBufferInt)im.getRaster().getDataBuffer()).getData();
        for (int y = 0; y < nheight; ++y) {
            for (int x = 0; x < nwidth; ++x) {
                int ix = x * 2;
                int iy = y * 2;
                int g1 = d[(iy + 0) * width + ix + 0] & 0xFF;
                int b1 = d[(iy + 0) * width + ix + 1] & 0xFF;
                int r1 = d[(iy + 1) * width + ix + 0] & 0xFF;
                int g2 = d[(iy + 1) * width + ix + 1] & 0xFF;
                i[y * nwidth + x + 0] = r1 << 16 | (g1 + g2) / 2 << 8 | b1;
            }
        }
        return im;
    }

    public static BufferedImage debayerRGGBhalf(String format, int width, int height, byte[] d) {
        int nwidth = width / 2;
        int nheight = height / 2;
        BufferedImage im = new BufferedImage(nwidth, nheight, 1);
        int[] i = ((DataBufferInt)im.getRaster().getDataBuffer()).getData();
        for (int y = 0; y < nheight; ++y) {
            for (int x = 0; x < nwidth; ++x) {
                int ix = x * 2;
                int iy = y * 2;
                int r1 = d[(iy + 0) * width + ix + 0] & 0xFF;
                int g1 = d[(iy + 0) * width + ix + 1] & 0xFF;
                int g2 = d[(iy + 1) * width + ix + 0] & 0xFF;
                int b1 = d[(iy + 1) * width + ix + 1] & 0xFF;
                i[y * nwidth + x + 0] = r1 << 16 | (g1 + g2) / 2 << 8 | b1;
            }
        }
        return im;
    }

    public static BufferedImage debayerRGGB(String format, int width, int height, byte[] d) {
        BufferedImage im = new BufferedImage(width, height, 1);
        int[] out = ((DataBufferInt)im.getRaster().getDataBuffer()).getData();
        for (int y = 0; y < height; y += 2) {
            for (int x = 0; x < width; x += 2) {
                int X00 = (y - 2) * width + (x - 2);
                int X01 = (y - 2) * width + (x + 0);
                int X02 = (y - 2) * width + (x + 2);
                int X10 = (y + 0) * width + (x - 2);
                int X11 = (y + 0) * width + (x + 0);
                int X12 = (y + 0) * width + (x + 2);
                int X20 = (y + 2) * width + (x - 2);
                int X21 = (y + 2) * width + (x + 0);
                int X22 = (y + 2) * width + (x + 2);
                if (y < 2) {
                    X00 += 2 * width;
                    X01 += 2 * width;
                    X02 += 2 * width;
                }
                if (y + 2 >= height) {
                    X20 -= 2 * width;
                    X21 -= 2 * width;
                    X22 -= 2 * width;
                }
                if (x < 2) {
                    X00 += 2;
                    X10 += 2;
                    X20 += 2;
                }
                if (x + 2 >= width) {
                    X02 -= 2;
                    X12 -= 2;
                    X22 -= 2;
                }
                int b00 = d[X00 + width + 1] & 0xFF;
                int g01 = d[X01 + width + 0] & 0xFF;
                int b02 = d[X01 + width + 1] & 0xFF;
                int g03 = d[X02 + width + 0] & 0xFF;
                int g10 = d[X10 + 1] & 0xFF;
                int r11 = d[X11 + 0] & 0xFF;
                int g12 = d[X11 + 1] & 0xFF;
                int r13 = d[X12 + 0] & 0xFF;
                int b20 = d[X10 + width + 1] & 0xFF;
                int g21 = d[X11 + width + 0] & 0xFF;
                int b22 = d[X11 + width + 1] & 0xFF;
                int g23 = d[X12 + width + 0] & 0xFF;
                int g30 = d[X20 + 1] & 0xFF;
                int r31 = d[X21 + 0] & 0xFF;
                int g32 = d[X21 + 1] & 0xFF;
                int r33 = d[X22 + 0] & 0xFF;
                int r = r11;
                int g = (g10 + g01 + g12 + g21) / 4;
                int b = (b00 + b02 + b20 + b22) / 4;
                out[y * width + x] = (r << 16) + (g << 8) + b;
                r = (r11 + r13) / 2;
                g = g12;
                b = (b02 + b22) / 2;
                out[y * width + x + 1] = (r << 16) + (g << 8) + b;
                r = (r11 + r31) / 2;
                g = g21;
                b = (b20 + b22) / 2;
                out[y * width + width + x] = (r << 16) + (g << 8) + b;
                r = (r11 + r13 + r31 + r33) / 4;
                g = (g12 + g21 + g23 + g32) / 4;
                b = b22;
                out[y * width + width + x + 1] = (r << 16) + (g << 8) + b;
            }
        }
        return im;
    }

    public static BufferedImage convertToImage(String format, int width, int height, byte[] d) {
        if (format.equals("BAYER_GBRG")) {
            return ImageConvert.debayerGBRG(format, width, height, d);
        }
        if (format.equals("BAYER_RGGB")) {
            return ImageConvert.debayerRGGB(format, width, height, d);
        }
        if (format.equals("GRAY16")) {
            BufferedImage im = new BufferedImage(width, height, 10);
            byte[] b = ((DataBufferByte)im.getRaster().getDataBuffer()).getData();
            if (b.length == d.length / 2) {
                for (int i = 0; i < b.length; ++i) {
                    b[i] = d[i * 2];
                }
            }
            return im;
        }
        if (format.equals("GRAY8")) {
            BufferedImage im = new BufferedImage(width, height, 10);
            byte[] b = ((DataBufferByte)im.getRaster().getDataBuffer()).getData();
            if (b.length == d.length) {
                for (int i = 0; i < b.length; ++i) {
                    b[i] = d[i];
                }
            }
            return im;
        }
        if (format.equals("BE_GRAY16")) {
            BufferedImage im = new BufferedImage(width, height, 10);
            byte[] b = ((DataBufferByte)im.getRaster().getDataBuffer()).getData();
            if (b.length == d.length / 2) {
                for (int i = 0; i < b.length; ++i) {
                    b[i] = d[i * 2];
                }
            }
            return im;
        }
        if (format.equals("YUYV")) {
            return ImageConvert.convertYUYVtoRGB(width, height, d);
        }
        if (format.equals("RGB")) {
            BufferedImage im = new BufferedImage(width, height, 1);
            int[] in = ((DataBufferInt)im.getRaster().getDataBuffer()).getData();
            int dpos = 0;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int r = d[dpos++] & 0xFF;
                    int g = d[dpos++] & 0xFF;
                    int b = d[dpos++] & 0xFF;
                    in[y * width + x] = (r << 16) + (g << 8) + b;
                }
            }
            return im;
        }
        if (d.length == width * height) {
            BufferedImage im = new BufferedImage(width, height, 10);
            byte[] b = ((DataBufferByte)im.getRaster().getDataBuffer()).getData();
            if (b.length == d.length) {
                System.arraycopy(d, 0, b, 0, d.length);
            }
            return im;
        }
        if (format.equals("MJPG")) {
            try {
                ImageReader reader = ImageIO.getImageReadersBySuffix("jpg").next();
                reader.setInput(new MemoryCacheImageInputStream(new ByteArrayInputStream(d)));
                JPEGImageReadParam params = new JPEGImageReadParam();
                params.setDecodeTables(new JPEGQTable[]{JPEGQTable.K1Luminance}, new JPEGHuffmanTable[]{JPEGHuffmanTable.StdDCLuminance, JPEGHuffmanTable.StdDCChrominance}, new JPEGHuffmanTable[]{JPEGHuffmanTable.StdACLuminance, JPEGHuffmanTable.StdACChrominance});
                BufferedImage im = reader.read(0, params);
                return im;
            }
            catch (IOException ex) {
                System.out.println("ImageConvert: MJPG decode failed: " + ex);
                return null;
            }
        }
        System.out.println("ImageConvert: Unknown type " + format);
        return null;
    }

    public static BufferedImage convertYUYVtoRGB(int width, int height, byte[] yuyv) {
        BufferedImage im = new BufferedImage(width, height, 1);
        int sstride = width * 2;
        int dstride = width * 3;
        int[] rgb = ((DataBufferInt)im.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width / 2; ++j) {
                int y1 = yuyv[i * sstride + 4 * j + 0] & 0xFF;
                int u = yuyv[i * sstride + 4 * j + 1] & 0xFF;
                int y2 = yuyv[i * sstride + 4 * j + 2] & 0xFF;
                int v = yuyv[i * sstride + 4 * j + 3] & 0xFF;
                int cb = (u - 128) * 454 >> 8;
                int cr = (v - 128) * 359 >> 8;
                int cg = (v - 128) * 183 + (u - 128) * 88 >> 8;
                int r = ImageConvert.clamp(y1 + cr);
                int b = ImageConvert.clamp(y1 + cb);
                int g = ImageConvert.clamp(y1 - cg);
                rgb[i * width + 2 * j + 0] = r << 16 | g << 8 | b;
                r = ImageConvert.clamp(y2 + cr);
                b = ImageConvert.clamp(y2 + cb);
                g = ImageConvert.clamp(y2 - cg);
                rgb[i * width + 2 * j + 1] = r << 16 | g << 8 | b;
            }
        }
        return im;
    }

    public static BufferedImage convertRGBtoHSV(int width, int height, byte[] rgb) {
        BufferedImage im = new BufferedImage(width, height, 5);
        byte[] hsv = ((DataBufferByte)im.getRaster().getDataBuffer()).getData();
        int stride = width * 3;
        double hscale = 0.7083333333333334;
        double sscale = 255.0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int min;
                int r = rgb[i * stride + 3 * j + 2] & 0xFF;
                int g = rgb[i * stride + 3 * j + 1] & 0xFF;
                int b = rgb[i * stride + 3 * j + 0] & 0xFF;
                int max = Math.max(r, Math.max(g, b));
                int h = max == (min = Math.min(r, Math.min(g, b))) ? 0 : (max == r ? (int)(60.0 * ((double)(g - b) / (double)(max - min)) + 360.0) % 360 : (max == g ? (int)(60.0 * ((double)(b - r) / (double)(max - min)) + 120.0) : (int)(60.0 * ((double)(r - g) / (double)(max - min)) + 240.0)));
                h = (int)((double)h * hscale);
                int s = max == 0 ? 0 : (int)(sscale * (1.0 - (double)min / (double)max));
                int v = max;
                hsv[i * stride + 3 * j + 0] = (byte)h;
                hsv[i * stride + 3 * j + 1] = (byte)s;
                hsv[i * stride + 3 * j + 2] = (byte)v;
            }
        }
        return im;
    }

    public static BufferedImage convertImage(BufferedImage in, int type) {
        if (in.getType() == type) {
            return in;
        }
        System.out.println("ImageConvert: Performing slow image type conversion");
        int w = in.getWidth();
        int h = in.getHeight();
        BufferedImage out = new BufferedImage(w, h, type);
        Graphics g = out.getGraphics();
        g.drawImage(in, 0, 0, null);
        g.dispose();
        return out;
    }

    static final int clamp(double v) {
        if (v < 0.0) {
            return 0;
        }
        if (v > 255.0) {
            return 255;
        }
        return (int)v;
    }

    static final int clamp(int v) {
        if (v < 0) {
            return 0;
        }
        if (v > 255) {
            return 255;
        }
        return v;
    }

    public static BufferedImage RGBtoHSV(BufferedImage _in) {
        return ImageConvert.RGBtoHSV(_in, 0xFFFFFF);
    }

    public static BufferedImage RGBtoHSV(BufferedImage _in, int outputmask) {
        int width = _in.getWidth();
        int height = _in.getHeight();
        _in = ImageConvert.convertImage(_in, 1);
        int[] in = ((DataBufferInt)_in.getRaster().getDataBuffer()).getData();
        BufferedImage _out = new BufferedImage(width, height, 1);
        int[] out = ((DataBufferInt)_out.getRaster().getDataBuffer()).getData();
        double hscale = 0.7083333333333334;
        double sscale = 255.0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                double min;
                int rgb = in[y * width + x];
                double r = (double)(rgb >> 16 & 0xFF) / 255.0;
                double g = (double)(rgb >> 8 & 0xFF) / 255.0;
                double b = (double)(rgb & 0xFF) / 255.0;
                double max = Math.max(r, Math.max(g, b));
                double h = max == (min = Math.min(r, Math.min(g, b))) ? 0.0 : (max == r ? 60.0 * ((g - b) / (max - min)) + 360.0 : (max == g ? 60.0 * ((b - r) / (max - min)) + 120.0 : 60.0 * ((r - g) / (max - min)) + 240.0));
                double s = max == 0.0 ? 0.0 : (double)((int)(sscale * (1.0 - min / max)));
                double v = max * 255.0;
                h = h * 255.0 / 360.0;
                int hi = (int)h;
                int si = (int)s;
                int vi = (int)v;
                out[y * width + x] = (hi << 16) + (si << 8) + vi & outputmask;
            }
        }
        return _out;
    }

    public static BufferedImage HSVtoRGB(BufferedImage _in) {
        int[] in = ((DataBufferInt)_in.getRaster().getDataBuffer()).getData();
        BufferedImage _out = new BufferedImage(_in.getWidth(), _in.getHeight(), 1);
        int[] out = ((DataBufferInt)_out.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i];
        }
        ImageConvert.HSVtoRGB(out);
        return _out;
    }

    public static void HSVtoRGB(int[] im) {
        block8: for (int j = 0; j < im.length; ++j) {
            int hsv = im[j];
            int hi = hsv >> 16 & 0xFF;
            int si = hsv >> 8 & 0xFF;
            int vi = hsv & 0xFF;
            double h = (double)hi * 360.0 / 255.0;
            h = (h + 360.0) % 360.0;
            double s = (double)si / 255.0;
            double v = (double)vi / 255.0;
            int i = (int)Math.floor(h /= 60.0);
            double f = h - (double)i;
            if (i % 2 == 0) {
                f = 1.0 - f;
            }
            double m = v * (1.0 - s);
            double n = v * (1.0 - s * f);
            int vo = (int)(v * 255.0);
            int no = (int)(n * 255.0);
            int mo = (int)(m * 255.0);
            switch (i) {
                case 0: {
                    im[j] = 0xFF000000 | vo << 16 | no << 8 | mo;
                    continue block8;
                }
                case 1: {
                    im[j] = 0xFF000000 | no << 16 | vo << 8 | mo;
                    continue block8;
                }
                case 2: {
                    im[j] = 0xFF000000 | mo << 16 | vo << 8 | no;
                    continue block8;
                }
                case 3: {
                    im[j] = 0xFF000000 | mo << 16 | no << 8 | vo;
                    continue block8;
                }
                case 4: {
                    im[j] = 0xFF000000 | no << 16 | mo << 8 | vo;
                    continue block8;
                }
                case 5: {
                    im[j] = 0xFF000000 | vo << 16 | mo << 8 | no;
                    continue block8;
                }
                default: {
                    im[j] = 0;
                }
            }
        }
    }

    public static BufferedImage RGBtoYUV(BufferedImage _in) {
        int width = _in.getWidth();
        int height = _in.getHeight();
        _in = ImageConvert.convertImage(_in, 1);
        int[] in = ((DataBufferInt)_in.getRaster().getDataBuffer()).getData();
        BufferedImage _out = new BufferedImage(width, height, 1);
        int[] out = ((DataBufferInt)_out.getRaster().getDataBuffer()).getData();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgb = in[y * width + x];
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                int yc = Math.min(Math.abs(2104 * r + 4130 * g + 802 * b + 4096 + 131072) >> 13, 235);
                int uc = Math.min(Math.abs(-1214 * r - 2384 * g + 3598 * b + 4096 + 0x100000) >> 13, 240);
                int vc = Math.min(Math.abs(3598 * r - 3013 * g - 585 * b + 4096 + 0x100000) >> 13, 240);
                out[y * width + x] = (yc << 16) + (uc << 8) + vc;
            }
        }
        return _out;
    }
}

