/*
 * Decompiled with CFR 0.152.
 */
package maslab.camera;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Random;

public class ImageUtil {
    public static BufferedImage convertImage(BufferedImage in, int type) {
        if (in.getType() == type) {
            return in;
        }
        System.out.println("Performing slow image type conversion");
        int w = in.getWidth();
        int h = in.getHeight();
        BufferedImage out = new BufferedImage(w, h, type);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                out.setRGB(x, y, in.getRGB(x, y));
            }
        }
        return out;
    }

    public static BufferedImage ditherImageFloydSteinberg(BufferedImage in) {
        int gray;
        BufferedImage out = new BufferedImage(in.getWidth(), in.getHeight(), 1);
        int width = in.getWidth();
        int height = in.getHeight();
        int[] d = in.getRGB(0, 0, width, height, null, 0, width);
        int[] dout = new int[width * height];
        int p = 0;
        int sum = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                int c = d[p];
                gray = (int)(0.299 * (double)((c & 0xFF0000) >> 16) + 0.587 * (double)((c & 0xFF00) >> 8) + 0.114 * (double)(c & 0xFF));
                sum += gray;
                d[p] = gray;
                ++x;
                ++p;
            }
        }
        int thresh = sum / (width * height) / 2;
        p = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                gray = d[p];
                int bw = 0;
                if (gray >= thresh) {
                    bw = 255;
                }
                dout[p] = bw | bw << 8 | bw << 16 | 0xFF000000;
                int err = gray - bw;
                if (x < width - 1) {
                    int n = p + 1;
                    d[n] = d[n] + err * 7 / 16;
                }
                if (x > 0 && y < height - 1) {
                    int n = p - 1 + width;
                    d[n] = d[n] + err * 3 / 16;
                }
                if (y < height - 1) {
                    int n = p + width;
                    d[n] = d[n] + err * 5 / 16;
                }
                if (x < width - 1 && y < height - 1) {
                    int n = p + width + 1;
                    d[n] = d[n] + err * 1 / 16;
                }
                ++x;
                ++p;
            }
        }
        out.setRGB(0, 0, width, height, dout, 0, width);
        return out;
    }

    public static BufferedImage ditherImageRandom(BufferedImage in) {
        BufferedImage out = new BufferedImage(in.getWidth(), in.getHeight(), 1);
        int width = in.getWidth();
        int height = in.getHeight();
        int[] d = in.getRGB(0, 0, width, height, null, 0, width);
        int[] dout = new int[width * height];
        int p = 0;
        int sum = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                int c = d[p];
                int gray = (int)(0.299 * (double)((c & 0xFF0000) >> 16) + 0.587 * (double)((c & 0xFF00) >> 8) + 0.114 * (double)(c & 0xFF));
                sum += gray;
                d[p] = gray;
                ++x;
                ++p;
            }
        }
        int thresh = sum / (width * height) / 2;
        p = 0;
        Random r = new Random();
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                int gray = d[p];
                int bw = r.nextInt(255) >= gray ? 0 : 255;
                dout[p] = bw | bw << 8 | bw << 16 | 0xFF000000;
                ++x;
                ++p;
            }
        }
        out.setRGB(0, 0, width, height, dout, 0, width);
        return out;
    }

    public static BufferedImage scaleImage(BufferedImage in, int newwidth, int newheight) {
        BufferedImage out = new BufferedImage(newwidth, newheight, 1);
        Graphics2D g = out.createGraphics();
        g.drawImage(in, 0, 0, newwidth, newheight, null);
        g.dispose();
        return out;
    }

    public static BufferedImage cloneImage(BufferedImage in) {
        int type = in.getType();
        int w = in.getWidth();
        int h = in.getHeight();
        BufferedImage out = new BufferedImage(w, h, type);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                out.setRGB(x, y, in.getRGB(x, y));
            }
        }
        return out;
    }

    public static BufferedImage rgbToHsv(BufferedImage image) {
        image = ImageUtil.convertImage(image, 1);
        DataBufferInt dbuf = (DataBufferInt)image.getRaster().getDataBuffer();
        int[] buf = dbuf.getData();
        int width = image.getWidth();
        int height = image.getHeight();
        int idx = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int hsv;
                int h;
                int s;
                int minrg;
                int min;
                int g;
                int r;
                int rgb = buf[idx];
                int b = rgb & 0xFF;
                int maxrg = r > g ? r : g;
                int max = b > maxrg ? b : maxrg;
                int delta = max - (min = b < (minrg = (r = rgb >> 16 & 0xFF) < (g = rgb >> 8 & 0xFF) ? r : g) ? b : minrg);
                if (delta == 0) {
                    delta = 1;
                }
                int v = max;
                if (max == 0) {
                    s = 0;
                    h = 0;
                } else {
                    s = 255 * delta / max;
                    if (r == max) {
                        h = 0 + 43 * (g - b) / delta;
                        if (h < 0) {
                            h += 256;
                        }
                    } else {
                        h = g == max ? 85 + 43 * (b - r) / delta : 170 + 43 * (r - g) / delta;
                    }
                }
                buf[idx] = hsv = v & 0xFF | (s & 0xFF) << 8 | (h & 0xFF) << 16;
                ++idx;
            }
        }
        return image;
    }

    public static BufferedImage channelSelect(BufferedImage image, int channel) {
        image = ImageUtil.convertImage(image, 1);
        int width = image.getWidth();
        int height = image.getHeight();
        DataBufferInt dbuf = (DataBufferInt)image.getRaster().getDataBuffer();
        int[] buf = dbuf.getData();
        int v = 0;
        if (channel <= 2) {
            channel = 2 - channel;
        }
        int idx = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgb = buf[idx];
                switch (channel) {
                    case 0: {
                        v = rgb & 0xFF;
                        break;
                    }
                    case 1: {
                        v = rgb >> 8 & 0xFF;
                        break;
                    }
                    case 2: {
                        v = rgb >> 16 & 0xFF;
                        break;
                    }
                    case 3: {
                        v = rgb >> 24 & 0xFF;
                    }
                }
                buf[idx] = v | v << 8 | v << 16;
                ++idx;
            }
        }
        return image;
    }
}

