/*
 * Decompiled with CFR 0.152.
 */
package maslab.data;

import java.util.HashMap;

public class SimpleProperties {
    public HashMap<String, String> properties = new HashMap();

    public void put(String k, String v) {
        this.properties.put(k, v);
    }

    public String get(String k) {
        return this.properties.get(k);
    }

    public String getString(String s, String defaultValue) {
        String v = this.get(s);
        try {
            if (v == null) {
                return defaultValue;
            }
            return v;
        }
        catch (Exception ex) {
            throw new RuntimeException("Property " + s + " was badly formatted: " + v);
        }
    }

    public String requireString(String s, String defaultValue) {
        String v = this.get(s);
        try {
            if (v == null) {
                throw new RuntimeException("Requires property " + s);
            }
            return v;
        }
        catch (Exception ex) {
            throw new RuntimeException("Require property " + s + " was badly formatted: " + v);
        }
    }

    public double requireDouble(String s) {
        String v = this.get(s);
        try {
            if (v == null) {
                throw new RuntimeException("Requires property " + s);
            }
            return Double.parseDouble(v);
        }
        catch (Exception ex) {
            throw new RuntimeException("Require property " + s + " was badly formatted: " + v);
        }
    }

    public int requireInt(String s) {
        String v = this.get(s);
        try {
            if (v == null) {
                throw new RuntimeException("Requires property " + s);
            }
            return Integer.parseInt(v);
        }
        catch (Exception ex) {
            throw new RuntimeException("Required property " + s + " was badly formatted: " + v);
        }
    }

    public boolean requireBoolean(String s) {
        String v = this.get(s);
        try {
            if (v == null) {
                throw new RuntimeException("Requires property " + s);
            }
            return Boolean.parseBoolean(v);
        }
        catch (Exception ex) {
            throw new RuntimeException("Required property " + s + " was badly formatted: " + v);
        }
    }

    public double getDouble(String s, double defaultValue) {
        String v = this.get(s);
        try {
            if (v == null) {
                return defaultValue;
            }
            return Double.parseDouble(v);
        }
        catch (Exception ex) {
            throw new RuntimeException("Property " + s + " was badly formatted: " + v);
        }
    }

    public int getInt(String s, int defaultValue) {
        String v = this.get(s);
        try {
            if (v == null) {
                return defaultValue;
            }
            return Integer.parseInt(v);
        }
        catch (Exception ex) {
            throw new RuntimeException("Property " + s + " was badly formatted: " + v);
        }
    }

    public boolean getBoolean(String s, boolean defaultValue) {
        String v = this.get(s);
        try {
            if (v == null) {
                return defaultValue;
            }
            return Boolean.parseBoolean(v);
        }
        catch (Exception ex) {
            throw new RuntimeException("Property " + s + " was badly formatted: " + v);
        }
    }
}

