/*
 * Decompiled with CFR 0.152.
 */
package maslab.odom;

import maslab.data.DataEvent;
import maslab.data.DataSource;
import maslab.data.SimpleProperties;
import maslab.odom.OdomData;
import maslab.util.Logger;

public class CarOdometryDataSource
extends DataSource {
    Logger log = new Logger(this);
    protected double a;
    protected double b;
    protected double L;
    protected double H;

    public CarOdometryDataSource(String channelName) {
        super(channelName);
    }

    @Override
    public DataEvent stringToEvent(double timestamp, String data) {
        String[] toks = data.split("\\s+");
        double velocityl = Double.parseDouble(toks[0]);
        double angle = Double.parseDouble(toks[1]);
        double dtime = Double.parseDouble(toks[2]);
        double velocity = velocityl / (1.0 - Math.tan(angle) * this.H / this.L);
        double dist = velocity * dtime;
        double dtheta = dist * Math.tan(angle) / this.L;
        double dx = dist * Math.cos(dtheta);
        double dy = dist * Math.sin(dtheta);
        return new OdomData(timestamp, dx, dy, dtheta);
    }

    @Override
    public String getParameters() {
        return String.format("alpha=%f beta=%f L=%f H=%f", this.a, this.b, this.L);
    }

    @Override
    public void setParameters(String s) {
        SimpleProperties sp = this.parseProperties(s);
        try {
            this.a = sp.requireDouble("alpha");
            this.b = sp.requireDouble("beta");
            this.L = sp.requireDouble("L");
            this.H = sp.requireDouble("H");
        }
        catch (RuntimeException ex) {
            this.log.error("Missing required data field.", ex);
        }
    }
}

