/*
 * Decompiled with CFR 0.152.
 */
package maslab.telemetry.botclient;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import maslab.telemetry.botclient.BotClient;
import maslab.telemetry.botclient.HueSaturationPlot;
import maslab.telemetry.botclient.Plugin;
import maslab.util.Logger;

public class ImagePlugin
implements Plugin,
ActionListener {
    static Logger log = new Logger("ImagePlugin");
    static final long serialVersionUID = 1001L;
    static final int BUFFER_WIDTH = 640;
    static final int BUFFER_HEIGHT = 480;
    BufferedImage i;
    ImageCanvas canvas;
    boolean paused = false;
    JButton pauseButton;
    JButton saveButton;
    JLabel colorLabel;
    JLabel redLabel;
    JLabel greenLabel;
    JLabel blueLabel;
    JLabel hueLabel;
    JLabel saturationLabel;
    JLabel brightnessLabel;
    JLabel xpixelLabel;
    JLabel ypixelLabel;
    JLabel fpsLabel;
    MouseColor mc;
    int currentType;
    static final int TYPE_JPEG = 1;
    static final int TYPE_RAW = 2;
    public static final String types = "jpegimage,rawimage";
    long fpsLastTime = 0L;
    int fpsFrameCount = 0;
    int downsampling = 1;
    int leftpad = 0;
    int toppad = 0;
    int drawwidth = 0;
    int drawheight = 0;
    JInternalFrame frame;

    public ImagePlugin(JInternalFrame frame) {
        this.frame = frame;
        frame.setTitle("No Channel");
        frame.setResizable(true);
        this.i = new BufferedImage(640, 480, 2);
        this.mc = new MouseColor();
        GridBagLayout gb2 = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        frame.getContentPane().setLayout(gb2);
        Container con = frame.getContentPane();
        this.canvas = new ImageCanvas();
        this.canvas.addMouseMotionListener(this.mc);
        this.canvas.addMouseListener(this.mc);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 10.0;
        c.weighty = 10.0;
        c.ipadx = 0;
        c.ipady = 0;
        c.fill = 1;
        c.anchor = 10;
        con.add((Component)this.canvas, c);
        JPanel panel = new JPanel();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.ipadx = 0;
        c.ipady = 0;
        c.fill = 1;
        c.anchor = 10;
        con.add((Component)panel, c);
        GridBagLayout gb = new GridBagLayout();
        panel.setLayout(gb);
        this.colorLabel = new JLabel();
        this.colorLabel.setPreferredSize(new Dimension(30, 30));
        this.colorLabel.setOpaque(true);
        this.colorLabel.setBackground(Color.red);
        c.gridwidth = 1;
        c.gridheight = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 30.0;
        c.weighty = 30.0;
        c.ipadx = 10;
        c.ipady = 10;
        c.fill = 0;
        c.anchor = 10;
        gb.setConstraints(this.colorLabel, c);
        panel.add(this.colorLabel);
        this.redLabel = new JLabel("R:");
        this.redLabel.setPreferredSize(new Dimension(45, 10));
        this.redLabel.setHorizontalAlignment(2);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        gb.setConstraints(this.redLabel, c);
        panel.add(this.redLabel);
        this.greenLabel = new JLabel("G:");
        this.greenLabel.setPreferredSize(new Dimension(45, 10));
        this.greenLabel.setHorizontalAlignment(2);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        gb.setConstraints(this.greenLabel, c);
        panel.add(this.greenLabel);
        this.blueLabel = new JLabel("B:");
        this.blueLabel.setPreferredSize(new Dimension(45, 10));
        this.blueLabel.setHorizontalAlignment(2);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 3;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        gb.setConstraints(this.blueLabel, c);
        panel.add(this.blueLabel);
        this.hueLabel = new JLabel("H:");
        this.hueLabel.setPreferredSize(new Dimension(45, 10));
        this.hueLabel.setHorizontalAlignment(2);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        gb.setConstraints(this.hueLabel, c);
        panel.add(this.hueLabel);
        this.saturationLabel = new JLabel("S:");
        this.saturationLabel.setPreferredSize(new Dimension(45, 10));
        this.saturationLabel.setHorizontalAlignment(2);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 2;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        gb.setConstraints(this.saturationLabel, c);
        panel.add(this.saturationLabel);
        this.brightnessLabel = new JLabel("V:");
        this.brightnessLabel.setPreferredSize(new Dimension(45, 10));
        this.brightnessLabel.setHorizontalAlignment(2);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 3;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        gb.setConstraints(this.brightnessLabel, c);
        panel.add(this.brightnessLabel);
        this.fpsLabel = new JLabel("fps:0");
        this.fpsLabel.setPreferredSize(new Dimension(45, 10));
        this.fpsLabel.setHorizontalAlignment(2);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 4;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        gb.setConstraints(this.fpsLabel, c);
        panel.add(this.fpsLabel);
        this.xpixelLabel = new JLabel("X:");
        this.xpixelLabel.setPreferredSize(new Dimension(45, 10));
        this.xpixelLabel.setHorizontalAlignment(2);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 4;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        gb.setConstraints(this.xpixelLabel, c);
        panel.add(this.xpixelLabel);
        this.ypixelLabel = new JLabel("Y:");
        this.ypixelLabel.setPreferredSize(new Dimension(45, 10));
        this.ypixelLabel.setHorizontalAlignment(2);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 5;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        gb.setConstraints(this.ypixelLabel, c);
        panel.add(this.ypixelLabel);
        this.saveButton = new JButton("Save");
        this.saveButton.addActionListener(this);
        this.saveButton.setPreferredSize(new Dimension(100, 10));
        c.gridwidth = 2;
        c.gridheight = 1;
        c.gridx = 6;
        c.gridy = 0;
        c.weightx = 30.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 13;
        gb.setConstraints(this.saveButton, c);
        panel.add(this.saveButton);
        this.pauseButton = new JButton("Pause");
        this.pauseButton.addActionListener(this);
        this.pauseButton.setPreferredSize(new Dimension(100, 10));
        c.gridwidth = 2;
        c.gridheight = 1;
        c.gridx = 6;
        c.gridy = 1;
        c.weightx = 30.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 13;
        gb.setConstraints(this.pauseButton, c);
        panel.add(this.pauseButton);
        frame.pack();
        frame.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals("Pause")) {
            this.pauseButton.setText("Resume");
            this.paused = true;
            return;
        }
        if (s.equals("Resume")) {
            this.pauseButton.setText("Pause");
            this.paused = false;
            return;
        }
        if (s.equals("Save")) {
            boolean oldpaused = this.paused;
            this.paused = true;
            int count = 0;
            File f = null;
            while (f == null || f.exists()) {
                f = new File("capture" + count + ".png");
                ++count;
            }
            try {
                ImageIO.write((RenderedImage)this.i, "png", f);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.frame, "Error writing to " + f);
            }
            finally {
                this.paused = oldpaused;
            }
        }
    }

    @Override
    public boolean addChannel(String name, String type) {
        if (this.frame.getTitle().equals("No Channel")) {
            this.frame.setTitle(name);
            if (type.equals("jpegimage")) {
                this.currentType = 1;
            }
            if (type.equals("rawimage")) {
                this.currentType = 2;
            }
            return true;
        }
        return false;
    }

    @Override
    public void removeChannel(String name) {
        this.frame.setTitle("No Channel");
        this.currentType = 0;
    }

    @Override
    public void messageReceived(String name, byte[] data) {
        if (!this.paused) {
            try {
                if (this.currentType == 1) {
                    this.handleJPEG(data);
                } else if (this.currentType == 2) {
                    this.handleRAW(data);
                } else {
                    log.warn("unknown image type: " + this.currentType);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void updateFps() {
        long timeNow = System.currentTimeMillis();
        long elapsedTime = timeNow - this.fpsLastTime;
        ++this.fpsFrameCount;
        if (this.fpsFrameCount > 10 || elapsedTime > 2000L) {
            float fps = (float)this.fpsFrameCount / ((float)elapsedTime / 1000.0f);
            this.fpsFrameCount = 0;
            this.fpsLastTime = timeNow;
            this.fpsLabel.setText("fps:" + (double)Math.round(fps * 10.0f) / 10.0);
        }
    }

    protected void handleJPEG(byte[] data) throws IOException {
        ByteArrayInputStream ins = new ByteArrayInputStream(data);
        this.i = ImageIO.read(ins);
        this.canvas.checkSize(this.i.getWidth(), this.i.getHeight());
        this.canvas.repaint();
        this.updateFps();
    }

    protected void handleRAW(byte[] data) throws IOException {
        DataInputStream dins = new DataInputStream(new ByteArrayInputStream(data));
        int w = dins.readInt();
        int h = dins.readInt();
        int d = dins.readInt();
        this.downsampling = dins.readInt();
        int inpos = 16;
        this.canvas.checkSize(w, h);
        int npixels = w * h;
        this.i = new BufferedImage(w, h, 1);
        int[] buf = ((DataBufferInt)this.i.getRaster().getDataBuffer()).getData();
        for (int bufpos = 0; bufpos < npixels; ++bufpos) {
            int rgb;
            int b = data[inpos++];
            int g = data[inpos++];
            int r = data[inpos++];
            buf[bufpos] = rgb = 0xFF000000 | (r &= 0xFF) << 16 | (g &= 0xFF) << 8 | (b &= 0xFF);
        }
        this.canvas.repaint();
        this.updateFps();
    }

    class ImageCanvas
    extends JPanel {
        public int imageWidth = 320;
        public int imageHeight = 240;
        boolean scaling = true;
        static final long serialVersionUID = 1001L;

        public ImageCanvas() {
            this.setPreferredSize(new Dimension(this.imageWidth, this.imageHeight));
            this.setSize(this.imageWidth, this.imageHeight);
        }

        @Override
        public void paint(Graphics g) {
            double aspect = (double)ImagePlugin.this.i.getWidth() / (double)ImagePlugin.this.i.getHeight();
            double width = this.getWidth();
            double height = width / aspect;
            if (height > (double)this.getHeight()) {
                height = this.getHeight();
                width = aspect * height;
            }
            if (this.scaling && width > (double)this.getWidth()) {
                width = this.imageWidth;
                height = this.imageHeight;
            }
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            ImagePlugin.this.leftpad = (int)((double)this.getWidth() - width) / 2;
            ImagePlugin.this.toppad = (int)((double)this.getHeight() - height) / 2;
            ImagePlugin.this.drawwidth = (int)width;
            ImagePlugin.this.drawheight = (int)height;
            g.drawImage(ImagePlugin.this.i, ImagePlugin.this.leftpad, ImagePlugin.this.toppad, (int)width, (int)height, null);
            ImagePlugin.this.mc.redisplay();
        }

        public void checkSize(int w, int h) {
            if (w != this.imageWidth || h != this.imageHeight) {
                int defaultW = w > 320 ? w : 320;
                int defaultH = h > 240 ? h : 240;
                ImagePlugin.this.canvas.setPreferredSize(new Dimension(defaultW, defaultH));
                ImagePlugin.this.canvas.setSize(defaultW, defaultH);
                ImagePlugin.this.frame.pack();
                this.imageWidth = w;
                this.imageHeight = h;
            }
        }
    }

    class MouseColor
    extends MouseAdapter
    implements MouseMotionListener {
        HueSaturationPlot hsp;
        int lastX = 0;
        int lastY = 0;
        int lastRawX = 0;
        int lastRawY = 0;

        MouseColor() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.hsp == null) {
                Container f;
                this.hsp = new HueSaturationPlot(150, 3);
                if (BotClient.aDesktop != null) {
                    f = new JInternalFrame("Hue/Saturation");
                    BotClient.aDesktop.add(f);
                    ((JInternalFrame)f).getContentPane().add(this.hsp);
                    ((JInternalFrame)f).pack();
                    ((JInternalFrame)f).addInternalFrameListener(new InternalFrameAdapter(){

                        @Override
                        public void internalFrameClosing(InternalFrameEvent e) {
                            MouseColor.this.hsp = null;
                        }
                    });
                    ((JInternalFrame)f).setClosable(true);
                    ((JComponent)f).setVisible(true);
                } else {
                    f = new JFrame("Hue/Saturation");
                    ((JFrame)f).getContentPane().add(this.hsp);
                    ((Window)f).pack();
                    ((Window)f).addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            MouseColor.this.hsp = null;
                        }
                    });
                    ((Window)f).setVisible(true);
                }
            }
            try {
                Color c = new Color(ImagePlugin.this.i.getRGB(this.getRealX(e), this.getRealY(e)));
                this.hsp.plotPoint(c);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }

        int getRealX(MouseEvent e) {
            ImageCanvas c = (ImageCanvas)e.getSource();
            int x = e.getX();
            x = (x - ImagePlugin.this.leftpad) * c.imageWidth / ImagePlugin.this.drawwidth;
            return x;
        }

        int getRealY(MouseEvent e) {
            ImageCanvas c = (ImageCanvas)e.getSource();
            int y = e.getY();
            y = (y - ImagePlugin.this.toppad) * c.imageHeight / ImagePlugin.this.drawheight;
            return y;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int rgb;
            int x = this.getRealX(e);
            int y = this.getRealY(e);
            this.lastX = x;
            this.lastY = y;
            this.lastRawX = e.getX();
            this.lastRawY = e.getY();
            try {
                rgb = ImagePlugin.this.i.getRGB(x, y);
            }
            catch (ArrayIndexOutOfBoundsException a) {
                return;
            }
            Color color = new Color(rgb);
            ImagePlugin.this.colorLabel.setBackground(color);
            ImagePlugin.this.colorLabel.repaint();
            int red = color.getRed();
            int blue = color.getBlue();
            int green = color.getGreen();
            float[] hsb = Color.RGBtoHSB(red, green, blue, null);
            int hue = (int)(hsb[0] * 255.0f);
            int saturation = (int)(hsb[1] * 255.0f);
            int brightness = (int)(hsb[2] * 255.0f);
            ImagePlugin.this.redLabel.setText("R:" + red);
            ImagePlugin.this.greenLabel.setText("G:" + green);
            ImagePlugin.this.blueLabel.setText("B:" + blue);
            ImagePlugin.this.hueLabel.setText("H:" + hue);
            ImagePlugin.this.saturationLabel.setText("S:" + saturation);
            ImagePlugin.this.brightnessLabel.setText("V:" + brightness);
            ImagePlugin.this.xpixelLabel.setText("X:" + this.lastX * ImagePlugin.this.downsampling);
            ImagePlugin.this.ypixelLabel.setText("Y:" + this.lastY * ImagePlugin.this.downsampling);
            ImagePlugin.this.xpixelLabel.repaint();
        }

        public void redisplay() {
            this.mouseMoved(new MouseEvent(ImagePlugin.this.canvas, 0, 0L, 0, this.lastRawX, this.lastRawY, 0, true));
        }
    }
}

