/*
 * Decompiled with CFR 0.152.
 */
package maslab.telemetry.botclient;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import maslab.telemetry.StatusEvent;
import maslab.telemetry.StatusListener;
import maslab.telemetry.botclient.Plugin;
import maslab.util.Logger;

public class ScopePlugin
extends JPanel
implements Plugin,
StatusListener {
    public static String types = "scope";
    public static Logger log = new Logger("ScopePlugin");
    static final long serialVersionUID = 1001L;
    JInternalFrame frame;
    ArrayList<Point> points;
    Color currentColor;
    double originX = 0.0;
    double originY = 175.0;
    int translateX = 0;
    int translateY = 0;
    double voltsPerPixel = -10.0;
    double msPerPixel = 50.0;
    boolean resync = true;
    long starttime;
    Scroller scroller;
    DecimalFormat formatter = new DecimalFormat();
    int xcursor = 0;
    int ycursor = 0;

    public ScopePlugin(JInternalFrame frame) {
        this.frame = frame;
        GridBagLayout gb2 = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        frame.getContentPane().setLayout(gb2);
        Container con = frame.getContentPane();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 10.0;
        c.weighty = 10.0;
        c.ipadx = 0;
        c.ipady = 0;
        c.fill = 1;
        c.anchor = 10;
        con.add((Component)this, c);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 10.0;
        c.weighty = 10.0;
        c.ipadx = 0;
        c.ipady = 0;
        c.fill = 1;
        c.anchor = 10;
        con.add((Component)new BottomPanel(), c);
        this.setPreferredSize(new Dimension(500, 350));
        frame.setResizable(true);
        frame.pack();
        frame.setVisible(true);
        this.points = new ArrayList();
        this.currentColor = Color.GREEN;
        Transformer t = new Transformer();
        this.addMouseMotionListener(t);
        this.addMouseListener(t);
        this.formatter.setMaximumFractionDigits(1);
        this.formatter.setMinimumFractionDigits(1);
    }

    @Override
    public boolean addChannel(String name, String type) {
        this.frame.setTitle(name);
        return true;
    }

    @Override
    public void removeChannel(String name) {
    }

    @Override
    public synchronized void messageReceived(String channel, byte[] data) {
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
            Point p = new Point();
            if (this.resync) {
                this.resync = false;
                this.starttime = dis.readLong();
                p.ms = 0.0;
                this.originX = this.getWidth();
                this.scroller = new Scroller();
                this.scroller.start();
            } else {
                p.ms = dis.readLong() - this.starttime;
            }
            p.volts = dis.readDouble();
            this.points.add(p);
            this.repaint();
        }
        catch (IOException ioe) {
            log.log(2, "Unexpected IOException", ioe);
        }
    }

    @Override
    public synchronized void paint(Graphics g) {
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.BLUE);
        g.drawLine(this.xcursor, -1000, this.xcursor, 1000);
        g.drawLine(-1000, this.ycursor, 1000, this.ycursor);
        g.setColor(this.currentColor);
        double xp = this.msPerPixel * ((double)this.xcursor - this.originX) / 1000.0;
        double yp = this.voltsPerPixel * ((double)this.ycursor - this.originY);
        String xs = this.formatter.format(xp);
        String ys = this.formatter.format(yp);
        g.drawString(xs + "sec   " + ys, 0, this.getHeight() - 5);
        g.translate((int)this.originX + this.translateX, (int)this.originY + this.translateY);
        Iterator<Point> i = this.points.iterator();
        int x = 0;
        int y = 0;
        boolean first = true;
        while (i.hasNext()) {
            Point p = i.next();
            int newx = (int)(p.ms / this.msPerPixel);
            int newy = (int)(p.volts / this.voltsPerPixel);
            if (first) {
                first = false;
            } else {
                g.drawLine(x, y, newx, newy);
            }
            x = newx;
            y = newy;
        }
    }

    @Override
    public void statusChanged(StatusEvent e) {
        if (e.name.equals("connected")) {
            if (e.booleanValue) {
                this.points = new ArrayList();
                this.resync = true;
                this.repaint();
            } else {
                this.scroller.off();
            }
        }
    }

    class BottomPanel
    extends JPanel
    implements ActionListener {
        JTextField xscale = new JTextField(6);
        JTextField yscale;
        static final long serialVersionUID = 1001L;

        public BottomPanel() {
            this.xscale.setText(String.valueOf(ScopePlugin.this.msPerPixel));
            this.yscale = new JTextField(6);
            this.yscale.setText(String.valueOf(-ScopePlugin.this.voltsPerPixel));
            this.add(new JLabel("ms per pixel:"));
            this.add(this.xscale);
            this.add(new JLabel("units per pixel:"));
            this.add(this.yscale);
            this.xscale.addActionListener(this);
            this.yscale.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            double oldXmax = (-ScopePlugin.this.originX + (double)this.getWidth()) * ScopePlugin.this.msPerPixel;
            ScopePlugin.this.voltsPerPixel = -Double.valueOf(this.yscale.getText()).doubleValue();
            ScopePlugin.this.msPerPixel = Double.valueOf(this.xscale.getText());
            ScopePlugin.this.originX = -oldXmax / ScopePlugin.this.msPerPixel + (double)this.getWidth();
        }
    }

    class Scroller
    extends Thread {
        boolean on = false;
        double msPerTick = 33.3;
        Date last;

        Scroller() {
        }

        @Override
        public void run() {
            this.on = true;
            this.last = new Date();
            while (this.on) {
                Date now;
                long ms;
                double pixelsPerTick;
                try {
                    Thread.sleep((int)this.msPerTick);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if ((pixelsPerTick = (double)(ms = (now = new Date()).getTime() - this.last.getTime()) / ScopePlugin.this.msPerPixel) == 0.0) continue;
                ScopePlugin.this.originX -= pixelsPerTick;
                this.last = now;
                ScopePlugin.this.repaint();
            }
        }

        void off() {
            this.on = false;
        }
    }

    class Transformer
    extends MouseAdapter
    implements MouseMotionListener {
        int dragOriginX;
        int dragOriginY;

        Transformer() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.dragOriginX = e.getX();
            this.dragOriginY = e.getY();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (ScopePlugin.this.scroller.on) {
                ScopePlugin.this.scroller.off();
            } else {
                ScopePlugin.this.scroller = new Scroller();
                ScopePlugin.this.scroller.start();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            ScopePlugin.this.translateX = e.getX() - this.dragOriginX;
            ScopePlugin.this.translateY = e.getY() - this.dragOriginY;
            ScopePlugin.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ScopePlugin.this.originX += (double)ScopePlugin.this.translateX;
            ScopePlugin.this.originY += (double)ScopePlugin.this.translateY;
            ScopePlugin.this.translateX = 0;
            ScopePlugin.this.translateY = 0;
            ScopePlugin.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            ScopePlugin.this.xcursor = e.getX();
            ScopePlugin.this.ycursor = e.getY();
            ScopePlugin.this.repaint();
        }
    }

    class Point {
        double ms;
        double volts;

        Point() {
        }
    }
}

