/*
 * Decompiled with CFR 0.152.
 */
package maslab.telemetry.channel;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import maslab.camera.ImageUtil;
import maslab.telemetry.channel.Channel;
import maslab.util.Logger;

public class ImageChannel
extends Channel {
    ByteArrayOutputStream imageBuffer;
    int downsampling = 1;
    boolean compression = false;
    Logger log = new Logger(this);

    protected void init(String name, boolean compression, int downsampling) {
        ImageChannel.assertInitialized();
        this.downsampling = downsampling;
        this.compression = false;
        this.nametype = compression ? name + "$" + "jpegimage" : name + "$" + "rawimage";
        jc.advertise(this.nametype);
        jc.setMaximumQueueSize(this.nametype, 32768);
        this.imageBuffer = new ByteArrayOutputStream();
    }

    public ImageChannel(String name) {
        this.init(name, false, 1);
    }

    public ImageChannel(String name, boolean compression) {
        this.init(name, compression, 1);
    }

    public ImageChannel(String name, boolean compression, int downsampling) {
        this.init(name, compression, downsampling);
    }

    public synchronized void publish(BufferedImage img) {
        if (!jc.publishing(this.nametype)) {
            return;
        }
        if (this.downsampling != 1) {
            img = ImageUtil.scaleImage(img, img.getWidth() / this.downsampling, img.getHeight() / this.downsampling);
        }
        if (!img.getRaster().getDataBuffer().getClass().toString().equals("class au.edu.jcu.v4l4j.V4L4JDataBuffer")) {
            img = ImageUtil.convertImage(img, 1);
        }
        this.publishRaw(img);
    }

    void publishRaw(BufferedImage img) {
        DataBuffer db = img.getRaster().getDataBuffer();
        if (db instanceof DataBufferInt) {
            this.publishRawInt(img, (DataBufferInt)db);
        } else if (db instanceof DataBufferByte) {
            this.publishRawByte(img, (DataBufferByte)db);
        } else if (db.getClass().toString().equals("class au.edu.jcu.v4l4j.V4L4JDataBuffer")) {
            this.publishRawV4L4J(img, db);
        } else {
            this.log.error("Unknown image type!");
        }
    }

    void publishRawInt(BufferedImage img, DataBufferInt dbuf) {
        int[] buf = dbuf.getData();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(128 + 4 * buf.length);
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeInt(img.getWidth());
            dos.writeInt(img.getHeight());
            dos.writeInt(3);
            dos.writeInt(this.downsampling);
            for (int i = 0; i < buf.length; ++i) {
                dos.writeByte(buf[i] & 0xFF);
                dos.writeByte(buf[i] >> 8 & 0xFF);
                dos.writeByte(buf[i] >> 16 & 0xFF);
            }
            dos.flush();
        }
        catch (IOException ioe) {
            return;
        }
        jc.publish(this.nametype, baos.toByteArray());
    }

    void publishRawByte(BufferedImage img, DataBufferByte dbuf) {
        byte[] buf = dbuf.getData();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(16 + buf.length);
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeInt(img.getWidth());
            dos.writeInt(img.getHeight());
            dos.writeInt(3);
            dos.writeInt(this.downsampling);
            dos.write(buf);
            dos.flush();
        }
        catch (IOException ioe) {
            return;
        }
        jc.publish(this.nametype, baos.toByteArray());
    }

    void publishRawV4L4J(BufferedImage img, DataBuffer dbuf) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(16 + dbuf.getSize());
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeInt(img.getWidth());
            dos.writeInt(img.getHeight());
            dos.writeInt(3);
            dos.writeInt(this.downsampling);
            for (int k = 0; k < dbuf.getSize() / 3; ++k) {
                dos.writeByte(dbuf.getElem(0, k * 3 + 2));
                dos.writeByte(dbuf.getElem(0, k * 3 + 1));
                dos.writeByte(dbuf.getElem(0, k * 3));
            }
            dos.flush();
        }
        catch (IOException ioe) {
            return;
        }
        jc.publish(this.nametype, baos.toByteArray());
    }
}

