/*
 * Decompiled with CFR 0.152.
 */
package maslab.test;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import maslab.camera.Camera;
import maslab.telemetry.JugLoggerPublisher;
import maslab.telemetry.channel.ImageChannel;
import maslab.util.Logger;

public class ColorTest {
    Logger log = new Logger(this);
    ImageChannel camChannel = new ImageChannel("Camera");
    ImageChannel pngChannel = new ImageChannel("PNG Image");
    ImageChannel jpgChannel = new ImageChannel("JPG Image");
    JugLoggerPublisher logPublisher = new JugLoggerPublisher("LogMessage");
    Camera cam;

    public static void main(String[] args) {
        ColorTest app = new ColorTest();
        app.run();
    }

    public ColorTest() {
        try {
            this.cam = Camera.makeCamera();
        }
        catch (Exception ex) {
            System.out.println("Couldn't connect to camera: " + ex);
            return;
        }
        this.logPublisher.setLevel("TeleDemo", 4);
        this.logPublisher.setGlobalLevel(2);
    }

    public void run() {
        while (true) {
            BufferedImage b = this.cam.capture();
            System.out.println("Cam type: " + b.getType());
            b.setRGB(0, 0, Color.red.getRGB());
            System.out.println(String.format("Red:   %8X", Color.red.getRGB()));
            System.out.println(String.format("Green: %8X", Color.green.getRGB()));
            System.out.println(String.format("blue:  %8X", Color.blue.getRGB()));
            this.camChannel.publish(b);
            try {
                ImageIO.write((RenderedImage)b, "png", new File("/tmp/foo.png"));
                ImageIO.write((RenderedImage)b, "jpg", new File("/tmp/foo.jpg"));
                BufferedImage png = ImageIO.read(new File("/tmp/foo.png"));
                BufferedImage jpg = ImageIO.read(new File("/tmp/foo.jpg"));
                System.out.println("PNG type: " + png.getType());
                System.out.println("JPG type: " + jpg.getType());
                this.pngChannel.publish(png);
                this.jpgChannel.publish(jpg);
            }
            catch (IOException ex) {
                this.log.error("Ack", ex);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

