/*
 * Decompiled with CFR 0.152.
 */
package orc;

import orc.AnalogInput;
import orc.Orc;
import orc.OrcStatus;

public class Gyro {
    Orc orc;
    int port;
    double SAMPLE_HZ;
    double v0;
    double mvPerDegPerSec;
    double radPerSecPerLSB = 5.32638E-5;
    long integratorOffset;
    int integratorCountOffset;
    boolean calibrated;
    double voltsPerLSB = 6.103515625E-5;
    double theta = 0.0;

    public Gyro(Orc orc, int port) {
        this(orc, port, 0.005);
    }

    public Gyro(Orc orc, int port, double voltsPerDegPerSec) {
        assert (port >= 0 && port <= 2);
        this.orc = orc;
        this.port = port;
        double lsbPerDegPerSec = 1.0 / this.voltsPerLSB * voltsPerDegPerSec;
        double degPerSecPerLSB = 1.0 / lsbPerDegPerSec;
        this.radPerSecPerLSB = Math.toRadians(degPerSecPerLSB);
        this.reset();
    }

    public void reset() {
        OrcStatus status = this.orc.getStatus();
        this.integratorOffset = status.gyroIntegrator[this.port];
        this.integratorCountOffset = status.gyroIntegratorCount[this.port];
        this.theta = 0.0;
    }

    public synchronized double getTheta() {
        if (!this.calibrated) {
            System.out.println("orc.Gyro: Must calibrate before calling getTheta!()");
            this.calibrated = true;
            return this.theta;
        }
        OrcStatus s = this.orc.getStatus();
        double integrator = s.gyroIntegrator[this.port] - this.integratorOffset;
        double integratorCount = s.gyroIntegratorCount[this.port] - this.integratorCountOffset;
        if (integratorCount == 0.0) {
            return this.theta;
        }
        double dt = integratorCount / this.SAMPLE_HZ;
        double averageIntegrator = integrator / integratorCount - this.v0;
        this.theta += averageIntegrator * dt * this.radPerSecPerLSB;
        this.integratorOffset = s.gyroIntegrator[this.port];
        this.integratorCountOffset = s.gyroIntegratorCount[this.port];
        return this.theta;
    }

    public void calibrate(double seconds) {
        OrcStatus s0 = this.orc.getStatus();
        try {
            Thread.sleep((int)(seconds * 1000.0));
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        OrcStatus s1 = this.orc.getStatus();
        double dt = (double)(s1.utimeOrc - s0.utimeOrc) / 1000000.0;
        double dv = s1.gyroIntegrator[this.port] - s0.gyroIntegrator[this.port];
        double ds = s1.gyroIntegratorCount[this.port] - s0.gyroIntegratorCount[this.port];
        this.SAMPLE_HZ = ds / dt;
        this.v0 = dv / ds;
        System.out.printf("Requested calib t: %15f seconds\n", seconds);
        System.out.printf("Actual calib t:    %15f seconds\n", dt);
        System.out.printf("Integrator change: %15.1f ADC LSBs\n", dv);
        System.out.printf("Integrator counts: %15.1f counts\n", ds);
        System.out.printf("Sample rate:       %15f Hz\n", this.SAMPLE_HZ);
        System.out.printf("calibrated at:     %15f ADC LSBs (about %f V)\n", this.v0, this.v0 / 65535.0 * 5.0);
        this.calibrated = true;
    }

    public static void main(String[] args) {
        int port = 0;
        Orc orc = Orc.makeOrc();
        Gyro gyro = new Gyro(orc, port);
        AnalogInput ain = new AnalogInput(orc, port);
        double calibrateTime = 3.0;
        System.out.println("Calibrating for " + calibrateTime + " seconds...");
        gyro.calibrate(calibrateTime);
        double starttime = (double)System.currentTimeMillis() / 1000.0;
        while (true) {
            double rad = gyro.getTheta();
            double dt = (double)System.currentTimeMillis() / 1000.0 - starttime;
            System.out.printf("\r t=%15f V=%15f theta=%15f rad (%15f deg)", dt, ain.getVoltage(), rad, Math.toDegrees(rad));
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
            }
        }
    }
}

