/*
 * Decompiled with CFR 0.152.
 */
package orc;

import orc.Orc;

public class TLC3548 {
    Orc orc;
    int maxclk = 2500000;
    int spo = 0;
    int sph = 1;
    int nbits = 16;
    boolean shortSampling = false;
    boolean externalReference = true;

    public TLC3548(Orc orc) {
        this.orc = orc;
        orc.spiTransaction(this.maxclk, this.spo, this.sph, this.nbits, new int[]{40960});
        int flag = 0;
        if (this.externalReference) {
            flag |= 0x800;
        }
        if (this.shortSampling) {
            flag |= 0x200;
        }
        orc.spiTransaction(this.maxclk, this.spo, this.sph, this.nbits, new int[]{0xA000 | flag});
    }

    public int beginConversion(int port) {
        int[] rx = this.orc.spiTransaction(this.maxclk, this.spo, this.sph, this.nbits, new int[]{port << 12, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        return rx[0];
    }

    public static void main(String[] args) {
        Orc orc = Orc.makeOrc();
        TLC3548 tlc = new TLC3548(orc);
        while (true) {
            for (int i = 0; i < 8; ++i) {
                System.out.printf("%04x  ", tlc.beginConversion(i));
            }
            System.out.printf("\n", new Object[0]);
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

