/*
 * Decompiled with CFR 0.152.
 */
package orc.spy;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.HashMap;

public class WeightedGridLayout
implements LayoutManager {
    int hgap;
    int vgap;
    double[] columnWeights;
    int cols;
    int rows;
    HashMap<Integer, Double> rowWeightsMap = new HashMap();
    double defaultRowWeight = 0.0;
    double[] rowWeights = null;
    int minimumWidth = 0;
    int minimumHeight = 0;
    int[] minimumColumnWidth;
    int[] minimumRowHeight;

    public WeightedGridLayout(double[] columnWeights, int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
        this.columnWeights = this.normalizeSumToOne(columnWeights);
        this.cols = columnWeights.length;
    }

    public WeightedGridLayout(double[] columnWeights) {
        this(columnWeights, 4, 4);
    }

    public void setDefaultRowWeight(double v) {
        this.defaultRowWeight = v;
    }

    public void setRowWeight(int row, double v) {
        this.rowWeightsMap.put(row, v);
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    Component getComponentXY(Container parent, int x, int y) {
        return parent.getComponents()[x + y * this.cols];
    }

    int sum(int[] v) {
        int acc = 0;
        for (int i = 0; i < v.length; ++i) {
            acc += v[i];
        }
        return acc;
    }

    double[] normalizeSumToOne(double[] v) {
        double acc = 0.0;
        for (int i = 0; i < v.length; ++i) {
            acc += v[i];
        }
        double[] res = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            res[i] = acc == 0.0 ? 1.0 / (double)v.length : v[i] / acc;
        }
        return res;
    }

    void computeGeometry(Container parent) {
        this.rows = parent.getComponents().length / this.cols;
        this.rowWeights = new double[this.rows];
        for (int i = 0; i < this.rowWeights.length; ++i) {
            this.rowWeights[i] = this.rowWeightsMap.get(i) == null ? this.defaultRowWeight : this.rowWeightsMap.get(i);
        }
        this.rowWeights = this.normalizeSumToOne(this.rowWeights);
        this.minimumColumnWidth = new int[this.cols];
        this.minimumRowHeight = new int[this.rows];
        for (int col = 0; col < this.cols; ++col) {
            for (int row = 0; row < this.rows; ++row) {
                Dimension thisdim = this.getComponentXY(parent, col, row).getMinimumSize();
                this.minimumColumnWidth[col] = (int)Math.max((double)this.minimumColumnWidth[col], thisdim.getWidth());
                this.minimumRowHeight[row] = (int)Math.max((double)this.minimumRowHeight[row], thisdim.getHeight());
            }
        }
        this.minimumWidth = this.sum(this.minimumColumnWidth) + this.hgap * (this.cols - 1);
        this.minimumHeight = this.sum(this.minimumRowHeight) + this.vgap * (this.rows - 1);
    }

    public void layoutContainer(Container parent) {
        int row;
        this.computeGeometry(parent);
        int extraWidth = parent.getWidth() - this.minimumWidth;
        int extraHeight = parent.getHeight() - this.minimumHeight;
        int[] columnWidth = new int[this.cols];
        for (int col = 0; col < this.cols; ++col) {
            columnWidth[col] = (int)((double)this.minimumColumnWidth[col] + this.columnWeights[col] * (double)extraWidth);
        }
        int[] rowHeight = new int[this.rows];
        for (int row2 = 0; row2 < this.rows; ++row2) {
            rowHeight[row2] = (int)((double)this.minimumRowHeight[row2] + this.rowWeights[row2] * (double)extraHeight);
        }
        int[] columnPosition = new int[this.cols];
        for (int col = 1; col < this.cols; ++col) {
            int n = col;
            columnPosition[n] = columnPosition[n] + (columnPosition[col - 1] + columnWidth[col - 1]);
        }
        int[] rowPosition = new int[this.rows];
        for (row = 1; row < this.rows; ++row) {
            int n = row;
            rowPosition[n] = rowPosition[n] + (rowPosition[row - 1] + rowHeight[row - 1]);
        }
        for (row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.cols; ++col) {
                Component c = this.getComponentXY(parent, col, row);
                c.setSize(new Dimension(columnWidth[col], rowHeight[row]));
                c.setLocation(new Point(columnPosition[col], rowPosition[row]));
            }
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        this.computeGeometry(parent);
        return new Dimension(this.minimumWidth, this.minimumHeight);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.minimumLayoutSize(parent);
    }

    public void removeLayoutComponent(Component comp) {
    }
}

